/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.RelationshipListAccess;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/connections/UIPendingRelation.gtmpl", events={@EventConfig(listeners={DenyContactActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPendingRelation
extends UIContainer {
    private static final String iteratorID_ = "UIPageIteratorPendingRelation";
    private static final String INVITATION_REVOKED_INFO = "UIPendingRelation.label.RevokedInfo";
    private static final String PENDING_STATUS = "pending";
    UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIPageIteratorPendingRelation");
    UIProfileUserSearch uiProfileUserSearchPending = null;
    private List<Identity> identityList;
    private static final int FIRST_PAGE = 1;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public UIPendingRelation() throws Exception {
        this.addChild((UIComponent)this.uiPageIterator_);
        this.uiProfileUserSearchPending = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.uiProfileUserSearchPending.setTypeOfRelation(PENDING_STATUS);
        this.addChild((UIComponent)this.uiProfileUserSearchPending);
    }

    public List<Relationship> getPendingRelationList() throws Exception {
        List<Relationship> listRelationShip = this.getPendingRelationships();
        if (listRelationShip == null) {
            return null;
        }
        int currentPage = this.uiPageIterator_.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new RelationshipListAccess(listRelationShip), 5);
        this.uiPageIterator_.setPageList((PageList)pageList);
        if (this.uiProfileUserSearchPending.isNewSearch()) {
            this.uiPageIterator_.setCurrentPage(1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
        this.uiProfileUserSearchPending.setNewSearch(false);
        return this.uiPageIterator_.getCurrentPageData();
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    private List<Relationship> getPendingRelationships() throws Exception {
        List<Identity> matchIdentities = this.getIdentityList();
        return Utils.getRelationshipManager().getPending(Utils.getOwnerIdentity(), matchIdentities);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIPendingRelation> {
        public void execute(Event<UIPendingRelation> event) throws Exception {
            UIPendingRelation uiPending = (UIPendingRelation)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiPending.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiPending.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyContactActionListener
    extends EventListener<UIPendingRelation> {
        public void execute(Event<UIPendingRelation> event) throws Exception {
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(userId);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), requestedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIPendingRelation.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().deny(relationship);
        }
    }
}

