/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UIManageInvitationSpaces.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class})})
public class UIManageInvitationSpaces
extends UIContainer {
    private static final String MSG_ERROR_ACCEPT_INVITATION = "UIManageInvitationSpaces.msg.error_accept_invitation";
    private static final String MSG_ERROR_DENY_INVITATION = "UIManageInvitationSpaces.msg.error_deny_invitation";
    private static final String SPACE_DELETED_INFO = "UIManageInvitationSpaces.msg.DeletedInfo";
    private static final String INVITATION_REVOKED_INFO = "UIManageInvitationSpaces.msg.RevokedInfo";
    private static final String INCOMING_STATUS = "incoming";
    private static final String SEARCH_ALL = "All";
    private static final int FIRST_PAGE = 1;
    public static final Integer LEADER = 1;
    public static final Integer MEMBER = 2;
    private UIPageIterator iterator;
    private final Integer SPACES_PER_PAGE = 4;
    private final String ITERATOR_ID = "UIIteratorInvitationSpaces";
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManageInvitationSpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(INCOMING_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorInvitationSpaces");
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public List<Space> getInvitationSpaces() throws Exception {
        List userSpaces = Utils.getSpaceService().getInvitedSpaces(Utils.getViewerRemoteId());
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public List<Space> getInvitedSpaces() throws Exception {
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getInvitedSpaceNames());
        return this.getDisplayInvitedSpace(this.iterator);
    }

    public int getRole(String spaceId) throws SpaceException {
        SpaceService spaceService = Utils.getSpaceService();
        if (spaceService.hasSettingPermission(spaceService.getSpaceById(spaceId), Utils.getViewerRemoteId())) {
            return LEADER;
        }
        return MEMBER;
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    private List<String> getInvitedSpaceNames() throws Exception {
        List<Space> invitedSpaces = this.getInvitationSpaces();
        ArrayList<String> invitedSpaceNames = new ArrayList<String>();
        for (Space space : invitedSpaces) {
            invitedSpaceNames.add(space.getDisplayName());
        }
        return invitedSpaceNames;
    }

    private List<Space> getDisplayInvitedSpace(UIPageIterator pageIterator_) throws Exception {
        int currentPage = pageIterator_.getCurrentPage();
        SpaceService spaceService = Utils.getSpaceService();
        String userId = Utils.getViewerRemoteId();
        String selectedChar = this.uiSpaceSearch.getSelectedChar();
        String spaceNameSearch = this.uiSpaceSearch.getSpaceNameSearch();
        LazyPageList pageList = null;
        if (selectedChar == null && spaceNameSearch == null || selectedChar != null && selectedChar.equals(SEARCH_ALL)) {
            pageList = new LazyPageList(spaceService.getInvitedSpacesWithListAccess(userId), this.SPACES_PER_PAGE.intValue());
        } else {
            SpaceFilter spaceFilter = null;
            spaceFilter = selectedChar != null ? new SpaceFilter(selectedChar.charAt(0)) : new SpaceFilter(spaceNameSearch);
            pageList = new LazyPageList(spaceService.getInvitedSpacesByFilter(userId, spaceFilter), this.SPACES_PER_PAGE.intValue());
        }
        pageIterator_.setPageList((PageList)pageList);
        int availablePage = pageIterator_.getAvailablePage();
        if (this.uiSpaceSearch.isNewSearch()) {
            pageIterator_.setCurrentPage(1);
        } else if (currentPage > availablePage) {
            pageIterator_.setCurrentPage(availablePage);
        } else {
            pageIterator_.setCurrentPage(currentPage);
        }
        this.uiSpaceSearch.setNewSearch(false);
        return pageIterator_.getCurrentPageData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            SpaceService spaceService = Utils.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = Utils.getViewerRemoteId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvitedUser(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            spaceService.removeInvitedUser(space, userId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            SpaceService spaceService = Utils.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = Utils.getViewerRemoteId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvitedUser(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            spaceService.addMember(space, userId);
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UserPortalConfig userPortalConfig = uiPortalApp.getUserPortalConfig();
            List navigations = userPortalConfig.getNavigations();
            PageNavigation spaceNavigation = SpaceUtils.getGroupNavigation((String)space.getGroupId());
            for (PageNavigation navi : navigations) {
                if (!navi.getOwner().equals(spaceNavigation.getOwner())) continue;
                spaceNavigation = navi;
                break;
            }
            SpaceUtils.setNavigation((PageNavigation)spaceNavigation);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }
}

