/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.event.LifeCycleListener;
import org.gatein.mop.api.Model;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.core.api.MOPService;
import org.gatein.mop.core.api.content.CustomizationContextResolver;
import org.gatein.mop.core.api.workspace.GroupSite;
import org.gatein.mop.core.api.workspace.NavigationImpl;
import org.gatein.mop.core.api.workspace.PageImpl;
import org.gatein.mop.core.api.workspace.PageLinkImpl;
import org.gatein.mop.core.api.workspace.PortalSite;
import org.gatein.mop.core.api.workspace.SiteImpl;
import org.gatein.mop.core.api.workspace.UIBodyImpl;
import org.gatein.mop.core.api.workspace.UIComponentImpl;
import org.gatein.mop.core.api.workspace.UIContainerImpl;
import org.gatein.mop.core.api.workspace.UIWindowImpl;
import org.gatein.mop.core.api.workspace.URLLinkImpl;
import org.gatein.mop.core.api.workspace.UserSite;
import org.gatein.mop.core.api.workspace.WorkspaceImpl;
import org.gatein.mop.core.api.workspace.WorkspaceObjectImpl;
import org.gatein.mop.core.api.workspace.content.AbstractCustomization;
import org.gatein.mop.core.api.workspace.content.ContextSpecialization;

public class ModelImpl
implements Model {
    private static final Map<ObjectType<?>, Class<? extends WorkspaceObjectImpl>> typeToClassImpl;
    private final ChromatticSession session;
    private WorkspaceImpl workspace;
    private final MOPService mop;
    private final CustomizationContextResolver customizationContextResolver = new CustomizationContextResolver(){

        @Override
        public CustomizationContext resolve(String contextType, String contextId) {
            if ("workspace".equals(contextType)) {
                return (CustomizationContext)ModelImpl.this.findObjectById(ObjectType.WINDOW, contextId);
            }
            return ((ModelImpl)ModelImpl.this).mop.customizationContextResolvers.resolve(contextType, contextId);
        }
    };
    private final LifeCycleListener contextualizer = new LifeCycleListener(){

        public void created(Object o) {
            ModelImpl.this.inject(o, false);
        }

        public void loaded(String id, String path, String name, Object o) {
            ModelImpl.this.inject(o, true);
        }

        public void added(String id, String path, String name, Object o) {
            ModelImpl.this.inject(o, true);
        }

        public void removed(String id, String path, String name, Object o) {
        }
    };

    public ModelImpl(MOPService mop, ChromatticSession session) {
        this.session = session;
        this.mop = mop;
        session.addEventListener((EventListener)this.contextualizer);
    }

    public ChromatticSession getSession() {
        return this.session;
    }

    public Workspace getWorkspace() {
        return this.getWorkspaceImpl();
    }

    public <A> A getAdapter(Object o, Class<A> adaptedType, boolean adapt) {
        Class<A> adapterType = this.mop.getConcreteAdapterType(adaptedType);
        if (adapterType == null) {
            adapterType = adaptedType;
        }
        return this._getAdapter(o, adapterType, adapt);
    }

    private <A> A _getAdapter(Object o, Class<A> type, boolean adapt) {
        Object a = this.session.getEmbedded(o, type);
        if (a == null && adapt) {
            a = this.session.create(type);
            this.session.setEmbedded(o, type, a);
        }
        return (A)a;
    }

    private WorkspaceImpl getWorkspaceImpl() {
        if (this.workspace == null) {
            this.workspace = (WorkspaceImpl)this.session.findByPath(WorkspaceImpl.class, "mop:workspace");
            if (this.workspace == null) {
                this.workspace = (WorkspaceImpl)this.session.insert(WorkspaceImpl.class, "mop", "workspace");
            }
        }
        return this.workspace;
    }

    public void save() {
        this.session.save();
    }

    public void close() {
        this.session.close();
    }

    public Customization<?> findCustomizationById(String id) {
        return (Customization)this.session.findById(Customization.class, id);
    }

    public <O extends WorkspaceObject> Iterator<O> findObject(ObjectType<O> type, String statement) {
        Class<? extends WorkspaceObjectImpl> impl = typeToClassImpl.get(type);
        return this.session.createQueryBuilder(impl).where(statement).get().objects();
    }

    public String pathOf(WorkspaceObject o) {
        return this.session.getPath((Object)o);
    }

    public <O extends WorkspaceObject> O findObjectByPath(ObjectType<? extends O> type, String path) {
        Class t = type.getJavaType();
        return (O)((WorkspaceObject)this.session.findByPath(t, path));
    }

    private void inject(Object o, boolean persistent) {
        if (o instanceof AbstractCustomization) {
            ((AbstractCustomization)o).session = this.session;
            ((AbstractCustomization)o).registry = this.mop.contentManagerRegistry;
        } else if (o instanceof ContextSpecialization) {
            ((ContextSpecialization)o).setCustomizationContextResolver(this.customizationContextResolver);
        } else if (o instanceof WorkspaceObjectImpl) {
            ((WorkspaceObjectImpl)o).model = this;
        }
    }

    public <O extends WorkspaceObject> O findObjectById(ObjectType<O> type, String id) {
        Class<? extends WorkspaceObjectImpl> impl = typeToClassImpl.get(type);
        WorkspaceObjectImpl object = (WorkspaceObjectImpl)this.session.findById(impl, id);
        if (object != null) {
            return (O)type.cast((Object)object);
        }
        return null;
    }

    static {
        HashMap tmp = new HashMap();
        tmp.put(ObjectType.ANY, WorkspaceObjectImpl.class);
        tmp.put(ObjectType.WORKSPACE, WorkspaceImpl.class);
        tmp.put(ObjectType.SITE, SiteImpl.class);
        tmp.put(ObjectType.PORTAL_SITE, PortalSite.class);
        tmp.put(ObjectType.GROUP_SITE, GroupSite.class);
        tmp.put(ObjectType.USER_SITE, UserSite.class);
        tmp.put(ObjectType.PAGE, PageImpl.class);
        tmp.put(ObjectType.NAVIGATION, NavigationImpl.class);
        tmp.put(ObjectType.COMPONENT, UIComponentImpl.class);
        tmp.put(ObjectType.BODY, UIBodyImpl.class);
        tmp.put(ObjectType.CONTAINER, UIContainerImpl.class);
        tmp.put(ObjectType.WINDOW, UIWindowImpl.class);
        tmp.put(ObjectType.PAGE_LINK, PageLinkImpl.class);
        tmp.put(ObjectType.URL_LINK, URLLinkImpl.class);
        typeToClassImpl = tmp;
    }
}

