/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import java.util.List;
import java.util.Map;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.Destroy;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.link.Link;
import org.gatein.mop.api.workspace.link.PageLink;
import org.gatein.mop.core.api.workspace.LinkImpl;
import org.gatein.mop.core.api.workspace.NavigationContainer;
import org.gatein.mop.core.api.workspace.PageLinkImpl;
import org.gatein.mop.core.api.workspace.SiteImpl;
import org.gatein.mop.core.api.workspace.TemplatizedImpl;
import org.gatein.mop.core.api.workspace.URLLinkImpl;
import org.gatein.mop.core.api.workspace.WorkspaceObjectImpl;

@PrimaryType(name="mop:navigation")
public abstract class NavigationImpl
extends WorkspaceObjectImpl
implements Navigation {
    @OneToOne
    @MappedBy(value="mop:rootnavigation")
    public abstract SiteImpl getParentSite();

    @OneToOne
    @MappedBy(value="mop:children")
    @Owner
    public abstract NavigationContainer getChildrenContainer();

    @ManyToOne
    public abstract NavigationContainer getParentContainer();

    @OneToOne
    @MappedBy(value="mop:link")
    @Owner
    public abstract LinkImpl getLink();

    public abstract LinkImpl setLink(LinkImpl var1);

    @Create
    public abstract NavigationImpl createNavigation(String var1);

    @Create
    public abstract URLLinkImpl createURLTarget();

    @Create
    public abstract PageLinkImpl createPageLink();

    @Destroy
    public abstract void destroy();

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract TemplatizedImpl getTemplatized();

    public abstract void setTemplatized(TemplatizedImpl var1);

    @Override
    public String getName() {
        return this.getNodeName();
    }

    public void setName(String name) {
        NavigationContainer parent = this.getParentContainer();
        Map<String, NavigationImpl> map = parent.getNavigationMap();
        map.put(name, this);
    }

    public ObjectType<? extends Navigation> getObjectType() {
        return ObjectType.NAVIGATION;
    }

    public NavigationImpl getParent() {
        NavigationContainer parent = this.getParentContainer();
        if (parent != null) {
            return parent.getOwner();
        }
        return null;
    }

    public List<Navigation> getChildren() {
        NavigationContainer childrenContainer = this.getChildrenContainer();
        return childrenContainer.getNavigationList();
    }

    public Navigation getChild(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        NavigationContainer childrenContainer = this.getChildrenContainer();
        return childrenContainer.getNavigationMap().get(name);
    }

    public NavigationImpl addChild(String name) {
        NavigationContainer childrenContainer = this.getChildrenContainer();
        return childrenContainer.addNavigation(name);
    }

    public <L extends Link> L linkTo(ObjectType<L> linkType) {
        this.setLink(null);
        PageLinkImpl link = null;
        if (linkType != null) {
            if (linkType.getJavaType().equals(PageLink.class)) {
                PageLinkImpl pl = this.createPageLink();
                this.setLink(pl);
                link = pl;
            } else {
                throw new UnsupportedOperationException("Links of type " + linkType + " are not supported");
            }
        }
        return (L)link;
    }

    public Site getSite() {
        SiteImpl parent = this.getParentSite();
        if (parent != null) {
            return parent;
        }
        return this.getParent().getSite();
    }
}

