/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.management.MBeanServer;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class J2EEServerInfo {
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.container.J2EEServerInfo");
    public static final String EXO_CONF_PARAM = "exo.conf.dir";
    public static final String EXO_CONF_DIR_NAME_PARAM = "exo.conf.dir.name";
    private String serverName_;
    private String serverHome_;
    private String exoConfDir_;
    protected String sharedLibDirecotry_;
    protected String appDeployDirecotry_;
    protected MBeanServer mbeanServer;

    public J2EEServerInfo() {
        String exoConfHome;
        String jonasHome = PrivilegedSystemHelper.getProperty((String)"jonas.base");
        String jbossHome = PrivilegedSystemHelper.getProperty((String)"jboss.home.dir");
        String jettyHome = PrivilegedSystemHelper.getProperty((String)"jetty.home");
        String websphereHome = PrivilegedSystemHelper.getProperty((String)"was.install.root");
        String weblogicHome = PrivilegedSystemHelper.getProperty((String)"wls.home");
        String catalinaHome = PrivilegedSystemHelper.getProperty((String)"catalina.home");
        String testHome = PrivilegedSystemHelper.getProperty((String)"maven.exoplatform.dir");
        String confDirName = PrivilegedSystemHelper.getProperty((String)EXO_CONF_DIR_NAME_PARAM, (String)"exo-conf");
        if (jonasHome != null) {
            this.serverName_ = "jonas";
            this.serverHome_ = jonasHome;
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        } else if (jbossHome != null) {
            this.serverName_ = "jboss";
            this.serverHome_ = jbossHome;
            String jbossConfigUrl = PrivilegedSystemHelper.getProperty((String)"jboss.server.config.url");
            if (jbossConfigUrl != null) {
                try {
                    this.exoConfDir_ = new File(new File(new URI(jbossConfigUrl)), confDirName).getAbsolutePath();
                }
                catch (Throwable e) {
                    this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
                }
            } else {
                this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
            }
            try {
                Class clazz = (Class)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Class>(){

                    @Override
                    public Class run() throws Exception {
                        return Thread.currentThread().getContextClassLoader().loadClass("org.jboss.mx.util.MBeanServerLocator");
                    }
                });
                Method m = clazz.getMethod("locateJBoss", new Class[0]);
                this.mbeanServer = (MBeanServer)m.invoke(null, new Object[0]);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        } else if (jettyHome != null) {
            this.serverName_ = "jetty";
            this.serverHome_ = jettyHome;
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        } else if (websphereHome != null) {
            this.serverName_ = "websphere";
            this.serverHome_ = websphereHome;
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        } else if (weblogicHome != null) {
            this.serverName_ = "weblogic";
            this.serverHome_ = weblogicHome;
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        } else if (catalinaHome != null) {
            this.serverName_ = "tomcat";
            this.serverHome_ = catalinaHome;
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        } else if (testHome != null) {
            this.serverName_ = "test";
            this.serverHome_ = testHome;
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        } else {
            this.serverName_ = "standalone";
            this.serverHome_ = PrivilegedSystemHelper.getProperty((String)"user.dir");
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        }
        if (this.mbeanServer == null) {
            this.mbeanServer = (MBeanServer)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<MBeanServer>(){

                @Override
                public MBeanServer run() {
                    return ManagementFactory.getPlatformMBeanServer();
                }
            });
        }
        if ((exoConfHome = PrivilegedSystemHelper.getProperty((String)EXO_CONF_PARAM)) != null && exoConfHome.length() > 0) {
            log.info((Object)("Override exo-conf directory '" + this.exoConfDir_ + "' with location '" + exoConfHome + "'"));
            this.exoConfDir_ = exoConfHome;
        }
        this.serverHome_ = this.serverHome_.replace('\\', '/');
        this.exoConfDir_ = this.exoConfDir_.replace('\\', '/');
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getServerHome() {
        return this.serverHome_;
    }

    public String getExoConfigurationDirectory() {
        return this.exoConfDir_;
    }

    public String getSharedLibDirectory() {
        return this.sharedLibDirecotry_;
    }

    public String getApplicationDeployDirectory() {
        return this.appDeployDirecotry_;
    }

    public boolean isJBoss() {
        return "jboss".equals(this.serverName_);
    }
}

