/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;

public class FSDirectoryManager
implements DirectoryManager {
    private File baseDir;

    public void init(final SearchIndex handler) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FSDirectoryManager.this.baseDir = new File(handler.getPath());
                return null;
            }
        });
    }

    public boolean hasDirectory(final String name) throws IOException {
        return (Boolean)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return new File(FSDirectoryManager.this.baseDir, name).exists();
            }
        });
    }

    public Directory getDirectory(final String name) throws IOException {
        return (Directory)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Directory>(){

            @Override
            public Directory run() throws Exception {
                File dir = name.equals(".") ? FSDirectoryManager.this.baseDir : new File(FSDirectoryManager.this.baseDir, name);
                return FSDirectory.getDirectory((File)dir, (LockFactory)new NativeFSLockFactory(dir));
            }
        });
    }

    public String[] getDirectoryNames() throws IOException {
        return (String[])SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String[]>(){

            @Override
            public String[] run() throws Exception {
                File[] dirs = FSDirectoryManager.this.baseDir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                if (dirs != null) {
                    String[] names = new String[dirs.length];
                    for (int i = 0; i < dirs.length; ++i) {
                        names[i] = dirs[i].getName();
                    }
                    return names;
                }
                throw new IOException("listFiles for " + FSDirectoryManager.this.baseDir.getPath() + " returned null");
            }
        });
    }

    public boolean delete(final String name) {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File directory = new File(FSDirectoryManager.this.baseDir, name);
                if (!directory.exists()) {
                    return true;
                }
                File[] files = directory.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].delete()) continue;
                        return false;
                    }
                } else {
                    return false;
                }
                return directory.delete();
            }
        });
    }

    public boolean rename(final String from, final String to) {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File src = new File(FSDirectoryManager.this.baseDir, from);
                File dest = new File(FSDirectoryManager.this.baseDir, to);
                return src.renameTo(dest);
            }
        });
    }

    public void dispose() {
    }
}

