/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.PerRequestObjectFactory;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.SingletonObjectFactory;
import org.exoplatform.services.rest.impl.ApplicationProviders;
import org.exoplatform.services.rest.impl.ProvidersRegistry;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.impl.StartableApplication;
import org.exoplatform.services.rest.impl.resource.ApplicationResource;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorValidator;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.picocontainer.Startable;

public class ApplicationRegistry
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(ApplicationRegistry.class);
    protected final ExoContainer container;
    protected final ResourceBinder resources;
    protected final ProvidersRegistry providers;
    protected final ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();

    public ApplicationRegistry(ExoContainerContext containerContext, ResourceBinder resources, ProvidersRegistry providers, StartableApplication eXo) {
        this.resources = resources;
        this.providers = providers;
        this.container = containerContext.getContainer();
    }

    public void start() {
        List all = this.container.getComponentInstancesOfType(Application.class);
        for (Application app : all) {
            this.addApplication(app);
        }
    }

    public void addApplication(Application app) {
        String applicationId = app.getClass().getName();
        ApplicationProviders appProviders = new ApplicationProviders(applicationId);
        for (Object obj : app.getSingletons()) {
            Class<?> clazz = obj.getClass();
            if (clazz.getAnnotation(Provider.class) != null) {
                if (obj instanceof ContextResolver) {
                    appProviders.addContextResolver((ContextResolver)obj);
                }
                if (obj instanceof ExceptionMapper) {
                    appProviders.addExceptionMapper((ExceptionMapper)obj);
                }
                if (obj instanceof MessageBodyReader) {
                    appProviders.addMessageBodyReader((MessageBodyReader)obj);
                }
                if (!(obj instanceof MessageBodyWriter)) continue;
                appProviders.addMessageBodyWriter((MessageBodyWriter)obj);
                continue;
            }
            if (clazz.getAnnotation(Filter.class) != null) {
                if (obj instanceof MethodInvokerFilter) {
                    appProviders.addMethodInvokerFilter((MethodInvokerFilter)obj);
                }
                if (obj instanceof RequestFilter) {
                    appProviders.addRequestFilter((RequestFilter)obj);
                }
                if (!(obj instanceof ResponseFilter)) continue;
                appProviders.addResponseFilter((ResponseFilter)obj);
                continue;
            }
            if (clazz.getAnnotation(Path.class) != null) {
                ApplicationResource descriptor = new ApplicationResource(applicationId, obj);
                descriptor.accept(this.rdv);
                this.resources.addResource(new SingletonObjectFactory<AbstractResourceDescriptor>(descriptor, obj));
                continue;
            }
            LOG.warn((Object)("Unknown class type: " + clazz.getName() + " found in " + applicationId));
        }
        for (Class clazz : app.getClasses()) {
            if (clazz.getAnnotation(Provider.class) != null) {
                if (ContextResolver.class.isAssignableFrom(clazz)) {
                    appProviders.addContextResolver(clazz);
                }
                if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                    appProviders.addExceptionMapper(clazz);
                }
                if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                    appProviders.addMessageBodyReader(clazz);
                }
                if (!MessageBodyWriter.class.isAssignableFrom(clazz)) continue;
                appProviders.addMessageBodyWriter(clazz);
                continue;
            }
            if (clazz.getAnnotation(Filter.class) != null) {
                if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                    appProviders.addMethodInvokerFilter(clazz);
                }
                if (RequestFilter.class.isAssignableFrom(clazz)) {
                    appProviders.addRequestFilter(clazz);
                }
                if (!ResponseFilter.class.isAssignableFrom(clazz)) continue;
                appProviders.addResponseFilter(clazz);
                continue;
            }
            if (clazz.getAnnotation(Path.class) != null) {
                ApplicationResource descriptor = new ApplicationResource(applicationId, clazz);
                descriptor.accept(this.rdv);
                this.resources.addResource(new PerRequestObjectFactory<AbstractResourceDescriptor>(descriptor));
                continue;
            }
            LOG.warn((Object)("Unknown class type: " + clazz.getName() + " found in: " + applicationId));
        }
        this.providers.addProviders(appProviders);
    }

    public void stop() {
    }
}

