/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class SocialUserEventListenerImpl
extends UserEventListener {
    public void postSave(User user, boolean isNew) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Identity identity = idm.getOrCreateIdentity("organization", user.getUserName(), true);
        if (!isNew) {
            Profile profile = identity.getProfile();
            String uFirstName = user.getFirstName();
            String uLastName = user.getLastName();
            String uFullName = user.getFullName();
            String uEmail = user.getEmail();
            String pFirstName = (String)profile.getProperty("firstName");
            String pLastName = (String)profile.getProperty("lastName");
            String pEmail = (String)profile.getProperty("email");
            boolean hasUpdated = false;
            if (pFirstName == null || !pFirstName.equals(uFirstName)) {
                profile.setProperty("firstName", uFirstName);
                profile.setProperty("fullName", uFullName);
                hasUpdated = true;
            }
            if (pLastName == null || !pLastName.equals(uLastName)) {
                profile.setProperty("lastName", uLastName);
                profile.setProperty("fullName", uFullName);
                hasUpdated = true;
            }
            if (pEmail == null || !pEmail.equals(uEmail)) {
                profile.setProperty("email", uEmail);
                hasUpdated = true;
            }
            if (hasUpdated) {
                idm.updateProfile(profile);
            }
        }
    }
}

