/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.activity.model.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorage;
import org.exoplatform.social.core.storage.ActivityStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityManagerImpl
implements ActivityManager {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerImpl.class);
    protected ActivityStorage storage;
    protected SortedSet<ActivityProcessor> processors;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;

    public ActivityManagerImpl(ActivityStorage activityStorage, IdentityManager identityManager) {
        this.storage = activityStorage;
        this.processors = new TreeSet<ActivityProcessor>(ActivityManagerImpl.processorComparator());
        this.identityManager = identityManager;
    }

    @Override
    public void addProcessor(ActivityProcessor processor) {
        this.processors.add(processor);
        LOG.debug((Object)("added activity processor " + processor.getClass()));
    }

    @Override
    public void addProcessorPlugin(BaseActivityProcessorPlugin plugin) {
        this.addProcessor(plugin);
    }

    @Override
    public void deleteActivity(String activityId) throws ActivityStorageException {
        ExoSocialActivity activity = this.storage.getActivity(activityId);
        if (activity != null) {
            this.storage.deleteActivity(activityId);
        }
    }

    @Override
    public void deleteActivity(ExoSocialActivity activity) throws ActivityStorageException {
        Validate.notNull((Object)"activity.getId() must not be null", (String)activity.getId());
        this.deleteActivity(activity.getId());
    }

    @Override
    public void deleteComment(String activityId, String commentId) throws ActivityStorageException {
        this.storage.deleteComment(activityId, commentId);
    }

    @Override
    public List<ExoSocialActivity> getActivities(Identity identity) throws ActivityStorageException {
        return this.storage.getActivities(identity, 0L, 20L);
    }

    @Override
    public List<ExoSocialActivity> getActivities(Identity identity, long start, long limit) throws ActivityStorageException {
        List<ExoSocialActivity> activityList = this.storage.getActivities(identity, start, limit);
        for (ExoSocialActivity activity : activityList) {
            this.processActivitiy(activity);
        }
        return activityList;
    }

    @Override
    public int getActivitiesCount(Identity owner) throws ActivityStorageException {
        return this.storage.getActivitiesCount(owner);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(Identity ownerIdentity) throws ActivityStorageException {
        return this.getActivitiesOfConnections(ownerIdentity, 0, 30);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) throws ActivityStorageException {
        List<Identity> connectionList = null;
        try {
            connectionList = this.identityManager.getConnections(ownerIdentity);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to getActivitiesOfConnections of: " + ownerIdentity.getRemoteId()), (Throwable)e);
        }
        return this.storage.getActivitiesOfConnections(connectionList, offset, limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfUserSpaces(Identity ownerIdentity) {
        this.spaceService = this.getSpaceService();
        ArrayList<ExoSocialActivity> activityList = new ArrayList<ExoSocialActivity>();
        List<Space> accessibleSpaceList = null;
        try {
            accessibleSpaceList = this.spaceService.getAccessibleSpaces(ownerIdentity.getRemoteId());
        }
        catch (SpaceException e1) {
            LOG.warn((Object)e1.getMessage(), (Throwable)e1);
        }
        if (accessibleSpaceList == null || accessibleSpaceList.size() == 0) {
            return activityList;
        }
        for (Space space : accessibleSpaceList) {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            try {
                activityList.addAll(this.getActivities(spaceIdentity));
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        Collections.sort(activityList, Util.activityComparator());
        return activityList;
    }

    @Override
    public ExoSocialActivity getActivity(String activityId) throws ActivityStorageException {
        ExoSocialActivity returnActivity = null;
        returnActivity = this.storage.getActivity(activityId);
        if (returnActivity == null) {
            this.processActivitiy(returnActivity);
        }
        return returnActivity;
    }

    @Override
    public List<ExoSocialActivity> getActivityFeed(Identity identity) throws ActivityStorageException {
        ArrayList<ExoSocialActivity> activityList = new ArrayList<ExoSocialActivity>();
        activityList.addAll(this.getActivitiesOfConnections(identity));
        activityList.addAll(this.getActivitiesOfUserSpaces(identity));
        activityList.addAll(this.getActivities(identity));
        Collections.sort(activityList, Util.activityComparator());
        return activityList;
    }

    @Override
    public List<ExoSocialActivity> getComments(ExoSocialActivity activity) throws ActivityStorageException {
        String activityId = activity.getId();
        ArrayList<ExoSocialActivity> returnComments = new ArrayList<ExoSocialActivity>();
        activity = this.getActivity(activityId);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null) {
            Object[] commentIds = rawCommentIds.split(",");
            for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                ExoSocialActivity comment = this.storage.getActivity((String)commentId);
                this.processActivitiy(comment);
                returnComments.add(comment);
            }
        }
        return returnComments;
    }

    @Override
    public void processActivitiy(ExoSocialActivity activity) {
        Iterator it = this.processors.iterator();
        while (it.hasNext()) {
            try {
                ((ActivityProcessor)it.next()).processActivity(activity);
            }
            catch (Exception e) {
                LOG.warn((Object)("activity processing failed " + e.getMessage()));
            }
        }
    }

    @Override
    public ExoSocialActivity recordActivity(Identity owner, String type, String title) throws ActivityStorageException {
        return this.saveActivity(owner, new ExoSocialActivityImpl(owner.getId(), type, title));
    }

    @Override
    public ExoSocialActivity recordActivity(Identity owner, ExoSocialActivity activity) throws Exception {
        return this.saveActivity(owner, activity);
    }

    @Override
    public ExoSocialActivity recordActivity(Identity owner, String type, String title, String body) throws ActivityStorageException {
        String userId = owner.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userId, type, title, body);
        return this.saveActivity(owner, activity);
    }

    @Override
    public void removeLike(ExoSocialActivity activity, Identity identity) throws ActivityStorageException {
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.saveActivity(activity);
        } else {
            LOG.warn((Object)("activity is not liked by identity: " + identity));
        }
    }

    @Override
    public ExoSocialActivity saveActivity(Identity owner, ExoSocialActivity activity) throws ActivityStorageException {
        Validate.notNull((Object)owner, (String)"owner must not be null.");
        Validate.notNull((Object)owner.getId(), (String)"owner.getId() must not be null");
        long now = System.currentTimeMillis();
        if (activity.getId() == null) {
            activity.setPostedTime(now);
        }
        activity.setUpdated(new Date(now));
        if (activity.getUserId() == null) {
            activity.setUserId(owner.getId());
        }
        activity = this.storage.saveActivity(owner, activity);
        return activity;
    }

    @Override
    public ExoSocialActivity saveActivity(ExoSocialActivity activity) throws ActivityStorageException {
        Validate.notNull((Object)activity.getUserId(), (String)"activity.getUserId() must not be null.");
        Identity owner = this.identityManager.getIdentity(activity.getUserId());
        return this.saveActivity(owner, activity);
    }

    @Override
    public void saveComment(ExoSocialActivity activity, ExoSocialActivity comment) throws ActivityStorageException {
        this.storage.saveComment(activity, comment);
    }

    @Override
    public void saveLike(ExoSocialActivity activity, Identity identity) throws ActivityStorageException {
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        activity.setLikeIdentityIds((String[])identityIds);
        this.saveActivity(activity);
    }

    protected SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private static Comparator<ActivityProcessor> processorComparator() {
        return new Comparator<ActivityProcessor>(){

            @Override
            public int compare(ActivityProcessor p1, ActivityProcessor p2) {
                if (p1 == null || p2 == null) {
                    throw new IllegalArgumentException("Cannot compare null ActivityProcessor");
                }
                return p1.getPriority() - p2.getPriority();
            }
        };
    }

    protected ActivityStorage getStorage() {
        return this.storage;
    }

    protected IdentityManager getIdentityManager() {
        return this.identityManager;
    }
}

