/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.ActivityStorage;
import org.exoplatform.social.core.storage.ActivityStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingActivityManager
extends ActivityManagerImpl {
    private static final Log LOG = ExoLogger.getLogger(CachingActivityManager.class);
    private ExoCache<String, ExoSocialActivity> activityCache;
    private ExoCache<String, Map<Segment, List<ExoSocialActivity>>> activityListCache;
    private ExoCache<String, List<ExoSocialActivity>> commentsCache;

    public CachingActivityManager(ActivityStorage activityStorage, IdentityManager identityManager, CacheService cacheService) {
        super(activityStorage, identityManager);
        this.activityCache = cacheService.getCacheInstance(this.getClass().getName() + "activityCache");
        this.activityListCache = cacheService.getCacheInstance(this.getClass().getName() + "activityListCache");
        this.commentsCache = cacheService.getCacheInstance(this.getClass().getName() + "commentsCache");
    }

    @Override
    public ExoSocialActivity getActivity(String activityId) throws ActivityStorageException {
        ExoSocialActivity cachedActivity = (ExoSocialActivity)this.activityCache.get((Serializable)((Object)activityId));
        if (cachedActivity == null && (cachedActivity = this.getStorage().getActivity(activityId)) != null) {
            this.processActivitiy(cachedActivity);
            this.activityCache.put((Serializable)((Object)activityId), (Object)cachedActivity);
        }
        return cachedActivity;
    }

    @Override
    public void deleteActivity(String activityId) throws ActivityStorageException {
        ExoSocialActivity activity = this.getStorage().getActivity(activityId);
        if (activity != null) {
            Identity streamOwner = this.identityManager.getIdentity(activity.getUserId(), false);
            this.getStorage().deleteActivity(activityId);
            try {
                this.activityCache.remove((Serializable)((Object)activityId));
                this.activityListCache.remove((Serializable)((Object)streamOwner.getId()));
            }
            catch (Exception e) {
                LOG.debug((Object)("No cache key: " + activityId + " from cache"));
            }
        }
    }

    @Override
    public void deleteComment(String activityId, String commentId) throws ActivityStorageException {
        this.getStorage().deleteComment(activityId, commentId);
        this.activityCache.remove((Serializable)((Object)activityId));
        this.commentsCache.remove((Serializable)((Object)activityId));
    }

    @Override
    public ExoSocialActivity saveActivity(Identity owner, ExoSocialActivity activity) throws ActivityStorageException {
        Validate.notNull((Object)owner, (String)"owner must not be null.");
        Validate.notNull((Object)owner.getId(), (String)"owner.getId() must not be null");
        long now = System.currentTimeMillis();
        if (activity.getId() == null) {
            activity.setPostedTime(now);
        }
        activity.setUpdated(new Date(now));
        if (activity.getUserId() == null) {
            activity.setUserId(owner.getId());
        }
        activity = this.getStorage().saveActivity(owner, activity);
        this.activityListCache.remove((Serializable)((Object)owner.getId()));
        return activity;
    }

    @Override
    public void saveComment(ExoSocialActivity activity, ExoSocialActivity comment) throws ActivityStorageException {
        this.getStorage().saveComment(activity, comment);
        this.activityCache.remove((Serializable)((Object)activity.getId()));
        this.commentsCache.remove((Serializable)((Object)activity.getId()));
    }

    @Override
    public void saveLike(ExoSocialActivity activity, Identity identity) throws ActivityStorageException {
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        activity.setLikeIdentityIds((String[])identityIds);
        this.saveActivity(activity);
        this.activityCache.remove((Serializable)((Object)activity.getId()));
    }

    @Override
    public void removeLike(ExoSocialActivity activity, Identity identity) throws ActivityStorageException {
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.saveActivity(activity);
            this.activityCache.remove((Serializable)((Object)activity.getId()));
        } else {
            LOG.warn((Object)("activity is not liked by identity: " + identity));
        }
    }

    @Override
    public List<ExoSocialActivity> getActivities(Identity identity, long start, long limit) throws ActivityStorageException {
        Segment segment = new Segment(start, limit);
        HashMap<Segment, List<ExoSocialActivity>> segments = (HashMap<Segment, List<ExoSocialActivity>>)this.activityListCache.get((Serializable)((Object)identity.getId()));
        if (segments == null || segments.get(segment) == null) {
            segments = new HashMap<Segment, List<ExoSocialActivity>>();
            List<ExoSocialActivity> activityList = this.getStorage().getActivities(identity, start, limit);
            for (ExoSocialActivity activity : activityList) {
                this.processActivitiy(activity);
            }
            segments.put(segment, activityList);
            this.activityListCache.put((Serializable)((Object)identity.getId()), segments);
        }
        return (List)segments.get(segment);
    }

    @Override
    public List<ExoSocialActivity> getComments(ExoSocialActivity activity) throws ActivityStorageException {
        String activityId = activity.getId();
        ArrayList<ExoSocialActivity> cachedComments = (ArrayList<ExoSocialActivity>)this.commentsCache.get((Serializable)((Object)activityId));
        if (cachedComments == null) {
            activity = this.getActivity(activityId);
            cachedComments = new ArrayList<ExoSocialActivity>();
            String rawCommentIds = activity.getReplyToId();
            if (rawCommentIds != null) {
                Object[] commentIds = rawCommentIds.split(",");
                for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                    ExoSocialActivity comment = this.getStorage().getActivity((String)commentId);
                    this.processActivitiy(comment);
                    cachedComments.add(comment);
                }
                if (cachedComments.size() > 0) {
                    this.commentsCache.put((Serializable)((Object)activityId), cachedComments);
                }
            }
        }
        return cachedComments;
    }

    private class Segment {
        private long start;
        private long limit;

        public Segment(long start, long limit) {
            this.start = start;
            this.limit = limit;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Segment)) {
                return false;
            }
            Segment other = (Segment)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.limit != other.limit) {
                return false;
            }
            return this.start == other.start;
        }

        private ActivityManager getOuterType() {
            return CachingActivityManager.this;
        }
    }
}

