/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RelationshipManager {
    public Relationship getRelationshipById(String var1) throws Exception;

    public Relationship invite(Identity var1, Identity var2) throws RelationshipStorageException;

    public void save(Relationship var1) throws RelationshipStorageException;

    public void confirm(Relationship var1) throws RelationshipStorageException;

    public void deny(Relationship var1) throws RelationshipStorageException;

    public void remove(Relationship var1) throws RelationshipStorageException;

    public void ignore(Relationship var1) throws RelationshipStorageException;

    public ListAccess<Identity> getConnections(Identity var1);

    public List<Relationship> getPendingRelationships(Identity var1) throws Exception;

    public List<Relationship> getPendingRelationships(Identity var1, boolean var2) throws Exception;

    public List<Relationship> getPendingRelationships(Identity var1, List<Identity> var2, boolean var3) throws Exception;

    public List<Relationship> getContacts(Identity var1, List<Identity> var2) throws Exception;

    public List<Relationship> getContacts(Identity var1) throws Exception;

    public List<Relationship> getAllRelationships(Identity var1) throws Exception;

    public List<Relationship> getRelationshipsByIdentityId(String var1) throws Exception;

    public List<Identity> getIdentities(Identity var1) throws Exception;

    public Relationship create(Identity var1, Identity var2);

    public void saveRelationship(Relationship var1) throws Exception;

    public List findRoute(Identity var1, Identity var2) throws Exception;

    public Relationship getRelationship(Identity var1, Identity var2) throws Exception;

    public List<Identity> findRelationships(Identity var1, Relationship.Type var2) throws Exception;

    public Relationship.Type getRelationshipStatus(Relationship var1, Identity var2);

    public Relationship.Type getConnectionStatus(Identity var1, Identity var2) throws Exception;

    public Relationship get(String var1);

    public List<Relationship> getPending(Identity var1) throws RelationshipStorageException;

    public List<Relationship> getPending(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    public List<Relationship> getIncoming(Identity var1) throws RelationshipStorageException;

    public List<Relationship> getIncoming(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    public List<Relationship> getConfirmed(Identity var1) throws RelationshipStorageException;

    public List<Relationship> getConfirmed(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    public List<Relationship> getAll(Identity var1) throws RelationshipStorageException;

    public List<Relationship> getAll(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    public List<Relationship> getAll(Identity var1, Relationship.Type var2, List<Identity> var3) throws RelationshipStorageException;

    public Relationship get(Identity var1, Identity var2) throws RelationshipStorageException;

    public Relationship.Type getStatus(Identity var1, Identity var2) throws RelationshipStorageException;
}

