/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceLifecycle
extends AbstractLifeCycle<SpaceLifeCycleListener, SpaceLifeCycleEvent> {
    protected void dispatchEvent(SpaceLifeCycleListener listener, SpaceLifeCycleEvent event) {
        switch (event.getType()) {
            case SPACE_CREATED: {
                listener.spaceCreated(event);
                break;
            }
            case SPACE_REMOVED: {
                listener.spaceRemoved(event);
                break;
            }
            case APP_ACTIVATED: {
                listener.applicationActivated(event);
                break;
            }
            case APP_DEACTIVATED: {
                listener.applicationDeactivated(event);
                break;
            }
            case APP_ADDED: {
                listener.applicationAdded(event);
                break;
            }
            case APP_REMOVED: {
                listener.applicationRemoved(event);
                break;
            }
            case JOINED: {
                listener.joined(event);
                break;
            }
            case LEFT: {
                listener.left(event);
                break;
            }
            case GRANTED_LEAD: {
                listener.grantedLead(event);
                break;
            }
            case REVOKED_LEAD: {
                listener.revokedLead(event);
                break;
            }
        }
    }

    public void spaceCreated(Space space, String creator) {
        this.broadcast(new SpaceLifeCycleEvent(space, creator, SpaceLifeCycleEvent.Type.SPACE_CREATED));
    }

    public void spaceRemoved(Space space, String remover) {
        this.broadcast(new SpaceLifeCycleEvent(space, remover, SpaceLifeCycleEvent.Type.SPACE_REMOVED));
    }

    public void addApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_ADDED);
        event.getSource();
        this.broadcast(event);
    }

    public void deactivateApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_DEACTIVATED);
        this.broadcast(event);
    }

    public void activateApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_ACTIVATED);
        this.broadcast(event);
    }

    public void removeApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_REMOVED);
        this.broadcast(event);
    }

    public void memberJoined(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.JOINED));
    }

    public void memberLeft(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.LEFT));
    }

    public void grantedLead(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.GRANTED_LEAD));
    }

    public void revokedLead(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.REVOKED_LEAD));
    }
}

