/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.Validate;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.value.BooleanValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.LongValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.service.ProfileConfig;
import org.exoplatform.social.core.storage.IdentityStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityStorage {
    private static final String ASTERISK_STR = "*";
    private static final String PERCENT_STR = "%";
    private static final char ASTERISK_CHAR = '*';
    private static final String SPACE_STR = " ";
    private static final String EMPTY_STR = "";
    private static final String SLASH_STR = "/";
    private static final Log log = ExoLogger.getLogger(IdentityStorage.class);
    private ProfileConfig config = null;
    private final SocialDataLocation dataLocation;
    private final JCRSessionManager sessionManager;
    private ExoCache<String, Identity> identityCacheById;

    public IdentityStorage(SocialDataLocation dataLocation, CacheService cacheService) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
        this.identityCacheById = cacheService.getCacheInstance("exo.social.IdentityStorage.IdentityCacheById");
    }

    public final void saveIdentity(Identity identity) throws IdentityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode;
            Node identityHomeNode = this.getIdentityServiceHome(session);
            if (identity.getId() == null) {
                identityNode = identityHomeNode.addNode("exo:identity", "exo:identity");
                identityNode.addMixin("mix:referenceable");
            } else {
                identityNode = session.getNodeByUUID(identity.getId());
            }
            identityNode.setProperty("exo:remoteId", identity.getRemoteId());
            identityNode.setProperty("exo:providerId", identity.getProviderId());
            identityNode.setProperty("exo:isDeleted", identity.isDeleted());
            if (identity.getId() == null) {
                identityHomeNode.save();
                identity.setId(identityNode.getUUID());
            } else {
                identityNode.save();
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_SAVE_IDENTITY, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        String nodeUUID = identity.getId();
        try {
            Node identityNode = session.getNodeByUUID(nodeUUID);
            identityNode.setProperty("exo:remoteId", identity.getRemoteId());
            identityNode.setProperty("exo:providerId", identity.getProviderId());
            identityNode.setProperty("exo:isDeleted", identity.isDeleted());
            identityNode.save();
            if (this.identityCacheById.get((Serializable)((Object)nodeUUID)) != null) {
                this.identityCacheById.remove((Serializable)((Object)nodeUUID));
            }
            this.identityCacheById.put((Serializable)((Object)nodeUUID), (Object)identity);
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_IDENTITY, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    public final void deleteIdentity(Identity identity) throws IdentityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode = session.getNodeByUUID(identity.getId());
            Profile profile = identity.getProfile();
            if (profile != null && profile.getId() != null) {
                this.deleteProfile(profile);
            }
            identityNode.remove();
            session.save();
            if (this.identityCacheById.get((Serializable)((Object)identity.getId())) != null) {
                this.identityCacheById.remove((Serializable)((Object)identity.getId()));
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_DELETE_IDENTITY, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public final Identity findIdentityById(String nodeId) throws IdentityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        Identity identity = null;
        Node identityNode = null;
        identity = (Identity)this.identityCacheById.get((Serializable)((Object)nodeId));
        if (identity != null) {
            return identity;
        }
        try {
            identityNode = session.getNodeByUUID(nodeId);
            if (identityNode != null) {
                identity = this.getIdentity(identityNode);
            }
        }
        catch (ItemNotFoundException itemNotFoundExp) {
            Identity identity2 = null;
            return identity2;
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY_BY_NODE_ID, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    public final Identity findIdentity(String providerId, String remoteId) throws IdentityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        Node identityHomeNode = this.getIdentityServiceHome(session);
        Identity identity = null;
        try {
            List nodes = new QueryBuilder(session).select("exo:identity").like("jcr:path", identityHomeNode.getPath() + SLASH_STR + PERCENT_STR).and().equal("exo:providerId", providerId).and().equal("exo:remoteId", remoteId).exec();
            if (nodes.size() == 1) {
                Node identityNode = (Node)nodes.get(0);
                identity = this.getIdentity(identityNode);
            }
        }
        catch (ItemNotFoundException itemNotFoundExp) {
            Identity identity2 = null;
            return identity2;
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    public int getIdentitiesByFirstCharacterOfNameCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getOrCreatExoProfileHomeNode(session, providerId);
            QueryBuilder queryBuilder = new QueryBuilder(session);
            queryBuilder.select("exo:profile").like("jcr:path", profileHomeNode.getPath() + SLASH_STR + PERCENT_STR);
            if (excludedIdentityList != null & excludedIdentityList.size() > 0) {
                for (Identity identity : excludedIdentityList) {
                    queryBuilder.and().not().equal("exo:identity", identity.getId());
                }
            }
            queryBuilder.and().like(queryBuilder.lower("firstName"), Character.toString(profileFilter.getFirstCharacterOfName()).toLowerCase() + PERCENT_STR);
            int n = (int)queryBuilder.count();
            return n;
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_IDENTITY_BY_FIRSTCHAR_COUNT, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Identity> getIdentitiesByFirstCharacterOfName(String providerId, ProfileFilter profileFilter, int offset, int limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        List nodes = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getOrCreatExoProfileHomeNode(session, providerId);
            QueryBuilder queryBuilder = new QueryBuilder(session);
            queryBuilder.select("exo:profile", (long)offset, (long)limit).like("jcr:path", profileHomeNode.getPath() + SLASH_STR + PERCENT_STR);
            if (excludedIdentityList != null & excludedIdentityList.size() > 0) {
                for (Identity identity : excludedIdentityList) {
                    queryBuilder.and().not().equal("exo:identity", identity.getId());
                }
            }
            queryBuilder.and().like(queryBuilder.lower("firstName"), Character.toString(profileFilter.getFirstCharacterOfName()).toLowerCase() + PERCENT_STR).orderBy("firstName", "ASC");
            nodes = queryBuilder.exec();
            for (Node profileNode : nodes) {
                Node identityNode = profileNode.getProperty("exo:identity").getNode();
                Identity identity = this.getIdentity(identityNode);
                if (forceLoadOrReloadProfile) {
                    this.loadProfile(identity.getProfile());
                }
                listIdentity.add(identity);
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_IDENTITY_BY_FIRSTCHAR, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return listIdentity;
    }

    public int getIdentitiesByProfileFilterCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        String inputName = profileFilter.getName().replace(ASTERISK_STR, PERCENT_STR);
        this.processUsernameSearchPattern(inputName.trim());
        String position = this.addPositionSearchPattern(profileFilter.getPosition().trim()).replace(ASTERISK_STR, PERCENT_STR);
        String gender = profileFilter.getGender().trim();
        inputName = inputName.isEmpty() ? ASTERISK_STR : inputName;
        String nameForSearch = inputName.replace(ASTERISK_STR, SPACE_STR);
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getOrCreatExoProfileHomeNode(session, providerId);
            QueryBuilder queryBuilder = new QueryBuilder(session);
            queryBuilder.select("exo:profile").like("jcr:path", profileHomeNode.getPath() + SLASH_STR + PERCENT_STR);
            if (excludedIdentityList != null & excludedIdentityList.size() > 0) {
                for (Identity identity : excludedIdentityList) {
                    queryBuilder.and().not().equal("exo:identity", identity.getId());
                }
            }
            if (nameForSearch.trim().length() != 0) {
                queryBuilder.and().like(queryBuilder.lower("fullName"), PERCENT_STR + nameForSearch.toLowerCase() + PERCENT_STR);
            }
            if (position.length() != 0) {
                queryBuilder.and().like(queryBuilder.lower("position"), PERCENT_STR + position.toLowerCase() + PERCENT_STR);
            }
            if (gender.length() != 0) {
                queryBuilder.and().equal("gender", gender);
            }
            int n = (int)queryBuilder.count();
            return n;
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_IDENTITY_BY_PROFILE_FILTER_COUNT, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public final List<Identity> getIdentitiesByProfileFilter(String identityProvider, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        String inputName = profileFilter.getName().replace(ASTERISK_STR, PERCENT_STR);
        this.processUsernameSearchPattern(inputName.trim());
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        String position = this.addPositionSearchPattern(profileFilter.getPosition().trim()).replace(ASTERISK_STR, PERCENT_STR);
        String gender = profileFilter.getGender().trim();
        inputName = inputName.isEmpty() ? ASTERISK_STR : inputName;
        String nameForSearch = inputName.replace(ASTERISK_STR, SPACE_STR);
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        List nodes = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getOrCreatExoProfileHomeNode(session, identityProvider);
            QueryBuilder queryBuilder = new QueryBuilder(session);
            queryBuilder.select("exo:profile", offset, limit).like("jcr:path", profileHomeNode.getPath() + SLASH_STR + PERCENT_STR);
            if (excludedIdentityList != null & excludedIdentityList.size() > 0) {
                for (Identity identity : excludedIdentityList) {
                    queryBuilder.and().not().equal("exo:identity", identity.getId());
                }
            }
            if (nameForSearch.trim().length() != 0) {
                queryBuilder.and().like(queryBuilder.lower("fullName"), PERCENT_STR + nameForSearch.toLowerCase() + PERCENT_STR);
            }
            if (position.length() != 0) {
                queryBuilder.and().like(queryBuilder.lower("position"), PERCENT_STR + position.toLowerCase() + PERCENT_STR);
            }
            if (gender.length() != 0) {
                queryBuilder.and().equal("gender", gender);
            }
            queryBuilder.orderBy("fullName", "ASC");
            nodes = queryBuilder.exec();
            for (Node profileNode : nodes) {
                Node identityNode = profileNode.getProperty("exo:identity").getNode();
                Identity identity = this.getIdentity(identityNode);
                if (forceLoadOrReloadProfile) {
                    this.loadProfile(identity.getProfile());
                }
                listIdentity.add(identity);
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_IDENTITY_BY_PROFILE_FILTER, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return listIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveProfile(Profile profile) throws IdentityStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            String identityId = profile.getIdentity().getId();
            if (identityId == null) {
                throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_SAVE_PROFILE, "The identity has to be saved before saving the profile");
            }
            Identity identity = profile.getIdentity();
            Node profileHomeNode = this.getOrCreatExoProfileHomeNode(session, identity.getProviderId());
            Profile profile2 = profile;
            synchronized (profile2) {
                Node profileNode;
                if (profile.getId() == null) {
                    profileNode = profileHomeNode.addNode("exo:profile", "exo:profile");
                    profileNode.addMixin("mix:referenceable");
                    Node identityNode = session.getNodeByUUID(identityId);
                    profileNode.setProperty("exo:identity", identityNode);
                    profileNode.setProperty("jcr:lastModified", Calendar.getInstance());
                    profileHomeNode.save();
                } else {
                    profileNode = session.getNodeByUUID(profile.getId());
                }
                this.saveProfile(profile, profileNode, session);
                if (profile.getId() == null) {
                    profileHomeNode.save();
                    profile.setId(profileNode.getUUID());
                } else {
                    profileNode.save();
                }
            }
            if (this.identityCacheById.get((Serializable)((Object)identityId)) != null) {
                this.identityCacheById.remove((Serializable)((Object)identityId));
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_SAVE_PROFILE, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateProfile(Profile profile) throws IdentityStorageException {
        try {
            Node profileNode;
            Session session = this.sessionManager.getOrOpenSession();
            String identityId = profile.getIdentity().getId();
            if (identityId == null) {
                throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_SAVE_PROFILE, "The identity has to be saved before saving the profile");
            }
            Profile profile2 = profile;
            synchronized (profile2) {
                profileNode = session.getNodeByUUID(profile.getId());
                this.saveProfile(profile, profileNode, session);
                profileNode.save();
            }
            if (this.identityCacheById.get((Serializable)((Object)identityId)) != null) {
                this.identityCacheById.remove((Serializable)((Object)identityId));
            }
            this.setOrResetAvatarUrl(session, profileNode);
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    private void setOrResetAvatarUrl(Session session, Node profileNode) throws IdentityStorageException {
        try {
            Identity id = this.getIdentity(profileNode.getProperty("exo:identity").getNode());
            Profile p = id.getProfile();
            AvatarAttachment attacthment = (AvatarAttachment)p.getProperty("avatar");
            p.setProperty("avatarUrl", LinkProvider.buildAvatarImageUri(attacthment));
            this.saveProfile(p, profileNode, session);
            profileNode.save();
            if (this.identityCacheById.get((Serializable)((Object)id.getId())) != null) {
                this.identityCacheById.remove((Serializable)((Object)id.getId()));
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public final void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        Validate.notNull((Object)profile.getId(), (String)"profile.getId() must be not null.");
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileNode = session.getNodeByUUID(profile.getId());
            this.addOrModifyProfileProperties(profile, profileNode, session);
            profileNode.save();
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_ADD_OR_MODIFY_PROPERTIES, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        int count = 0;
        Node identityHomeNode = this.getIdentityServiceHome(session);
        try {
            count = (int)new QueryBuilder(session).select("exo:identity").like("jcr:path", identityHomeNode.getPath() + SLASH_STR + PERCENT_STR).and().equal("exo:providerId", providerId).count();
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_IDENTITIES_COUNT, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public final void loadProfile(Profile profile) throws IdentityStorageException {
        if (profile.getIdentity().getId() == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_LOAD_PROFILE, "The identity must to be saved before loading profile");
        }
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode = session.getNodeByUUID(profile.getIdentity().getId());
            String workspaceName = session.getWorkspace().getName();
            PropertyIterator references = identityNode.getReferences();
            if (references.getSize() == 0L) {
                this.saveProfile(profile);
            } else {
                while (references.hasNext()) {
                    Property nodeReferencedProperty = (Property)references.next();
                    if (!nodeReferencedProperty.getParent().isNodeType("exo:profile")) continue;
                    Node profileNode = nodeReferencedProperty.getParent();
                    profile.setId(profileNode.getUUID());
                    this.loadProfile(profile, profileNode, workspaceName);
                }
            }
        }
        catch (ItemNotFoundException e) {
            return;
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_LOAD_PROFILE, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getType(String nodetype, String property) {
        try {
            PropertyDefinition[] pDefs;
            Session session = this.sessionManager.openSession();
            NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
            NodeType nt = ntManager.getNodeType(nodetype);
            for (PropertyDefinition pDef : pDefs = nt.getDeclaredPropertyDefinitions()) {
                if (!pDef.getName().equals(property)) continue;
                String string = PropertyType.nameFromValue((int)pDef.getRequiredType());
                return string;
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    protected final void deleteProfile(Profile profile) throws IdentityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node profileNode = session.getNodeByUUID(profile.getId());
            profileNode.remove();
            session.save();
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_DELETE_PROFILE, e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void saveProfile(Profile profile, Node profileNode, Session session) throws Exception, IOException {
        Profile profile2 = profile;
        synchronized (profile2) {
            long lastLoaded = profile.getLastLoaded();
            long lastPersisted = 0L;
            if (profileNode.hasProperty("jcr:lastModified")) {
                lastPersisted = profileNode.getProperty("jcr:lastModified").getLong();
            }
            if (!profile.hasChanged() && lastPersisted > 0L && lastPersisted <= lastLoaded) {
                return;
            }
            profile.clearHasChanged();
            Calendar date = Calendar.getInstance();
            profileNode.setProperty("jcr:lastModified", date);
            profile.setLastLoaded(date.getTimeInMillis());
            this.addOrModifyProfileProperties(profile, profileNode, session);
        }
    }

    protected final void addOrModifyProfileProperties(Profile profile, Node profileNode, Session session) throws IdentityStorageException {
        Map<String, Object> props = profile.getProperties();
        Iterator<Map.Entry<String, Object>> it = props.entrySet().iterator();
        try {
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String key = entry.getKey();
                if (key.contains(":")) continue;
                this.setProperty(profileNode, session, key, entry.getValue());
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_ADD_OR_MODIFY_PROPERTIES, e.getMessage());
        }
    }

    protected final boolean isForcedMultiValue(String key) {
        return this.getConfig().isForcedMultiValue(key);
    }

    protected final String getNodeTypeName(String nodeName) {
        return this.getConfig().getNodeType(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadProfile(Profile profile, Node profileNode, String workspaceName) throws RepositoryException, IdentityStorageException {
        Profile profile2 = profile;
        synchronized (profile2) {
            String nodeName;
            Node node;
            long lastLoaded = profile.getLastLoaded();
            long lastPersisted = 0L;
            if (profileNode.hasProperty("jcr:lastModified")) {
                lastPersisted = profileNode.getProperty("jcr:lastModified").getLong();
            } else {
                profileNode.setProperty("jcr:lastModified", Calendar.getInstance());
                profileNode.save();
            }
            if (lastPersisted > 0L && lastPersisted <= lastLoaded) {
                return;
            }
            boolean hasChanged = profile.hasChanged();
            Calendar date = Calendar.getInstance();
            profile.setLastLoaded(date.getTimeInMillis());
            PropertyIterator props = profileNode.getProperties();
            this.copyPropertiesToMap(props, profile.getProperties());
            NodeIterator it = profileNode.getNodes();
            while (it.hasNext()) {
                node = it.nextNode();
                nodeName = node.getName();
                while (profile.contains(nodeName)) {
                    profile.removeProperty(nodeName);
                }
            }
            it = profileNode.getNodes();
            while (it.hasNext()) {
                node = it.nextNode();
                nodeName = node.getName();
                if (nodeName.equals("avatar") || nodeName.startsWith("avatar_")) {
                    if (!node.isNodeType("nt:file")) continue;
                    AvatarAttachment file = new AvatarAttachment();
                    file.setId(node.getPath());
                    file.setMimeType(node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
                    try {
                        file.setInputStream(node.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
                    }
                    catch (Exception e) {
                        throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_LOAD_AVATAR, e.getMessage());
                    }
                    file.setLastModified(node.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
                    file.setFileName(nodeName);
                    file.setWorkspace(workspaceName);
                    profile.setProperty(nodeName, file);
                    continue;
                }
                ArrayList<Map<String, Object>> mapPropertyList = (ArrayList<Map<String, Object>>)profile.getProperty(nodeName);
                if (mapPropertyList == null) {
                    mapPropertyList = new ArrayList<Map<String, Object>>();
                }
                mapPropertyList.add(this.copyPropertiesToMap(node.getProperties(), null));
                profile.setProperty(nodeName, mapPropertyList);
            }
            if (!hasChanged) {
                profile.clearHasChanged();
            }
        }
    }

    private Node getIdentityServiceHome(Session session) throws IdentityStorageException {
        Node identityServiceHome = null;
        String path = this.dataLocation.getSocialIdentityHome();
        try {
            Node rootNode = session.getRootNode();
            this.createNodes(rootNode, path);
            identityServiceHome = session.getRootNode().getNode(path);
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_IDENTITY_SERVICE_HOME, e.getMessage());
        }
        return identityServiceHome;
    }

    private ProfileConfig getConfig() {
        if (this.config == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.config = (ProfileConfig)container.getComponentInstanceOfType(ProfileConfig.class);
        }
        return this.config;
    }

    private Node getProfileServiceHome(Session session) throws IdentityStorageException {
        Node profileServiceHome = null;
        try {
            String path = this.dataLocation.getSocialProfileHome();
            Node rootNode = session.getRootNode();
            this.createNodes(rootNode, path);
            profileServiceHome = session.getRootNode().getNode(path);
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_PROFILE_SERVICE_HOME, e.getMessage());
        }
        return profileServiceHome;
    }

    private Node getOrCreatExoProfileHomeNode(Session session, String providerId) throws IdentityStorageException {
        try {
            Node profileHomeNode = this.getProfileServiceHome(session);
            if (profileHomeNode.hasNode(providerId)) {
                return profileHomeNode.getNode(providerId);
            }
            Node typeProfileHome = profileHomeNode.addNode(providerId, "nt:unstructured");
            profileHomeNode.save();
            return typeProfileHome;
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_OR_CREAT_PROFILE_HOME_NODE, e.getMessage());
        }
    }

    private String addPositionSearchPattern(String position) {
        if (position.length() != 0) {
            if (position.indexOf(ASTERISK_STR) == -1) {
                return ASTERISK_STR + position + ASTERISK_STR;
            }
            return position;
        }
        return EMPTY_STR;
    }

    private String processUsernameSearchPattern(String userName) {
        if (userName.length() > 0) {
            userName = EMPTY_STR.equals(userName) || userName.length() == 0 ? ASTERISK_STR : userName;
            userName = userName.charAt(0) != '*' ? ASTERISK_STR + userName : userName;
            userName = userName.charAt(userName.length() - 1) != '*' ? (userName = userName + ASTERISK_STR) : userName;
            userName = userName.indexOf(ASTERISK_STR) >= 0 ? userName.replace(ASTERISK_STR, ".*") : userName;
            userName = userName.indexOf(PERCENT_STR) >= 0 ? userName.replace(PERCENT_STR, ".*") : userName;
            Pattern.compile(userName);
        }
        return userName;
    }

    private Map<String, Object> copyPropertiesToMap(PropertyIterator props, Map<String, Object> map) throws RepositoryException {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            String name = prop.getName();
            if (name.contains(":")) continue;
            try {
                Value value = prop.getValue();
                if (value instanceof StringValue) {
                    map.put(name, value.getString());
                    continue;
                }
                if (value instanceof LongValue) {
                    map.put(name, value.getLong());
                    continue;
                }
                if (value instanceof DoubleValue) {
                    map.put(name, value.getDouble());
                    continue;
                }
                if (!(value instanceof BooleanValue)) continue;
                map.put(name, value.getBoolean());
            }
            catch (ValueFormatException e) {
                Value[] values = prop.getValues();
                ArrayList<String> res = new ArrayList<String>();
                for (Value value : values) {
                    res.add(value.getString());
                }
                map.put(name, res.toArray(new String[res.size()]));
            }
        }
        return map;
    }

    private void setProperty(Node profileNode, Session session, String name, Object value) throws Exception {
        if (this.isForcedMultiValue(name)) {
            if (value instanceof String) {
                value = new String[]{(String)value};
            }
            this.setProperty(name, value, profileNode);
        } else if (value instanceof String) {
            profileNode.setProperty(name, (String)value);
        } else if (value instanceof Double) {
            profileNode.setProperty(name, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            profileNode.setProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            profileNode.setProperty(name, ((Long)value).longValue());
        } else if (value instanceof String[]) {
            String[] strings = value;
            if (strings.length == 1) {
                profileNode.setProperty(name, strings[0]);
            } else {
                this.setProperty(name, strings, profileNode);
            }
        } else if (value instanceof List) {
            this.setProperty(name, (List)value, profileNode, session);
        } else if (value instanceof AvatarAttachment) {
            this.saveAvatarAttachment(profileNode, session, name, (AvatarAttachment)value);
        }
    }

    private void saveAvatarAttachment(Node profileNode, Session session, String name, AvatarAttachment profileAtt) throws Exception {
        ExtendedNode extNode = (ExtendedNode)profileNode;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(SystemIdentity.ANY, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
        if (profileAtt.getFileName() != null) {
            Node nodeContent;
            Node nodeFile;
            try {
                nodeFile = profileNode.getNode(name);
            }
            catch (PathNotFoundException ex) {
                nodeFile = profileNode.addNode(name, "nt:file");
            }
            try {
                nodeContent = nodeFile.getNode("jcr:content");
            }
            catch (PathNotFoundException ex) {
                nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
            }
            long lastModified = profileAtt.getLastModified();
            long lastSaveTime = 0L;
            if (nodeContent.hasProperty("jcr:lastModified")) {
                lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
            }
            if (lastModified != 0L && lastModified != lastSaveTime) {
                nodeContent.setProperty("jcr:mimeType", profileAtt.getMimeType());
                nodeContent.setProperty("jcr:data", profileAtt.getInputStream(session));
                nodeContent.setProperty("jcr:lastModified", profileAtt.getLastModified());
            }
        } else if (profileNode.hasNode(name)) {
            profileNode.getNode(name).remove();
            profileNode.save();
        }
    }

    private void setProperty(String name, List<Map<String, Object>> props, Node n, Session session) throws IdentityStorageException {
        String ntName = this.getNodeTypeName(name);
        try {
            if (ntName == null) {
                throw new Exception("no nodeType is defined for " + name);
            }
            NodeIterator nIt = n.getNodes(name);
            while (nIt.hasNext()) {
                Node currNode = nIt.nextNode();
                currNode.remove();
            }
            n.save();
            for (Map<String, Object> prop : props) {
                Node propNode = n.addNode(name, ntName);
                for (Map.Entry<String, Object> entry : prop.entrySet()) {
                    String key = entry.getKey();
                    Object propValue = entry.getValue();
                    if (propValue instanceof String) {
                        propNode.setProperty(key, (String)propValue);
                        continue;
                    }
                    if (propValue instanceof Double) {
                        propNode.setProperty(key, ((Double)propValue).doubleValue());
                        continue;
                    }
                    if (propValue instanceof Boolean) {
                        propNode.setProperty(key, ((Boolean)propValue).booleanValue());
                        continue;
                    }
                    if (!(propValue instanceof Long)) continue;
                    propNode.setProperty(key, ((Long)propValue).longValue());
                }
            }
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_SET_PROPERTIES, e.getMessage());
        }
    }

    private void setProperty(String name, String[] propValue, Node n) throws IOException, RepositoryException {
        ArrayList<StringValue> values = new ArrayList<StringValue>();
        for (String value : propValue) {
            if (value == null || value.length() <= 0) continue;
            values.add(new StringValue(value));
        }
        n.setProperty(name, values.toArray(new Value[values.size()]));
    }

    private final Identity getIdentity(Node identityNode) throws Exception {
        String nodeUUID = identityNode.getUUID();
        Identity identity = (Identity)this.identityCacheById.get((Serializable)((Object)nodeUUID));
        if (identity != null) {
            return identity;
        }
        identity = new Identity(nodeUUID);
        identity.setProviderId(identityNode.getProperty("exo:providerId").getString());
        identity.setRemoteId(identityNode.getProperty("exo:remoteId").getString());
        identity.setDeleted(identityNode.getProperty("exo:isDeleted").getBoolean());
        Profile profile = new Profile(identity);
        this.loadProfile(profile);
        identity.setProfile(profile);
        this.identityCacheById.put((Serializable)((Object)nodeUUID), (Object)identity);
        return identity;
    }

    private void createNodes(Node rootNode, String path) throws Exception {
        Node node = null;
        if (path.indexOf(SLASH_STR) < 0) {
            node = rootNode.addNode(path);
        } else {
            String[] ar = path.split(SLASH_STR);
            for (int i = 0; i < ar.length; ++i) {
                node = rootNode.hasNode(ar[i]) ? rootNode.getNode(ar[i]) : rootNode.addNode(ar[i], "nt:unstructured");
                rootNode = node;
            }
            if (rootNode.isNew()) {
                rootNode.getSession().save();
            } else {
                rootNode.getParent().save();
            }
        }
    }
}

