/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.common.jcr.Util;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceStorage {
    private static final Log LOG = ExoLogger.getLogger(SpaceStorage.class);
    private static final String SPACE_PROPERTIES_NAME_PATTERN = Util.getPropertiesNamePattern((String[])new String[]{"exo:app", "exo:avatarUrl", "exo:description", "exo:name", "exo:groupId", "exo:invitedUsers", "exo:parent", "exo:pendingUsers", "exo:prettyName", "exo:priority", "exo:registration", "exo:tag", "exo:type", "exo:url", "exo:visibility", "exo:creator", "exo:managers", "exo:members"});
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private static final String IMAGE_PATH = "image";
    private Node spaceHomeNode;
    private static final String PERCENT_STRING = "%";
    private static final String ASTERISK_STRING = "*";
    private static final char ASTERISK_CHARACTER = '*';
    private final ExoCache<String, Space> spaceCacheById;

    public SpaceStorage(SocialDataLocation dataLocation, CacheService cacheService) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
        this.spaceCacheById = cacheService.getCacheInstance("exo.social.SpaceStorage.SpaceCacheById");
    }

    public List<Space> getAllSpaces() throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        try {
            Session session = this.sessionManager.getOrOpenSession();
            List spacesNode = new QueryBuilder(session).select("exo:space").orderBy("exo:prettyName", "ASC").exec();
            for (Node node : spacesNode) {
                spaces.add(this.getSpaceFromNode(node, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ALL_SPACES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaces;
    }

    public List<Space> getSpaces(long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).orderBy("exo:prettyName", "ASC").exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getAllSpacesCount() throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            int n = (int)new QueryBuilder(session).select("exo:space").count();
            return n;
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Space> getSpacesByFilter(SpaceFilter spaceFilter, long offset, long limit) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getSpacesBySearchCondition(spaceNameSearchCondition, offset, limit);
        }
        return this.getSpacesByFirstCharacterOfName(spaceFilter.getFirstCharacterOfSpaceName(), offset, limit);
    }

    public int getAllSpacesByFilterCount(SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getSpacesBySearchConditionCount(spaceNameSearchCondition);
        }
        return this.getSpacesByFirstCharacterOfNameCount(spaceFilter.getFirstCharacterOfSpaceName());
    }

    public List<Space> getSpacesBySearchCondition(String searchCondition, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(searchCondition)) {
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                spaceNodes = (searchCondition = this.processSearchCondition(searchCondition)).indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space", offset, limit).like("exo:name", searchCondition).or().like("exo:description", searchCondition).exec() : new QueryBuilder(session).select("exo:space", offset, limit).contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_BY_SEARCH_CONDITION_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getSpacesBySearchConditionCount(String searchCondition) throws SpaceStorageException {
        int count = 0;
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                count = searchCondition.indexOf(PERCENT_STRING) >= 0 ? (int)new QueryBuilder(session).select("exo:space").like("exo:name", searchCondition).or().like("exo:description", searchCondition).count() : (int)new QueryBuilder(session).select("exo:space").contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_BY_SEARCH_CONDITION_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getSpacesByFirstCharacterOfName(char firstCharacterOfName, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCase = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = query.select("exo:space", offset, limit).like(query.lower("exo:name"), firstCharacterOfNameLowerCase).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_BY_FIRST_CHARACTER_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getSpacesByFirstCharacterOfNameCount(char firstCharacterOfName) throws SpaceStorageException {
        int count = 0;
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCase = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                count = (int)query.select("exo:space").like(query.lower("exo:name"), firstCharacterOfNameLowerCase).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_BY_FIRST_CHARACTER_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getAccessibleSpacesBySearchCondition(userId, spaceNameSearchCondition, offset, limit);
        }
        return this.getAccessibleSpacesByFirstCharacterOfName(userId, spaceFilter.getFirstCharacterOfSpaceName(), offset, limit);
    }

    public int getAccessibleSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getAccessibleSpacesBySearchConditionCount(userId, spaceNameSearchCondition);
        }
        return this.getAccessibleSpacesByFirstCharacterOfNameCount(userId, spaceFilter.getFirstCharacterOfSpaceName());
    }

    public List<Space> getAccessibleSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        List spaceNodes = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space").equal("exo:managers", userId).or().equal("exo:members", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ACCESSIBLE_SPACES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public List<Space> getAccessibleSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:managers", userId).or().equal("exo:members", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ACCESSIBLE_SPACES_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getAccessibleSpacesCount(String userId) throws SpaceStorageException {
        int count = 0;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            count = (int)new QueryBuilder(session).select("exo:space").equal("exo:managers", userId).or().equal("exo:members", userId).count();
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ACCESSIBLE_SPACES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getAccessibleSpacesBySearchCondition(String userId, String searchCondition, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                spaceNodes = searchCondition.indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space", offset, limit).group().equal("exo:managers", userId).or().equal("exo:members", userId).endGroup().and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().exec() : new QueryBuilder(session).select("exo:space", offset, limit).group().equal("exo:managers", userId).or().equal("exo:members", userId).endGroup().and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ACCESSIBLE_SPACES_BY_SEARCH_CONDITION, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getAccessibleSpacesBySearchConditionCount(String userId, String searchCondition) throws SpaceStorageException {
        int count = 0;
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                count = searchCondition.indexOf(PERCENT_STRING) >= 0 ? (int)new QueryBuilder(session).select("exo:space").group().equal("exo:managers", userId).or().equal("exo:members", userId).endGroup().and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().count() : (int)new QueryBuilder(session).select("exo:space").group().equal("exo:managers", userId).or().equal("exo:members", userId).endGroup().and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ACCESSIBLE_SPACES_BY_SEARCH_CONDITION_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getAccessibleSpacesByFirstCharacterOfName(String userId, char firstCharacterOfName, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                List spaceNodes = null;
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = query.select("exo:space", offset, limit).group().equal("exo:managers", userId).or().equal("exo:members", userId).endGroup().and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ACCESSIBLE_SPACES_BY_FIRST_CHARACTER, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getAccessibleSpacesByFirstCharacterOfNameCount(String userId, char firstCharacterOfName) throws SpaceStorageException {
        int count = 0;
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                Session session = this.sessionManager.getOrOpenSession();
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                QueryBuilder query = new QueryBuilder(session);
                count = (int)query.select("exo:space").group().equal("exo:managers", userId).or().equal("exo:members", userId).endGroup().and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_ACCESSIBLE_SPACES_BY_FIRST_CHARACTER_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getEditableSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getEditableSpacesBySearchCondition(userId, spaceNameSearchCondition, offset, limit);
        }
        return this.getEditableSpacesByFirstCharacterOfSpaceName(userId, spaceFilter.getFirstCharacterOfSpaceName(), offset, limit);
    }

    public int getEditableSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getEditableSpacesBySearchConditionCount(userId, spaceNameSearchCondition);
        }
        return this.getEditableSpacesByFirstCharacterOfSpaceNameCount(userId, spaceFilter.getFirstCharacterOfSpaceName());
    }

    public List<Space> getEditableSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space").equal("exo:managers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_EDITABLE_SPACES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public List<Space> getEditableSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:managers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_EDITABLE_SPACES_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getEditableSpacesCount(String userId) throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            int n = (int)new QueryBuilder(session).select("exo:space").equal("exo:managers", userId).count();
            return n;
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_EDITABLE_SPACES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Space> getEditableSpacesBySearchCondition(String userId, String spaceNameSearchCondition, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(spaceNameSearchCondition)) {
                spaceNameSearchCondition = this.processSearchCondition(spaceNameSearchCondition);
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                spaceNodes = spaceNameSearchCondition.indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:managers", userId).and().group().like("exo:name", spaceNameSearchCondition).or().like("exo:description", spaceNameSearchCondition).endGroup().exec() : new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:managers", userId).and().group().contains("exo:name", spaceNameSearchCondition).or().contains("exo:description", spaceNameSearchCondition).endGroup().exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_EDITABLE_SPACES_BY_SEARCH_CONDITION, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getEditableSpacesBySearchConditionCount(String userId, String spaceNameSearchCondition) throws SpaceStorageException {
        int count = 0;
        try {
            if (this.isValidInput(spaceNameSearchCondition)) {
                spaceNameSearchCondition = this.processSearchCondition(spaceNameSearchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                count = spaceNameSearchCondition.indexOf(PERCENT_STRING) >= 0 ? (int)new QueryBuilder(session).select("exo:space").equal("exo:managers", userId).and().group().like("exo:name", spaceNameSearchCondition).or().like("exo:description", spaceNameSearchCondition).endGroup().count() : (int)new QueryBuilder(session).select("exo:space").equal("exo:managers", userId).and().group().contains("exo:name", spaceNameSearchCondition).or().contains("exo:description", spaceNameSearchCondition).endGroup().count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_EDITABLE_SPACES_BY_SEARCH_CONDITION_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getEditableSpacesByFirstCharacterOfSpaceName(String userId, char firstCharacterOfSpaceName, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfSpaceName)) {
                List spaceNodes = null;
                String firstCharacterOfNameString = Character.toString(firstCharacterOfSpaceName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:managers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_EDITABLE_SPACES_BY_FIRST_CHARACTER, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getEditableSpacesByFirstCharacterOfSpaceNameCount(String userId, char firstCharacterOfSpaceName) throws SpaceStorageException {
        int count = 0;
        try {
            if (!Character.isDigit(firstCharacterOfSpaceName)) {
                String firstCharacterOfNameString = Character.toString(firstCharacterOfSpaceName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                count = (int)new QueryBuilder(session).select("exo:space").equal("exo:managers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_EDITABLE_SPACES_BY_FIRST_CHARACTER_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getInvitedSpacesBySearchCondition(userId, spaceNameSearchCondition, offset, limit);
        }
        return this.getInvitedSpacesByFirstCharacterOfName(userId, spaceFilter.getFirstCharacterOfSpaceName(), offset, limit);
    }

    public int getInvitedSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getInvitedSpacesBySearchConditionCount(userId, spaceNameSearchCondition);
        }
        return this.getInvitedSpacesByFirstCharacterNameCount(userId, spaceFilter.getFirstCharacterOfSpaceName());
    }

    public List<Space> getInvitedSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space").equal("exo:invitedUsers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_INVITED_SPACES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public List<Space> getInvitedSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:invitedUsers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_INVITED_SPACES_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getInvitedSpacesCount(String userId) throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            int n = (int)new QueryBuilder(session).select("exo:space").equal("exo:invitedUsers", userId).count();
            return n;
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_INVITED_SPACES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Space> getInvitedSpacesBySearchCondition(String userId, String searchCondition, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                spaceNodes = searchCondition.indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:invitedUsers", userId).and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().exec() : new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:invitedUsers", userId).and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_INVITED_SPACES_BY_SEARCH_CONDITION, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getInvitedSpacesBySearchConditionCount(String userId, String searchCondition) throws SpaceStorageException {
        int count = 0;
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                count = searchCondition.indexOf(PERCENT_STRING) >= 0 ? (int)new QueryBuilder(session).select("exo:space").equal("exo:invitedUsers", userId).and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().count() : (int)new QueryBuilder(session).select("exo:space").equal("exo:invitedUsers", userId).and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_INVITED_SPACES_BY_SEARCH_CONDITION_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getInvitedSpacesByFirstCharacterOfName(String userId, char firstCharacterOfName, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                Session session = this.sessionManager.getOrOpenSession();
                List spaceNodes = null;
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = query.select("exo:space", offset, limit).equal("exo:invitedUsers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_INVITED_SPACES_BY_FIRST_CHARACTER, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getInvitedSpacesByFirstCharacterNameCount(String userId, char firstCharacterOfName) throws SpaceStorageException {
        int count = 0;
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                Session session = this.sessionManager.getOrOpenSession();
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                QueryBuilder query = new QueryBuilder(session);
                count = (int)query.select("exo:space").equal("exo:invitedUsers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_INVITED_SPACES_BY_FIRST_CHARACTER_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getPendingSpacesBySearchCondition(userId, spaceNameSearchCondition, offset, limit);
        }
        return this.getPendingSpacesByFirstCharacterOfName(userId, spaceFilter.getFirstCharacterOfSpaceName(), offset, limit);
    }

    public int getPendingSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getPendingSpacesBySearchConditionCount(userId, spaceNameSearchCondition);
        }
        return this.getPendingSpacesByFirstCharacterOfNameCount(userId, spaceFilter.getFirstCharacterOfSpaceName());
    }

    public List<Space> getPendingSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space").equal("exo:pendingUsers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PENDING_SPACES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public List<Space> getPendingSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:pendingUsers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PENDING_SPACES_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getPendingSpacesCount(String userId) throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            int n = (int)new QueryBuilder(session).select("exo:space").equal("exo:pendingUsers", userId).count();
            return n;
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PENDING_SPACES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Space> getPendingSpacesBySearchCondition(String userId, String searchCondition, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                spaceNodes = searchCondition.indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:pendingUsers", userId).and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().exec() : new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:pendingUsers", userId).and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PENDING_SPACES_BY_SEARCH_CONDITION, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getPendingSpacesBySearchConditionCount(String userId, String searchCondition) throws SpaceStorageException {
        int count = 0;
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                count = searchCondition.indexOf(PERCENT_STRING) >= 0 ? (int)new QueryBuilder(session).select("exo:space").equal("exo:pendingUsers", userId).and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().count() : (int)new QueryBuilder(session).select("exo:space").equal("exo:pendingUsers", userId).and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PENDING_SPACES_BY_SEARCH_CONDITION_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getPendingSpacesByFirstCharacterOfName(String userId, char firstCharacterOfName, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                List spaceNodes = null;
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = query.select("exo:space", offset, limit).equal("exo:pendingUsers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PENDING_SPACES_BY_FIRST_CHARACTER, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getPendingSpacesByFirstCharacterOfNameCount(String userId, char firstCharacterOfName) throws SpaceStorageException {
        int count = 0;
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                count = (int)query.select("exo:space").equal("exo:pendingUsers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PENDING_SPACES_BY_FIRST_CHARACTER_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getPublicSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getPublicSpacesBySearchCondition(userId, spaceNameSearchCondition, offset, limit);
        }
        return this.getPublicSpacesByFirstCharacterOfName(userId, spaceFilter.getFirstCharacterOfSpaceName(), offset, limit);
    }

    public int getPublicSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            return this.getPublicSpacesBySearchConditionCount(userId, spaceNameSearchCondition);
        }
        return this.getPublicSpacesByFirstCharacterOfNameCount(userId, spaceFilter.getFirstCharacterOfSpaceName());
    }

    public List<Space> getPublicSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space").not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PUBLIC_SPACES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public List<Space> getPublicSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PUBLIC_SPACES_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getPublicSpacesCount(String userId) throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            int n = (int)new QueryBuilder(session).select("exo:space").not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).count();
            return n;
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PUBLIC_SPACES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Space> getPublicSpacesBySearchCondition(String userId, String searchCondition, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                List spaceNodes = null;
                spaceNodes = searchCondition.indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space", offset, limit).not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().exec() : new QueryBuilder(session).select("exo:space", offset, limit).not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PUBLIC_SPACES_BY_SEARCH_CONDITION, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getPublicSpacesBySearchConditionCount(String userId, String searchCondition) throws SpaceStorageException {
        int count = 0;
        try {
            if (this.isValidInput(searchCondition)) {
                searchCondition = this.processSearchCondition(searchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                count = searchCondition.indexOf(PERCENT_STRING) >= 0 ? (int)new QueryBuilder(session).select("exo:space").not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).and().group().like("exo:name", searchCondition).or().like("exo:description", searchCondition).endGroup().count() : (int)new QueryBuilder(session).select("exo:space").not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).and().group().contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).endGroup().count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PUBLIC_SPACES_BY_SEARCH_CONDITION_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getPublicSpacesByFirstCharacterOfName(String userId, char firstCharacterOfName, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = query.select("exo:space", offset, limit).not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PUBLIC_SPACES_BY_FIRST_CHARACTER, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getPublicSpacesByFirstCharacterOfNameCount(String userId, char firstCharacterOfName) throws SpaceStorageException {
        int count = 0;
        try {
            if (!Character.isDigit(firstCharacterOfName)) {
                String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                count = (int)query.select("exo:space").not().equal("exo:registration", "private").and().not().equal("exo:visibility", "hidden").and().not().equal("exo:invitedUsers", userId).and().not().equal("exo:members", userId).and().not().equal("exo:pendingUsers", userId).and().not().equal("exo:managers", userId).and().like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_PUBLIC_SPACES_BY_FIRST_CHARACTER_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && !spaceNameSearchCondition.equals("")) {
            return this.getMemberSpacesBySpaceNameSearchCondition(userId, spaceNameSearchCondition, offset, limit);
        }
        return this.getMemberSpacesByFirstCharacterOfSpaceName(userId, spaceFilter.getFirstCharacterOfSpaceName(), offset, limit);
    }

    public int getMemberSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && !spaceNameSearchCondition.equals("")) {
            return this.getMemberSpacesBySpaceNameSearchConditionCount(userId, spaceNameSearchCondition);
        }
        return this.getMemberSpacesByFirstCharacterOfSpaceNameCount(userId, spaceFilter.getFirstCharacterOfSpaceName());
    }

    public List<Space> getMemberSpacesBySpaceNameSearchCondition(String userId, String spaceNameSearchCondition, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(spaceNameSearchCondition)) {
                spaceNameSearchCondition = this.processSearchCondition(spaceNameSearchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                List spaceNodes = null;
                spaceNodes = spaceNameSearchCondition.indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:members", userId).and().group().like("exo:name", spaceNameSearchCondition).or().like("exo:description", spaceNameSearchCondition).endGroup().exec() : new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:members", userId).and().group().contains("exo:name", spaceNameSearchCondition).or().contains("exo:description", spaceNameSearchCondition).endGroup().exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_MEMBER_SPACES_BY_SEARCH_CONDITION, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getMemberSpacesBySpaceNameSearchConditionCount(String userId, String spaceNameSearchCondition) throws SpaceStorageException {
        int count = 0;
        try {
            if (this.isValidInput(spaceNameSearchCondition)) {
                spaceNameSearchCondition = this.processSearchCondition(spaceNameSearchCondition);
                Session session = this.sessionManager.getOrOpenSession();
                count = spaceNameSearchCondition.indexOf(PERCENT_STRING) >= 0 ? (int)new QueryBuilder(session).select("exo:space").equal("exo:members", userId).and().group().like("exo:name", spaceNameSearchCondition).or().like("exo:description", spaceNameSearchCondition).endGroup().count() : (int)new QueryBuilder(session).select("exo:space").equal("exo:members", userId).and().group().contains("exo:name", spaceNameSearchCondition).or().contains("exo:description", spaceNameSearchCondition).endGroup().count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_MEMBER_SPACES_BY_SEARCH_CONDITION_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getMemberSpacesByFirstCharacterOfSpaceName(String userId, char firstCharacterOfSpaceName, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfSpaceName)) {
                List spaceNodes = null;
                String firstCharacterOfSpaceNameString = Character.toString(firstCharacterOfSpaceName);
                String firstCharacterOfSpaceNameQuery = firstCharacterOfSpaceNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = query.select("exo:space", offset, limit).equal("exo:members", userId).and().like(query.lower("exo:name"), firstCharacterOfSpaceNameQuery).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_MEMBER_SPACES_BY_FIRST_CHARACTER, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getMemberSpacesByFirstCharacterOfSpaceNameCount(String userId, char firstCharacterOfSpaceName) throws SpaceStorageException {
        int count = 0;
        try {
            if (!Character.isDigit(firstCharacterOfSpaceName)) {
                String firstCharacterOfSpaceNameString = Character.toString(firstCharacterOfSpaceName);
                String firstCharacterOfSpaceNameQuery = firstCharacterOfSpaceNameString.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                count = (int)query.select("exo:space").equal("exo:members", userId).and().like(query.lower("exo:name"), firstCharacterOfSpaceNameQuery).count();
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_MEMBER_SPACES_BY_FIRST_CHARACTER_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    public List<Space> getMemberSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space").equal("exo:members", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_MEMBER_SPACES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public List<Space> getMemberSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            List spaceNodes = null;
            Session session = this.sessionManager.getOrOpenSession();
            spaceNodes = new QueryBuilder(session).select("exo:space", offset, limit).equal("exo:members", userId).exec();
            for (Node spaceNode : spaceNodes) {
                spaceList.add(this.getSpaceFromNode(spaceNode, session));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_MEMBER_SPACES_WITH_OFFSET, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public int getMemberSpacesCount(String userId) throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            int n = (int)new QueryBuilder(session).select("exo:space").equal("exo:members", userId).count();
            return n;
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_MEMBER_SPACES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public Space getSpaceByGroupId(String groupId) throws SpaceStorageException {
        Space space = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node foundNode = new QueryBuilder(session).select("exo:space").equal("exo:groupId", groupId).findNode();
            if (foundNode != null) {
                space = this.getSpaceFromNode(foundNode, session);
            } else {
                LOG.warn((Object)("Not found node with groupId: " + groupId));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACE_BY_GROUP_ID, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    public Space getSpaceById(String id) throws SpaceStorageException {
        Space cachedSpace = (Space)this.spaceCacheById.get((Serializable)((Object)id));
        if (cachedSpace != null) {
            return cachedSpace;
        }
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node spaceNode = session.getNodeByUUID(id);
            if (spaceNode != null) {
                Space space = this.getSpaceFromNode(spaceNode, session);
                return space;
            }
            LOG.warn((Object)("No node found for space: " + id));
            Space space = null;
            return space;
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACE_BY_ID, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Space> getSpacesBySearchCondition(String searchCondition) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (this.isValidInput(searchCondition)) {
                List spaceNodes = null;
                Session session = this.sessionManager.getOrOpenSession();
                spaceNodes = (searchCondition = this.processSearchCondition(searchCondition)).indexOf(PERCENT_STRING) >= 0 ? new QueryBuilder(session).select("exo:space").like("exo:name", searchCondition).or().like("exo:description", searchCondition).exec() : new QueryBuilder(session).select("exo:space").contains("exo:name", searchCondition).or().contains("exo:description", searchCondition).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_BY_SEARCH_CONDITION, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public List<Space> getSpacesByFirstCharacterOfName(String firstCharacterOfName) throws SpaceStorageException {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        try {
            if (!Character.isDigit(firstCharacterOfName.charAt(0))) {
                List spaceNodes = null;
                String firstCharacterOfNameLowerCaseQuery = firstCharacterOfName.toLowerCase() + PERCENT_STRING;
                Session session = this.sessionManager.getOrOpenSession();
                QueryBuilder query = new QueryBuilder(session);
                spaceNodes = query.select("exo:space").like(query.lower("exo:name"), firstCharacterOfNameLowerCaseQuery).exec();
                for (Node spaceNode : spaceNodes) {
                    spaceList.add(this.getSpaceFromNode(spaceNode, session));
                }
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACES_BY_FIRST_CHARACTER, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return spaceList;
    }

    public Space getSpaceByDisplayName(String spaceDisplayName) throws SpaceStorageException {
        Space space = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node foundNode = new QueryBuilder(session).select("exo:space").equal("exo:name", spaceDisplayName).findNode();
            if (foundNode != null) {
                space = this.getSpaceFromNode(foundNode, session);
            } else {
                LOG.warn((Object)("Not found node: " + spaceDisplayName));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACE_BY_DISPLAY_NAME, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    public Space getSpaceByName(String spaceName) throws SpaceStorageException {
        try {
            return this.getSpaceByPrettyName(spaceName);
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACE_BY_NAME, e.getMessage(), e);
        }
    }

    public Space getSpaceByPrettyName(String spacePrettyName) throws SpaceStorageException {
        Space space = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node foundNodeSpace = new QueryBuilder(session).select("exo:space").equal("exo:prettyName", spacePrettyName).findNode();
            if (foundNodeSpace != null) {
                space = this.getSpaceFromNode(foundNodeSpace, session);
            } else {
                LOG.warn((Object)("Node not found for spacePrettyName:  " + spacePrettyName));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACE_BY_PRETTY_NAME, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    public Space getSpaceByUrl(String url) throws SpaceStorageException {
        Space space = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node foundNode = new QueryBuilder(session).select("exo:space").equal("exo:url", url).findNode();
            if (foundNode != null) {
                space = this.getSpaceFromNode(foundNode, session);
            } else {
                LOG.warn((Object)("No node found for url: " + url));
            }
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_GET_SPACE_BY_URL, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    public void deleteSpace(String id) throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node spaceNode = session.getNodeByUUID(id);
            if (spaceNode != null) {
                spaceNode.remove();
                session.save();
            } else {
                LOG.warn((Object)("Failed to find a spaceNode by its id: " + id));
            }
            this.spaceCacheById.remove((Serializable)((Object)id));
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_DELETE_SPACE, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    public void saveSpace(Space space, boolean isNew) throws SpaceStorageException {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            this.spaceHomeNode = this.getSpaceHomeNode(session);
            this.saveSpace(this.spaceHomeNode, space, isNew, session);
        }
        catch (Exception e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_SAVE_SPACE, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSpace(Node spaceHomeNode, Space space, boolean isNew, Session session) {
        try {
            Node spaceNode;
            if (isNew) {
                spaceNode = spaceHomeNode.addNode("exo:space", "exo:space");
                spaceNode.addMixin("mix:referenceable");
            } else {
                spaceNode = session.getNodeByUUID(space.getId());
            }
            if (space.getId() == null) {
                space.setId(spaceNode.getUUID());
            }
            this.setNodeFromSpace(space, spaceNode);
            AvatarAttachment attachment = space.getAvatarAttachment();
            if (attachment != null) {
                ExtendedNode extNode = (ExtendedNode)spaceNode;
                if (extNode.canAddMixin("exo:privilegeable")) {
                    extNode.addMixin("exo:privilegeable");
                }
                String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                extNode.setPermission(SystemIdentity.ANY, arrayPers);
                List permsList = extNode.getACL().getPermissionEntries();
                for (AccessControlEntry accessControlEntry : permsList) {
                    extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
                }
                if (attachment.getFileName() != null) {
                    Node nodeFile = null;
                    try {
                        nodeFile = spaceNode.getNode(IMAGE_PATH);
                    }
                    catch (PathNotFoundException e) {
                        nodeFile = spaceNode.addNode(IMAGE_PATH, "nt:file");
                    }
                    Node nodeContent = null;
                    try {
                        nodeContent = nodeFile.getNode("jcr:content");
                    }
                    catch (PathNotFoundException e) {
                        nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                    }
                    long lastModified = attachment.getLastModified();
                    long lastSaveTime = 0L;
                    if (nodeContent.hasProperty("jcr:lastModified")) {
                        lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
                    }
                    if (lastModified != 0L && lastModified != lastSaveTime) {
                        nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                        nodeContent.setProperty("jcr:data", attachment.getInputStream(session));
                        nodeContent.setProperty("jcr:lastModified", attachment.getLastModified());
                    }
                }
            } else if (spaceNode.hasNode(IMAGE_PATH)) {
                spaceNode.getNode(IMAGE_PATH).remove();
                session.save();
            }
            if (isNew) {
                spaceHomeNode.save();
            } else {
                spaceNode.save();
                this.spaceCacheById.remove((Serializable)((Object)spaceNode.getUUID()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save space", (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    private void setNodeFromSpace(Space space, Node spaceNode) throws RepositoryException {
        spaceNode.setProperty("exo:name", space.getDisplayName());
        spaceNode.setProperty("exo:groupId", space.getGroupId());
        spaceNode.setProperty("exo:app", space.getApp());
        spaceNode.setProperty("exo:parent", space.getParent());
        spaceNode.setProperty("exo:description", space.getDescription());
        spaceNode.setProperty("exo:tag", space.getTag());
        spaceNode.setProperty("exo:pendingUsers", space.getPendingUsers());
        spaceNode.setProperty("exo:invitedUsers", space.getInvitedUsers());
        spaceNode.setProperty("exo:type", space.getType());
        spaceNode.setProperty("exo:url", space.getUrl());
        spaceNode.setProperty("exo:visibility", space.getVisibility());
        spaceNode.setProperty("exo:registration", space.getRegistration());
        spaceNode.setProperty("exo:priority", space.getPriority());
        spaceNode.setProperty("exo:prettyName", space.getPrettyName());
        spaceNode.setProperty("exo:avatarUrl", space.getAvatarUrl());
        spaceNode.setProperty("exo:creator", space.getCreator());
        spaceNode.setProperty("exo:managers", space.getManagers());
        spaceNode.setProperty("exo:members", space.getMembers());
    }

    private Space getSpaceFromNode(Node spaceNode, Session session) throws SpaceException {
        Space space = null;
        try {
            Node image;
            String id = spaceNode.getUUID();
            space = (Space)this.spaceCacheById.get((Serializable)((Object)id));
            if (space != null) {
                return space;
            }
            space = new Space();
            space.setId(spaceNode.getUUID());
            PropertyIterator itr = spaceNode.getProperties(SPACE_PROPERTIES_NAME_PATTERN);
            while (itr.hasNext()) {
                Property p = itr.nextProperty();
                String propertyName = p.getName();
                if ("exo:name".equals(propertyName)) {
                    space.setDisplayName(p.getString());
                    continue;
                }
                if ("exo:groupId".equals(propertyName)) {
                    space.setGroupId(p.getString());
                    continue;
                }
                if ("exo:app".equals(propertyName)) {
                    space.setApp(p.getString());
                    continue;
                }
                if ("exo:parent".equals(propertyName)) {
                    space.setParent(p.getString());
                    continue;
                }
                if ("exo:description".equals(propertyName)) {
                    space.setDescription(p.getString());
                    continue;
                }
                if ("exo:tag".equals(propertyName)) {
                    space.setTag(p.getString());
                    continue;
                }
                if ("exo:pendingUsers".equals(propertyName)) {
                    space.setPendingUsers(Util.convertValuesToStrings((Value[])p.getValues()));
                    continue;
                }
                if ("exo:invitedUsers".equals(propertyName)) {
                    space.setInvitedUsers(Util.convertValuesToStrings((Value[])p.getValues()));
                    continue;
                }
                if ("exo:type".equals(propertyName)) {
                    space.setType(p.getString());
                    continue;
                }
                if ("exo:url".equals(propertyName)) {
                    space.setUrl(p.getString());
                    continue;
                }
                if ("exo:visibility".equals(propertyName)) {
                    space.setVisibility(p.getString());
                    continue;
                }
                if ("exo:registration".equals(propertyName)) {
                    space.setRegistration(p.getString());
                    continue;
                }
                if ("exo:priority".equals(propertyName)) {
                    space.setPriority(p.getString());
                    continue;
                }
                if ("exo:prettyName".equals(propertyName)) {
                    space.setPrettyName(p.getString());
                    continue;
                }
                if ("exo:avatarUrl".equals(propertyName)) {
                    space.setAvatarUrl(p.getString());
                    continue;
                }
                if ("exo:creator".equals(propertyName)) {
                    space.setCreator(p.getString());
                    continue;
                }
                if ("exo:managers".equals(propertyName)) {
                    space.setManagers(Util.convertValuesToStrings((Value[])p.getValues()));
                    continue;
                }
                if (!"exo:members".equals(propertyName)) continue;
                space.setMembers(Util.convertValuesToStrings((Value[])p.getValues()));
            }
            if (spaceNode.hasNode(IMAGE_PATH) && (image = spaceNode.getNode(IMAGE_PATH)).isNodeType("nt:file")) {
                AvatarAttachment file = new AvatarAttachment();
                file.setId(image.getPath());
                file.setMimeType(image.getNode("jcr:content").getProperty("jcr:mimeType").getString());
                try {
                    file.setInputStream(image.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
                }
                catch (Exception e) {
                    LOG.warn((Object)"Failed to setInputStream in space", (Throwable)e);
                }
                file.setFileName(image.getName());
                file.setLastModified(image.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
                file.setWorkspace(session.getWorkspace().getName());
                space.setAvatarAttachment(file);
            }
            this.spaceCacheById.put((Serializable)((Object)id), (Object)space);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to getSpaceFromNode", (Throwable)e);
        }
        return space;
    }

    private Node getSpaceHomeNode(Session session) throws SpaceException {
        try {
            if (this.spaceHomeNode == null) {
                String path = this.dataLocation.getSocialSpaceHome();
                this.spaceHomeNode = session.getRootNode().getNode(path);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to getSpaceHomeNode", (Throwable)e);
        }
        return this.spaceHomeNode;
    }

    private String processSearchCondition(String searchCondition) {
        StringBuffer searchConditionBuffer = new StringBuffer();
        if (searchCondition.indexOf(ASTERISK_STRING) < 0 && searchCondition.indexOf(PERCENT_STRING) < 0) {
            if (searchCondition.charAt(0) != '*') {
                searchConditionBuffer.append(ASTERISK_STRING).append(searchCondition);
            }
            if (searchCondition.charAt(searchCondition.length() - 1) != '*') {
                searchConditionBuffer.append(ASTERISK_STRING);
            }
        } else {
            searchCondition = searchCondition.replace(ASTERISK_STRING, PERCENT_STRING);
            searchConditionBuffer.append(PERCENT_STRING).append(searchCondition).append(PERCENT_STRING);
        }
        return searchConditionBuffer.toString();
    }

    private boolean isValidInput(String input) {
        if (input == null) {
            return false;
        }
        String cleanString = input.replaceAll("\\*", "");
        if ((cleanString = cleanString.replaceAll("\\%", "")).length() > 0 && Character.isDigit(cleanString.charAt(0))) {
            return false;
        }
        return cleanString.length() != 0;
    }
}

