/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.exoplatform.social.common.lifecycle.LifeCycleEvent;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLifeCycle<T extends LifeCycleListener<E>, E extends LifeCycleEvent<?, ?>> {
    private Set<T> listeners = new HashSet<T>();
    protected ExecutorService executor = Executors.newSingleThreadExecutor();
    protected ExecutorCompletionService<E> ecs;

    public void addListener(T listener) {
        this.listeners.add(listener);
    }

    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    protected void broadcast(E event) {
        if (this.ecs == null) {
            this.ecs = new ExecutorCompletionService(this.executor);
        }
        for (final LifeCycleListener listener : this.listeners) {
            this.ecs.submit(new Callable<E>((LifeCycleEvent)event){
                final /* synthetic */ LifeCycleEvent val$event;
                {
                    this.val$event = lifeCycleEvent;
                }

                @Override
                public E call() throws Exception {
                    AbstractLifeCycle.this.dispatchEvent(listener, this.val$event);
                    return this.val$event;
                }
            });
        }
    }

    protected abstract void dispatchEvent(T var1, E var2);
}

