/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web.fckeditor;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.frameworks.jcr.web.fckeditor.FCKeditor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JCRContentFCKeditor
extends FCKeditor {
    private static final Log LOG = ExoLogger.getLogger("exo.jcr.framework.command.JCRContentFCKeditor");
    private Node file;

    public JCRContentFCKeditor(HttpServletRequest req, String parInstanceName, String workspaceName, String filePath, String newNodeType) throws RepositoryException {
        super(req, parInstanceName);
        ExoContainer container = (ExoContainer)req.getSession().getServletContext().getAttribute("org.exoplatform.frameworks.web.eXoContainer");
        if (container == null) {
            container = PortalContainer.getCurrentInstance((ServletContext)req.getSession().getServletContext());
        }
        SessionProviderService sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository repo = repositoryService.getCurrentRepository();
        Session session = sessionProviderService.getSessionProvider(null).getSession(repo.getConfiguration().getDefaultWorkspaceName(), repo);
        try {
            this.file = (Node)session.getItem(filePath);
        }
        catch (PathNotFoundException e1) {
            this.file = session.getRootNode().addNode(filePath.substring(1), newNodeType);
        }
        if (!this.file.isNodeType("nt:file")) {
            throw new RepositoryException("The Node should be nt:file type");
        }
        try {
            Property content = (Property)session.getItem(filePath + "/jcr:content/jcr:data");
            this.setValue(content.getString());
        }
        catch (RepositoryException e) {
            LOG.error("Repository error " + (Object)((Object)e), e);
        }
    }

    public void saveValue(String value) throws RepositoryException {
        this.file.getNode("jcr:content").setProperty("jcr:data", value);
        this.setValue(value);
        this.file.getSession().save();
    }
}

