/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.AddPathPlugin;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeHierarchyCreatorImpl
implements NodeHierarchyCreator,
Startable {
    private static final Log log = ExoLogger.getLogger("exo.jcr.component.ext.NodeHierarchyCreatorImpl");
    private static final String USERS_PATH = "usersPath";
    private static final String USER_APPLICATION = "userApplicationData";
    private static final String PUBLIC_APPLICATION = "eXoApplications";
    private static final String USER_PRIVATE = "userPrivate";
    private static final String USER_PUBLIC = "userPublic";
    private final RepositoryService jcrService_;
    private final DataDistributionManager dataDistributionManager_;
    private final List<AddPathPlugin> pathPlugins_ = new ArrayList<AddPathPlugin>();
    private final Map<String, String> paths_ = new HashMap<String, String>();
    private final boolean oldDistribution;

    public NodeHierarchyCreatorImpl(RepositoryService jcrService, InitParams params) {
        this(jcrService, null, params);
    }

    public NodeHierarchyCreatorImpl(RepositoryService jcrService, DataDistributionManager dataDistributionManager, InitParams params) {
        if (dataDistributionManager == null) {
            throw new IllegalArgumentException("The DataDistributionManager is now mandatory if you use the NodeHierarchyCreator, so please define it in your configuration as described in the JCR documentation");
        }
        this.jcrService_ = jcrService;
        this.dataDistributionManager_ = dataDistributionManager;
        boolean bl = this.oldDistribution = params != null && params.getValueParam("old-user-distribution") != null && Boolean.valueOf(params.getValueParam("old-user-distribution").getValue()) != false;
        if (PropertyManager.isDevelopping() && !this.oldDistribution) {
            log.info("The NodeHierarchyCreator is configured to use the new distribution mechanism for the users directories, if you prefer to use the old mechanism set the value parameter 'old-user-distribution' to 'true'.");
        }
    }

    public void start() {
        try {
            this.processAddPathPlugin();
        }
        catch (Exception e) {
            log.error("An error occurs while processing the plugins", e);
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        this.init();
    }

    @Override
    public void init() throws Exception {
        this.initBasePath();
    }

    private void createNode(Node rootNode, String path, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws Exception {
        this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(rootNode, path, nodeType, mixinTypes, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddPathPlugin() throws Exception {
        Session session = null;
        ManageableRepository currentRepo = this.jcrService_.getCurrentRepository();
        for (AddPathPlugin pathPlugin : this.pathPlugins_) {
            List<HierarchyConfig.JcrPath> jcrPaths;
            HierarchyConfig hierarchyConfig = pathPlugin.getPaths();
            if (hierarchyConfig == null || (jcrPaths = hierarchyConfig.getJcrPaths()) == null) continue;
            LinkedHashSet<String> workspaceNames = new LinkedHashSet<String>();
            if (hierarchyConfig.getWorkspaces() != null) {
                workspaceNames.addAll(hierarchyConfig.getWorkspaces());
            }
            workspaceNames.add(currentRepo.getConfiguration().getDefaultWorkspaceName());
            for (String workspaceName : workspaceNames) {
                HierarchyConfig.JcrPath currentjcrPath = null;
                try {
                    session = currentRepo.getSystemSession(workspaceName);
                    Node rootNode = session.getRootNode();
                    Iterator<HierarchyConfig.JcrPath> i$ = jcrPaths.iterator();
                    while (i$.hasNext()) {
                        HierarchyConfig.JcrPath jcrPath;
                        currentjcrPath = jcrPath = i$.next();
                        if (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC)) continue;
                        this.createNode(rootNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(null));
                    }
                }
                catch (Exception e) {
                    log.error("An error occurs while processing the JCR path which alias is " + (currentjcrPath == null ? null : currentjcrPath.getAlias()) + " with the workspace " + workspaceName, e);
                }
                finally {
                    if (session == null) continue;
                    session.logout();
                    session = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBasePath() throws Exception {
        Session session = null;
        ManageableRepository manageableRepository = this.jcrService_.getCurrentRepository();
        String defaultWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        String systemWorkspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
        boolean isSameWorksapce = defaultWorkspace.equalsIgnoreCase(systemWorkspace);
        String[] workspaceNames = manageableRepository.getWorkspaceNames();
        for (AddPathPlugin pathPlugin : this.pathPlugins_) {
            List<HierarchyConfig.JcrPath> jcrPaths;
            HierarchyConfig hierarchyConfig = pathPlugin.getPaths();
            if (hierarchyConfig == null || (jcrPaths = hierarchyConfig.getJcrPaths()) == null) continue;
            for (String workspaceName : workspaceNames) {
                if (!isSameWorksapce && workspaceName.equalsIgnoreCase(systemWorkspace)) continue;
                HierarchyConfig.JcrPath currentjcrPath = null;
                try {
                    session = manageableRepository.getSystemSession(workspaceName);
                    Node rootNode = session.getRootNode();
                    Iterator<HierarchyConfig.JcrPath> i$ = jcrPaths.iterator();
                    while (i$.hasNext()) {
                        HierarchyConfig.JcrPath jcrPath;
                        currentjcrPath = jcrPath = i$.next();
                        if (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC)) continue;
                        this.createNode(rootNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(null));
                    }
                }
                catch (Exception e) {
                    log.error("An error occurs while processing the JCR path which alias is " + (currentjcrPath == null ? null : currentjcrPath.getAlias()) + " with the workspace " + workspaceName, e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                        session = null;
                    }
                }
            }
        }
    }

    @Override
    public Node getUserApplicationNode(SessionProvider sessionProvider, String userName) throws Exception {
        Node userNode = this.getUserNode(sessionProvider, userName);
        return this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(userNode, this.getJcrPath(USER_APPLICATION));
    }

    @Override
    public Node getPublicApplicationNode(SessionProvider sessionProvider) throws Exception {
        Session session = this.getSession(sessionProvider);
        Node rootNode = session.getRootNode();
        return this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getDataNode(rootNode, this.getJcrPath(PUBLIC_APPLICATION));
    }

    @Override
    public Node getUserNode(SessionProvider sessionProvider, String userName) throws Exception {
        String userPath = this.getJcrPath(USERS_PATH);
        Session session = this.getSession(sessionProvider);
        Node usersNode = (Node)session.getItem(userPath);
        DataDistributionType type = this.dataDistributionManager_.getDataDistributionType(this.oldDistribution ? DataDistributionMode.NONE : DataDistributionMode.READABLE);
        return type.getOrCreateDataNode(usersNode, userName);
    }

    @Override
    public void removeUserNode(SessionProvider sessionProvider, String userName) throws Exception {
        String userPath = this.getJcrPath(USERS_PATH);
        Session session = this.getSession(sessionProvider);
        try {
            Node usersNode = (Node)session.getItem(userPath);
            DataDistributionType type = this.dataDistributionManager_.getDataDistributionType(this.oldDistribution ? DataDistributionMode.NONE : DataDistributionMode.READABLE);
            type.removeDataNode(usersNode, userName);
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    private Session getSession(SessionProvider sessionProvider) throws RepositoryException {
        ManageableRepository repo = this.jcrService_.getCurrentRepository();
        return sessionProvider.getSession(repo.getConfiguration().getDefaultWorkspaceName(), repo);
    }

    @Override
    public String getJcrPath(String alias) {
        return this.paths_.get(alias);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddPathPlugin) {
            AddPathPlugin app = (AddPathPlugin)plugin;
            this.pathPlugins_.add(app);
            if (app.getPaths() != null && app.getPaths().getJcrPaths() != null) {
                for (HierarchyConfig.JcrPath jcrPath : app.getPaths().getJcrPaths()) {
                    if (jcrPath.getAlias() == null || jcrPath.getPath() == null) continue;
                    this.paths_.put(jcrPath.getAlias(), jcrPath.getPath());
                }
            }
        }
    }
}

