/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.File;
import java.io.IOException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.backup.JCRRestor;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SysViewWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;

public class BackupWorkspaceInitializer
extends SysViewWorkspaceInitializer {
    protected final String restoreDir;

    public BackupWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, FileCleanerHolder cleanerHolder) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager, cleanerHolder);
        this.restoreDir = this.restorePath;
        String fullBackupPath = PrivilegedFileHelper.getAbsolutePath((File)JCRRestor.getFullBackupFile(new File(this.restoreDir)));
        if (fullBackupPath == null) {
            throw new RepositoryException("Can't find full backup storage");
        }
        this.restorePath = fullBackupPath;
    }

    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        try {
            long start = System.currentTimeMillis();
            PlainChangesLog changes = this.read();
            TransactionChangesLog tLog = new TransactionChangesLog(changes);
            tLog.setSystemId("JCR_CORE_RESOTRE_WORKSPACE_INITIALIZER_SYSTEM_ID");
            this.dataManager.save(tLog);
            JCRRestor restorer = new JCRRestor(this.dataManager, this.fileCleaner);
            for (File incrBackupFile : JCRRestor.getIncrementalFiles(new File(this.restoreDir))) {
                restorer.incrementalRestore(incrBackupFile);
            }
            NodeData root = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
            log.info((Object)("Workspace " + this.workspaceName + " restored from file " + this.restorePath + " in " + (double)(System.currentTimeMillis() - start) * 1.0 / 1000.0 + "sec"));
            return root;
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("The XML file is corrupted : " + this.restorePath, (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

