/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.io.InputStream;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.InmemoryNodeTypeRepository;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemAutocreator;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerListener;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeRepository;
import org.exoplatform.services.jcr.impl.core.nodetype.VolatileNodeTypeDataManager;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeConverter;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDataValidator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.PropertyDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.XmlNodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeDataManagerImpl
implements NodeTypeDataManager,
Startable {
    private static final String NODETYPES_FILE = "nodetypes.xml";
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.NodeTypeDataManagerImpl");
    protected final String accessControlPolicy;
    protected final ItemDataConsumer dataManager;
    protected final RepositoryIndexSearcherHolder indexSearcherHolder;
    protected final LocationFactory locationFactory;
    protected final NamespaceRegistry namespaceRegistry;
    private final Set<InternalQName> buildInNodeTypesNames;
    protected final NodeTypeRepository nodeTypeRepository;
    protected final NodeTypeConverter nodeTypeConverter;
    protected final NodeTypeDataValidator nodeTypeDataValidator;
    private final Map<NodeTypeManagerListener, NodeTypeManagerListener> listeners;
    private final ValueFactoryImpl valueFactory;
    private boolean started = false;

    public NodeTypeDataManagerImpl(String accessControlPolicy, LocationFactory locationFactory, NamespaceRegistry namespaceRegistry, NodeTypeDataPersister persister, ItemDataConsumer dataManager, RepositoryIndexSearcherHolder indexSearcherHolder, NodeTypeRepository nodeTypeRepository) {
        this.namespaceRegistry = namespaceRegistry;
        this.locationFactory = locationFactory;
        this.dataManager = dataManager;
        this.indexSearcherHolder = indexSearcherHolder;
        this.valueFactory = new ValueFactoryImpl(locationFactory);
        this.accessControlPolicy = accessControlPolicy;
        this.nodeTypeRepository = nodeTypeRepository;
        this.listeners = Collections.synchronizedMap(new WeakHashMap());
        this.buildInNodeTypesNames = new HashSet<InternalQName>();
        this.nodeTypeConverter = new NodeTypeConverter(this.locationFactory, this.accessControlPolicy);
        this.nodeTypeDataValidator = new NodeTypeDataValidator(this.locationFactory, this.nodeTypeRepository);
    }

    public NodeTypeDataManagerImpl(RepositoryEntry config, LocationFactory locationFactory, NamespaceRegistry namespaceRegistry, NodeTypeDataPersister persister, ItemDataConsumer dataManager, RepositoryIndexSearcherHolder indexSearcherHolder) {
        this(config.getAccessControl(), locationFactory, namespaceRegistry, persister, dataManager, indexSearcherHolder, new InmemoryNodeTypeRepository(persister));
    }

    public void addListener(NodeTypeManagerListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    @Override
    public NodeDefinitionData[] getAllChildNodeDefinitions(InternalQName ... nodeTypeNames) {
        ArrayList<NodeDefinitionData> defsAny = new ArrayList<NodeDefinitionData>();
        HashMap<InternalQName, NodeDefinitionData> defs = new HashMap<InternalQName, NodeDefinitionData>();
        for (InternalQName ntname : nodeTypeNames) {
            for (InternalQName suname : this.nodeTypeRepository.getSupertypes(ntname)) {
                for (NodeDefinitionData cnd : this.nodeTypeRepository.getNodeType(suname).getDeclaredChildNodeDefinitions()) {
                    if (cnd.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                        defsAny.add(cnd);
                        continue;
                    }
                    defs.put(cnd.getName(), cnd);
                }
            }
            for (NodeDefinitionData cnd : this.nodeTypeRepository.getNodeType(ntname).getDeclaredChildNodeDefinitions()) {
                if (cnd.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                    defsAny.add(cnd);
                    continue;
                }
                defs.put(cnd.getName(), cnd);
            }
        }
        defsAny.addAll(defs.values());
        return defsAny.toArray(new NodeDefinitionData[defsAny.size()]);
    }

    @Override
    public List<NodeTypeData> getAllNodeTypes() {
        try {
            return this.nodeTypeRepository.getAllNodeTypes();
        }
        catch (RepositoryException e) {
            this.log.error((Object)e.getLocalizedMessage());
            return new ArrayList<NodeTypeData>();
        }
    }

    @Override
    public PropertyDefinitionData[] getAllPropertyDefinitions(InternalQName ... nodeTypeNames) {
        ArrayList<PropertyDefinitionData> defsAny = new ArrayList<PropertyDefinitionData>();
        HashMap<InternalQName, PropertyDefinitionData> defs = new HashMap<InternalQName, PropertyDefinitionData>();
        for (InternalQName ntname : nodeTypeNames) {
            for (InternalQName suname : this.nodeTypeRepository.getSupertypes(ntname)) {
                for (PropertyDefinitionData pd : this.nodeTypeRepository.getNodeType(suname).getDeclaredPropertyDefinitions()) {
                    if (pd.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                        defsAny.add(pd);
                        continue;
                    }
                    defs.put(pd.getName(), pd);
                }
            }
            for (PropertyDefinitionData pd : this.nodeTypeRepository.getNodeType(ntname).getDeclaredPropertyDefinitions()) {
                if (pd.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                    defsAny.add(pd);
                    continue;
                }
                defs.put(pd.getName(), pd);
            }
        }
        defsAny.addAll(defs.values());
        return defsAny.toArray(new PropertyDefinitionData[defsAny.size()]);
    }

    @Override
    public NodeDefinitionData getChildNodeDefinition(InternalQName nodeName, InternalQName ... nodeTypeNames) throws RepositoryException {
        return this.nodeTypeRepository.getDefaultChildNodeDefinition(nodeName, nodeTypeNames);
    }

    @Override
    public NodeDefinitionData getChildNodeDefinition(InternalQName nodeName, InternalQName primaryNodeType, InternalQName[] mixinTypes) throws RepositoryException {
        return this.getChildNodeDefinition(nodeName, this.getNodeTypeNames(primaryNodeType, mixinTypes));
    }

    @Override
    public NodeDefinitionData getChildNodeDefinition(InternalQName nodeName, InternalQName nodeType, InternalQName parentNodeType, InternalQName[] parentMixinTypes) throws RepositoryException {
        NodeDefinitionData[] defs = this.getAllChildNodeDefinitions(this.getNodeTypeNames(parentNodeType, parentMixinTypes));
        NodeDefinitionData residualDef = null;
        NodeDefinitionData firstResidualDef = null;
        block0: for (NodeDefinitionData nodeDef : defs) {
            if (nodeDef.getName().equals((Object)nodeName)) {
                return nodeDef;
            }
            if (!nodeDef.isResidualSet()) continue;
            if (firstResidualDef == null) {
                firstResidualDef = nodeDef;
            }
            for (InternalQName requiredPrimaryType : nodeDef.getRequiredPrimaryTypes()) {
                if (!this.isNodeType(requiredPrimaryType, nodeType)) continue block0;
            }
            if (residualDef != null && !this.isNodeType(residualDef.getRequiredPrimaryTypes()[0], nodeDef.getRequiredPrimaryTypes()[0])) continue;
            residualDef = nodeDef;
        }
        return residualDef != null ? residualDef : firstResidualDef;
    }

    @Override
    public Set<InternalQName> getDeclaredSubtypes(InternalQName nodeTypeName) {
        return this.nodeTypeRepository.getDeclaredSubtypes(nodeTypeName);
    }

    @Override
    public List<ItemDefinitionData> getManadatoryItemDefs(InternalQName primaryNodeType, InternalQName[] mixinTypes) throws RepositoryException {
        HashSet<ItemDefinitionData> mandatoryDefs = new HashSet<ItemDefinitionData>();
        ItemDefinitionData[] itemDefs = this.getAllPropertyDefinitions(primaryNodeType);
        for (ItemDefinitionData itemDef : itemDefs) {
            if (!itemDef.isMandatory()) continue;
            mandatoryDefs.add(itemDef);
        }
        itemDefs = this.getAllChildNodeDefinitions(primaryNodeType);
        for (ItemDefinitionData itemDef : itemDefs) {
            if (!itemDef.isMandatory()) continue;
            mandatoryDefs.add(itemDef);
        }
        itemDefs = this.getAllPropertyDefinitions(mixinTypes);
        for (ItemDefinitionData itemDef : itemDefs) {
            if (!itemDef.isMandatory()) continue;
            mandatoryDefs.add(itemDef);
        }
        itemDefs = this.getAllChildNodeDefinitions(mixinTypes);
        for (ItemDefinitionData itemDef : itemDefs) {
            if (!itemDef.isMandatory()) continue;
            mandatoryDefs.add(itemDef);
        }
        return new ArrayList<ItemDefinitionData>(mandatoryDefs);
    }

    @Override
    public NodeTypeData getNodeType(InternalQName typeName) {
        return this.nodeTypeRepository.getNodeType(typeName);
    }

    @Override
    public PropertyDefinitionDatas getPropertyDefinitions(InternalQName propertyName, InternalQName ... nodeTypeNames) throws RepositoryException {
        PropertyDefinitionDatas propertyDefinitions = this.nodeTypeRepository.getPropertyDefinitions(propertyName, nodeTypeNames);
        if (propertyDefinitions == null) {
            for (int i = 0; i < nodeTypeNames.length && propertyDefinitions == null; ++i) {
                InternalQName[] supers = this.nodeTypeRepository.getNodeType(nodeTypeNames[i]).getDeclaredSupertypeNames();
                propertyDefinitions = this.getPropertyDefinitions(propertyName, supers);
            }
        }
        if (propertyDefinitions == null && !propertyName.equals((Object)Constants.JCR_ANY_NAME)) {
            propertyDefinitions = this.getPropertyDefinitions(Constants.JCR_ANY_NAME, nodeTypeNames);
        }
        return propertyDefinitions;
    }

    @Override
    public PropertyDefinitionDatas getPropertyDefinitions(InternalQName propertyName, InternalQName primaryNodeType, InternalQName[] mixinTypes) throws RepositoryException {
        if (mixinTypes != null) {
            InternalQName[] nts = new InternalQName[mixinTypes.length + 1];
            nts[0] = primaryNodeType;
            for (int i = 0; i < mixinTypes.length; ++i) {
                nts[i + 1] = mixinTypes[i];
            }
            return this.getPropertyDefinitions(propertyName, nts);
        }
        return this.getPropertyDefinitions(propertyName, primaryNodeType);
    }

    @Override
    public Set<InternalQName> getSubtypes(InternalQName nodeTypeName) {
        return this.nodeTypeRepository.getSubtypes(nodeTypeName);
    }

    @Override
    public Set<InternalQName> getSupertypes(InternalQName nodeTypeName) {
        return this.nodeTypeRepository.getSupertypes(nodeTypeName);
    }

    @Override
    public boolean isChildNodePrimaryTypeAllowed(InternalQName childNodeTypeName, InternalQName parentNodeType, InternalQName[] parentMixinNames) throws RepositoryException {
        NodeDefinitionData[] allChildNodeDefinitions;
        Set<InternalQName> testSuperTypesNames = this.nodeTypeRepository.getSupertypes(childNodeTypeName);
        for (NodeDefinitionData cnd : allChildNodeDefinitions = this.getAllChildNodeDefinitions(parentNodeType)) {
            for (InternalQName req : cnd.getRequiredPrimaryTypes()) {
                if (childNodeTypeName.equals((Object)req)) {
                    return true;
                }
                for (InternalQName superName : testSuperTypesNames) {
                    if (!superName.equals((Object)req)) continue;
                    return true;
                }
            }
        }
        for (NodeDefinitionData cnd : allChildNodeDefinitions = this.getAllChildNodeDefinitions(parentMixinNames)) {
            for (InternalQName req : cnd.getRequiredPrimaryTypes()) {
                if (childNodeTypeName.equals((Object)req)) {
                    return true;
                }
                for (InternalQName superName : testSuperTypesNames) {
                    if (!superName.equals((Object)req)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isNodeType(InternalQName testTypeName, InternalQName ... typesNames) {
        return this.nodeTypeRepository.isNodeType(testTypeName, typesNames);
    }

    @Override
    public boolean isNodeType(InternalQName testTypeName, InternalQName primaryType, InternalQName[] mixinTypes) {
        if (this.nodeTypeRepository.isNodeType(testTypeName, primaryType)) {
            return true;
        }
        return this.nodeTypeRepository.isNodeType(testTypeName, mixinTypes);
    }

    @Override
    public boolean isOrderableChildNodesSupported(InternalQName primaryType, InternalQName[] mixinTypes) throws RepositoryException {
        int nlen = mixinTypes != null ? mixinTypes.length : 0;
        for (int i = -1; i < nlen; ++i) {
            InternalQName name = i < 0 ? primaryType : mixinTypes[i];
            NodeTypeData nt = this.nodeTypeRepository.getNodeType(name);
            if (nt == null) continue;
            if (nt.hasOrderableChildNodes()) {
                return true;
            }
            Set<InternalQName> supers = this.nodeTypeRepository.getSupertypes(nt.getName());
            for (InternalQName suName : supers) {
                NodeTypeData su = this.nodeTypeRepository.getNodeType(suName);
                if (su == null || !su.hasOrderableChildNodes()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<NodeTypeData> registerNodeTypes(InputStream is, int alreadyExistsBehaviour, String contentType) throws RepositoryException {
        XmlNodeTypeDataPersister serializer = null;
        if (!contentType.equalsIgnoreCase("text/xml")) {
            if (contentType.equalsIgnoreCase("text/x-jcr-cnd")) {
                throw new RepositoryException("Unsupported content type:" + contentType);
            }
            throw new RepositoryException("Unsupported content type:" + contentType);
        }
        serializer = new XmlNodeTypeDataPersister(this.nodeTypeConverter, is);
        List<NodeTypeData> nodeTypes = serializer.getAllNodeTypes();
        this.nodeTypeDataValidator.validateNodeType(nodeTypes);
        this.nodeTypeRepository.registerNodeType(nodeTypes, this, this.accessControlPolicy, alreadyExistsBehaviour);
        return nodeTypes;
    }

    @Override
    public List<NodeTypeData> registerNodeTypes(List<NodeTypeValue> ntvalues, int alreadyExistsBehaviour) throws RepositoryException {
        List<NodeTypeData> nodeTypes = this.nodeTypeConverter.convertFromValueToData(ntvalues);
        this.nodeTypeDataValidator.validateNodeType(nodeTypes);
        this.nodeTypeRepository.registerNodeType(nodeTypes, this, this.accessControlPolicy, alreadyExistsBehaviour);
        return nodeTypes;
    }

    public void removeListener(NodeTypeManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public PlainChangesLog setPrimaryType(NodeData nodeData, InternalQName nodeTypeName) throws RepositoryException {
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        NodeTypeData ancestorDefinition = this.getNodeType(nodeData.getPrimaryTypeName());
        NodeTypeData recipientDefinition = this.getNodeType(nodeTypeName);
        InternalQName[] ancestorAllNodeTypeNames = null;
        if (nodeData.getMixinTypeNames() == null || nodeData.getMixinTypeNames().length == 0) {
            ancestorAllNodeTypeNames = new InternalQName[]{nodeData.getPrimaryTypeName()};
        } else {
            ancestorAllNodeTypeNames = new InternalQName[nodeData.getMixinTypeNames().length + 1];
            ancestorAllNodeTypeNames[0] = nodeData.getPrimaryTypeName();
            System.arraycopy(nodeData.getMixinTypeNames(), 0, ancestorAllNodeTypeNames, 1, nodeData.getMixinTypeNames().length);
        }
        InternalQName[] recipienAllNodeTypeNames = null;
        if (nodeData.getMixinTypeNames() == null || nodeData.getMixinTypeNames().length == 0) {
            recipienAllNodeTypeNames = new InternalQName[]{nodeTypeName};
        } else {
            recipienAllNodeTypeNames = new InternalQName[nodeData.getMixinTypeNames().length + 1];
            recipienAllNodeTypeNames[0] = nodeTypeName;
            System.arraycopy(nodeData.getMixinTypeNames(), 0, recipienAllNodeTypeNames, 1, nodeData.getMixinTypeNames().length);
        }
        boolean recipientsMixVersionable = this.isNodeType(Constants.MIX_VERSIONABLE, recipienAllNodeTypeNames);
        boolean ancestorIsMixVersionable = this.isNodeType(Constants.MIX_VERSIONABLE, ancestorAllNodeTypeNames);
        ItemAutocreator itemAutocreator = new ItemAutocreator(this, this.valueFactory, this.dataManager, false);
        if (recipientsMixVersionable && !ancestorIsMixVersionable) {
            changesLog.addAll(itemAutocreator.makeMixVesionableChanges(nodeData).getAllStates());
        } else if (!recipientsMixVersionable && ancestorIsMixVersionable) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fail to change  node type from ");
            buffer.append(ancestorDefinition.getName().getAsString());
            buffer.append(" to ");
            buffer.append(recipientDefinition.getName().getAsString());
            buffer.append(" because change from  mix:versionable = true ");
            buffer.append(" to mix:versionable = false is not alowed");
            throw new ConstraintViolationException(buffer.toString());
        }
        PropertyData item = (PropertyData)this.dataManager.getItemData(nodeData, new QPathEntry(Constants.JCR_PRIMARYTYPE, 1), ItemType.PROPERTY);
        TransientPropertyData primaryTypeData = new TransientPropertyData(item.getQPath(), item.getIdentifier(), item.getPersistedVersion(), item.getType(), item.getParentIdentifier(), item.isMultiValued(), new TransientValueData(nodeTypeName));
        changesLog.add(ItemState.createUpdatedState(primaryTypeData, true));
        ArrayList<NodeData> affectedNodes = new ArrayList<NodeData>();
        affectedNodes.add(nodeData);
        NodeDefinitionComparator nodeDefinitionComparator = new NodeDefinitionComparator(this, this.dataManager, itemAutocreator, affectedNodes);
        changesLog.addAll(nodeDefinitionComparator.compare(recipientDefinition, this.getAllChildNodeDefinitions(ancestorAllNodeTypeNames), this.getAllChildNodeDefinitions(recipienAllNodeTypeNames)).getAllStates());
        PropertyDefinitionComparator propertyDefinitionComparator = new PropertyDefinitionComparator(this, this.dataManager, itemAutocreator, affectedNodes, this.locationFactory);
        changesLog.addAll(propertyDefinitionComparator.compare(recipientDefinition, this.getAllPropertyDefinitions(ancestorAllNodeTypeNames), this.getAllPropertyDefinitions(recipienAllNodeTypeNames)).getAllStates());
        return changesLog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (this.started) return;
        try {
            if (!this.nodeTypeRepository.isStorageFilled()) {
                InputStream xml = (InputStream)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return NodeTypeManagerImpl.class.getResourceAsStream(NodeTypeDataManagerImpl.NODETYPES_FILE);
                    }
                });
                if (xml == null) throw new RuntimeException("Resource file 'nodetypes.xml' with NodeTypes configuration does not found. Can not create node type manager");
                List<NodeTypeData> registerNodeTypes = this.registerNodeTypes(xml, 0, "text/xml");
                for (NodeTypeData nodeTypeData : registerNodeTypes) {
                    this.buildInNodeTypesNames.add(nodeTypeData.getName());
                }
            } else {
                List<NodeTypeData> allNodeTypes = this.nodeTypeRepository.getAllNodeTypes();
                HashMap<InternalQName, NodeTypeData> volatileNodeTypes = new HashMap<InternalQName, NodeTypeData>();
                for (NodeTypeData nodeTypeData : allNodeTypes) {
                    volatileNodeTypes.put(nodeTypeData.getName(), nodeTypeData);
                }
                for (NodeTypeData nodeTypeData : allNodeTypes) {
                    this.nodeTypeRepository.addNodeType(nodeTypeData, volatileNodeTypes);
                }
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        this.started = true;
    }

    public void stop() {
    }

    @Override
    public void unregisterNodeType(InternalQName nodeTypeName) throws RepositoryException {
        NodeTypeData nodeType = this.nodeTypeRepository.getNodeType(nodeTypeName);
        if (nodeType == null) {
            throw new NoSuchNodeTypeException(nodeTypeName.getAsString());
        }
        if (this.buildInNodeTypesNames.contains((Object)nodeTypeName)) {
            throw new RepositoryException(nodeTypeName.toString() + ": can't unregister built-in node type.");
        }
        Set<InternalQName> descendantNt = this.nodeTypeRepository.getSubtypes(nodeTypeName);
        if (descendantNt.size() > 0) {
            String message = "Can not remove " + nodeTypeName.getAsString() + "nodetype, because the following node types depend on it: ";
            for (InternalQName internalQName : descendantNt) {
                message = message + internalQName.getAsString() + " ";
            }
            throw new RepositoryException(message);
        }
        Set<String> nodes = this.indexSearcherHolder.getNodesByNodeType(nodeTypeName);
        if (nodes.size() > 0) {
            String message = "Can not remove " + nodeTypeName.getAsString() + " nodetype, because the following node types is used in nodes with uuid: ";
            for (String uuids : nodes) {
                message = message + uuids + " ";
            }
            throw new RepositoryException(message);
        }
        this.nodeTypeRepository.removeNodeType(nodeType);
    }

    @Override
    public PlainChangesLog updateNodeType(NodeTypeData ancestorDefinition, NodeTypeData recipientDefinition, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws ConstraintViolationException, RepositoryException {
        if (!ancestorDefinition.getName().equals((Object)recipientDefinition.getName())) {
            throw new RepositoryException("Unsupported Operation");
        }
        if (this.buildInNodeTypesNames.contains((Object)recipientDefinition.getName())) {
            throw new RepositoryException((Object)((Object)recipientDefinition.getName()) + ": can't reregister built-in node type.");
        }
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        VolatileNodeTypeDataManager volatileNodeTypeDataManager = new VolatileNodeTypeDataManager(this);
        volatileNodeTypeDataManager.registerVolatileNodeTypes(volatileNodeTypes);
        ItemAutocreator itemAutocreator = new ItemAutocreator(volatileNodeTypeDataManager, this.valueFactory, this.dataManager, false);
        Set<String> nodes = this.indexSearcherHolder.getNodesByNodeType(recipientDefinition.getName());
        if (this.isNodeType(Constants.MIX_VERSIONABLE, recipientDefinition.getDeclaredSupertypeNames()) && !this.isNodeType(Constants.MIX_VERSIONABLE, ancestorDefinition.getDeclaredSupertypeNames())) {
            for (String uuid : nodes) {
                ItemData item = this.dataManager.getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                changesLog.addAll(itemAutocreator.makeMixVesionableChanges((NodeData)item).getAllStates());
            }
        } else if (!this.isNodeType(Constants.MIX_VERSIONABLE, recipientDefinition.getDeclaredSupertypeNames()) && this.isNodeType(Constants.MIX_VERSIONABLE, ancestorDefinition.getDeclaredSupertypeNames()) && nodes.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fail to change ");
            buffer.append(recipientDefinition.getName().getAsString());
            buffer.append(" node type from mix:versionable = true  to mix:versionable = false");
            buffer.append(" because the folowing node exists: ");
            if (nodes.size() < 100) {
                for (String uuid : nodes) {
                    ItemData item = this.dataManager.getItemData(uuid);
                    if (item == null || !item.isNode()) continue;
                    buffer.append(item.getQPath().getAsString());
                    buffer.append(" ");
                }
            }
            throw new ConstraintViolationException(buffer.toString());
        }
        ArrayList<NodeData> affectedNodes = new ArrayList<NodeData>();
        for (String uuid : nodes) {
            ItemData nodeData = this.dataManager.getItemData(uuid);
            if (nodeData == null || !nodeData.isNode()) continue;
            affectedNodes.add((NodeData)nodeData);
        }
        NodeDefinitionComparator nodeDefinitionComparator = new NodeDefinitionComparator(volatileNodeTypeDataManager, this.dataManager, itemAutocreator, affectedNodes);
        changesLog.addAll(nodeDefinitionComparator.compare(recipientDefinition, this.getAllChildNodeDefinitions(ancestorDefinition.getName()), volatileNodeTypeDataManager.getAllChildNodeDefinitions(recipientDefinition.getName())).getAllStates());
        PropertyDefinitionComparator propertyDefinitionComparator = new PropertyDefinitionComparator(volatileNodeTypeDataManager, this.dataManager, itemAutocreator, affectedNodes, this.locationFactory);
        changesLog.addAll(propertyDefinitionComparator.compare(recipientDefinition, this.getAllPropertyDefinitions(ancestorDefinition.getName()), volatileNodeTypeDataManager.getAllPropertyDefinitions(recipientDefinition.getName())).getAllStates());
        if (!Arrays.deepEquals((Object[])recipientDefinition.getDeclaredSupertypeNames(), (Object[])ancestorDefinition.getDeclaredSupertypeNames())) {
            for (String uuid : nodes) {
                ItemData item = this.dataManager.getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                if (!(item instanceof TransientNodeData)) {
                    item = new TransientNodeData(item.getQPath(), item.getIdentifier(), item.getPersistedVersion(), ((NodeData)item).getPrimaryTypeName(), ((NodeData)item).getMixinTypeNames(), ((NodeData)item).getOrderNumber(), ((NodeData)item).getParentIdentifier(), ((NodeData)item).getACL());
                }
                changesLog.add(new ItemState(item, 16, false, null));
            }
        }
        if (ancestorDefinition.isMixin() != recipientDefinition.isMixin() && nodes.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fail to change ");
            buffer.append(recipientDefinition.getName().getAsString());
            buffer.append(" node type from IsMixin=");
            buffer.append(ancestorDefinition.isMixin());
            buffer.append(" to IsMixin=");
            buffer.append(recipientDefinition.isMixin());
            buffer.append(" because the folowing node exists: ");
            if (nodes.size() < 100) {
                for (String uuid : nodes) {
                    ItemData item = this.dataManager.getItemData(uuid);
                    if (item == null || !item.isNode()) continue;
                    buffer.append(item.getQPath().getAsString());
                    buffer.append(" ");
                }
            }
            throw new ConstraintViolationException(buffer.toString());
        }
        this.nodeTypeRepository.removeNodeType(ancestorDefinition);
        this.nodeTypeRepository.addNodeType(recipientDefinition, volatileNodeTypes);
        return changesLog;
    }

    private InternalQName[] getNodeTypeNames(InternalQName primaryNodeType, InternalQName[] mixinTypes) throws RepositoryException {
        InternalQName[] ntn = new InternalQName[1 + (mixinTypes == null ? 0 : mixinTypes.length)];
        ntn[0] = primaryNodeType;
        if (mixinTypes != null) {
            System.arraycopy(mixinTypes, 0, ntn, 1, mixinTypes.length);
        }
        return ntn;
    }
}

