/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class FileValueStorage
extends ValueStoragePlugin {
    private Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.FileValueStorage");
    public static final String PATH = "path";
    public static final String TEMP_DIR_NAME = "temp";
    protected File rootDir;
    protected FileCleaner cleaner;
    protected ValueDataResourceHolder resources;

    public FileValueStorage(FileCleaner cleaner) {
        this.cleaner = cleaner;
    }

    public void init(Properties props, ValueDataResourceHolder resources) throws IOException, RepositoryConfigurationException {
        this.resources = resources;
        this.prepareRootDir(props.getProperty(PATH));
    }

    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
    }

    public boolean isSame(String storageId) {
        return this.getId().equals(storageId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prepareRootDir(String rootDirPath) throws IOException, RepositoryConfigurationException {
        this.rootDir = new File(rootDirPath);
        if (!PrivilegedFileHelper.exists((File)this.rootDir)) {
            if (PrivilegedFileHelper.mkdirs((File)this.rootDir)) {
                this.log.info((Object)("Directory created: " + PrivilegedFileHelper.getAbsolutePath((File)this.rootDir)));
                File tempDir = new File(this.rootDir, TEMP_DIR_NAME);
                PrivilegedFileHelper.mkdirs((File)tempDir);
                if (!PrivilegedFileHelper.exists((File)tempDir) || !PrivilegedFileHelper.isDirectory((File)tempDir)) throw new RepositoryConfigurationException("Cannot create temp directory under External Value Storage.");
                for (File tmpf : PrivilegedFileHelper.listFiles((File)tempDir)) {
                    if (PrivilegedFileHelper.delete((File)tmpf)) continue;
                    this.log.warn((Object)("Storage temporary directory contains un-deletable file " + PrivilegedFileHelper.getAbsolutePath((File)tmpf) + ". It's recommended to leave this directory for JCR External Values Storage private use."));
                }
                return;
            } else {
                this.log.warn((Object)("Directory IS NOT created: " + PrivilegedFileHelper.getAbsolutePath((File)this.rootDir)));
            }
            return;
        } else {
            if (PrivilegedFileHelper.isDirectory((File)this.rootDir)) return;
            throw new RepositoryConfigurationException("File exists but is not a directory " + rootDirPath);
        }
    }
}

