/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.PortalStateManager;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationRequestPhaseLifecycle;
import org.exoplatform.web.application.Phase;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationLifecycle
implements ApplicationRequestPhaseLifecycle<WebuiRequestContext> {
    private static final String LOCALE_COOKIE = "LOCALE";
    private static final String LOCALE_SESSION_ATTR = "org.gatein.LOCALE";
    private static final String PREV_LOCALE_SESSION_ATTR = "org.gatein.LAST_LOCALE";
    private static final ThreadLocal<Locale> calculatedLocale = new ThreadLocal();
    private static Log log = ExoLogger.getLogger((String)"portal:LocalizationLifecycle");

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        UserPortalConfig userPortalConfig;
        HashSet<Locale> supportedLocales;
        LocaleContextInfo localeCtx;
        LocalePolicy localePolicy;
        PortalRequestContext reqCtx;
        block9: {
            if (!(context instanceof PortalRequestContext)) {
                throw new IllegalArgumentException("Expected PortalRequestContext, but got: " + context);
            }
            reqCtx = (PortalRequestContext)context;
            ExoContainer container = app.getApplicationServiceContainer();
            LocaleConfigService localeConfigService = (LocaleConfigService)container.getComponentInstanceOfType(LocaleConfigService.class);
            localePolicy = (LocalePolicy)container.getComponentInstanceOfType(LocalePolicy.class);
            localeCtx = new LocaleContextInfo();
            supportedLocales = new HashSet<Locale>();
            for (LocaleConfig lc : localeConfigService.getLocalConfigs()) {
                supportedLocales.add(lc.getLocale());
            }
            localeCtx.setSupportedLocales(supportedLocales);
            HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(context.getRequest());
            localeCtx.setBrowserLocales(Collections.list(request.getLocales()));
            localeCtx.setCookieLocales(LocalizationLifecycle.getCookieLocales(request));
            localeCtx.setSessionLocale(LocalizationLifecycle.getSessionLocale(request));
            localeCtx.setUserProfileLocale(this.getUserProfileLocale(reqCtx));
            localeCtx.setRemoteUser(reqCtx.getRemoteUser());
            userPortalConfig = null;
            try {
                userPortalConfig = PortalStateManager.getUserPortalConfig(reqCtx);
                if (userPortalConfig == null) {
                    log.warn((Object)"No UserPortalConfig available! Portal locale set to 'en'");
                }
            }
            catch (Exception ignored) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)"IGNORED: Failed to load UserPortalConfig: ", (Throwable)ignored);
            }
        }
        String portalLocaleName = "en";
        if (userPortalConfig != null) {
            portalLocaleName = userPortalConfig.getPortalConfig().getLocale();
        }
        Locale portalLocale = LocaleContextInfo.getLocale((String)portalLocaleName);
        localeCtx.setPortalLocale(portalLocale);
        Locale locale = localePolicy.determineLocale(localeCtx);
        boolean supported = supportedLocales.contains(locale);
        if (!supported && !"".equals(locale.getCountry())) {
            locale = new Locale(locale.getLanguage());
            supported = supportedLocales.contains(locale);
        }
        if (!supported) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported locale returned by LocalePolicy: " + localePolicy + ". Falling back to 'en'."));
            }
            locale = Locale.ENGLISH;
        }
        reqCtx.setLocale(locale);
        calculatedLocale.set(locale);
    }

    public void onStartRequestPhase(Application app, WebuiRequestContext context, Phase phase) {
    }

    public void onEndRequestPhase(Application app, WebuiRequestContext context, Phase phase) {
        if (phase == Phase.ACTION) {
            PortalRequestContext reqCtx = (PortalRequestContext)context;
            Locale loc = reqCtx.getLocale();
            Locale remembered = calculatedLocale.get();
            calculatedLocale.remove();
            boolean refreshNeeded = false;
            Locale sessLocale = LocalizationLifecycle.getPreviousLocale(reqCtx.getRequest());
            if (loc != null && sessLocale != null && !loc.equals(sessLocale)) {
                refreshNeeded = true;
            }
            if (!(loc == null || remembered != null && loc.equals(remembered))) {
                refreshNeeded = true;
                this.saveLocale(reqCtx, loc);
            }
            if (refreshNeeded) {
                this.resetOrientation(reqCtx, loc);
            }
            this.savePreviousLocale(reqCtx, loc);
        }
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }

    private Locale getUserProfileLocale(PortalRequestContext context) {
        String lang = null;
        UserProfile userProfile = this.getLoadedProfile(context);
        lang = userProfile == null ? null : (String)userProfile.getUserInfoMap().get("user.language");
        return lang != null ? LocaleContextInfo.getLocale((String)lang) : null;
    }

    private UserProfile loadUserProfile(ExoContainer container, PortalRequestContext context) {
        UserProfile userProfile = null;
        OrganizationService svc = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        String user = context.getRemoteUser();
        if (user != null) {
            try {
                userProfile = svc.getUserProfileHandler().findUserProfileByName(user);
            }
            catch (Exception ignored) {
                log.error((Object)("IGNORED: Failed to load UserProfile for username: " + user), (Throwable)ignored);
            }
            if (userProfile == null && log.isWarnEnabled()) {
                log.warn((Object)("Could not load user profile for " + user + ". Using default portal locale."));
            }
        }
        return userProfile;
    }

    private UserProfile getLoadedProfile(PortalRequestContext context) {
        return (UserProfile)context.getAttribute("PortalUserProfile");
    }

    public static List<Locale> getCookieLocales(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!LOCALE_COOKIE.equals(cookie.getName())) continue;
                ArrayList<Locale> locales = new ArrayList<Locale>();
                locales.add(LocaleContextInfo.getLocale((String)cookie.getValue()));
                return locales;
            }
        }
        return Collections.emptyList();
    }

    public static Locale getSessionLocale(HttpServletRequest request) {
        return LocalizationLifecycle.getLocaleFromSession(request, LOCALE_SESSION_ATTR);
    }

    public static Locale getPreviousLocale(HttpServletRequest request) {
        return LocalizationLifecycle.getLocaleFromSession(request, PREV_LOCALE_SESSION_ATTR);
    }

    private static Locale getLocaleFromSession(HttpServletRequest request, String attrName) {
        String lang = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            lang = (String)session.getAttribute(attrName);
        }
        return lang != null ? LocaleContextInfo.getLocale(lang) : null;
    }

    private void saveLocale(PortalRequestContext context, Locale loc) {
        String user = context.getRemoteUser();
        if (user != null) {
            this.saveLocaleToUserProfile(context, loc, user);
        } else {
            this.saveLocaleToCookie(context, loc);
        }
        this.saveSessionLocale(context, loc);
    }

    private void resetOrientation(PortalRequestContext context, Locale loc) {
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        LocaleConfigService localeConfigService = (LocaleConfigService)container.getComponentInstanceOfType(LocaleConfigService.class);
        LocaleConfig localeConfig = localeConfigService.getLocaleConfig(LocaleContextInfo.getLocaleAsString((Locale)loc));
        if (localeConfig == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Locale changed to unsupported Locale during request processing: " + loc));
            }
            return;
        }
        ((UIPortalApplication)context.getUIApplication()).setOrientation(localeConfig.getOrientation());
    }

    private void saveSessionLocale(PortalRequestContext context, Locale loc) {
        this.saveLocaleToSession(context, LOCALE_SESSION_ATTR, loc);
    }

    private void savePreviousLocale(PortalRequestContext context, Locale loc) {
        this.saveLocaleToSession(context, PREV_LOCALE_SESSION_ATTR, loc);
    }

    private void saveLocaleToSession(PortalRequestContext context, String attrName, Locale loc) {
        HttpServletRequest res = context.getRequest();
        HttpSession session = res.getSession(false);
        if (session != null) {
            session.setAttribute(attrName, (Object)LocaleContextInfo.getLocaleAsString((Locale)loc));
        }
    }

    private void saveLocaleToCookie(PortalRequestContext context, Locale loc) {
        HttpServletResponse res = context.getResponse();
        Cookie cookie = new Cookie(LOCALE_COOKIE, LocaleContextInfo.getLocaleAsString((Locale)loc));
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        res.addCookie(cookie);
    }

    private void saveLocaleToUserProfile(PortalRequestContext context, Locale loc, String user) {
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        OrganizationService svc = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        UserProfile userProfile = this.loadUserProfile(container, context);
        if (userProfile != null) {
            userProfile.getUserInfoMap().put("user.language", LocaleContextInfo.getLocaleAsString((Locale)loc));
            try {
                svc.getUserProfileHandler().saveUserProfile(userProfile, false);
            }
            catch (Exception ignored) {
                log.error((Object)("IGNORED: Failed to save profile for user: " + user), (Throwable)ignored);
                userProfile = null;
            }
        }
        if (userProfile == null && log.isWarnEnabled()) {
            log.warn((Object)("Unable to save locale into profile for user: " + user));
        }
    }
}

