/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.net.URLEncoder;
import org.exoplatform.web.application.Parameter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URLBuilder<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(URLBuilder.class);
    protected String baseURL_;

    public URLBuilder(String baseURL) {
        this.baseURL_ = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL_;
    }

    public void setBaseURL(String url) {
        this.baseURL_ = url;
    }

    public String createURL(String action) {
        return this.createURL(action, (Parameter[])null);
    }

    public abstract String createURL(String var1, Parameter[] var2);

    public String createURL(String action, String objectId) {
        return this.createURL(action, objectId, (Parameter[])null);
    }

    public abstract String createURL(String var1, String var2, Parameter[] var3);

    public String createURL(T targetComponent, String action, String targetBeanId) {
        return this.createURL(targetComponent, action, null, targetBeanId, (Parameter[])null);
    }

    public String createAjaxURL(T targetComponent, String action, String targetBeanId) {
        return this.createAjaxURL(targetComponent, action, null, targetBeanId, null);
    }

    public String createAjaxURL(T targetComponent, String action, String confirm, String targetBeanId) {
        return this.createAjaxURL(targetComponent, action, confirm, targetBeanId, null);
    }

    public String createAjaxURL(T targetComponent, String action, String confirm, String targetBeanId, Parameter[] params) {
        StringBuilder builder = new StringBuilder("javascript:");
        if (confirm != null && confirm.length() > 0) {
            builder.append("if(confirm('").append(confirm.replaceAll("'", "\\\\'")).append("'))");
        }
        builder.append("ajaxGet('");
        if (targetBeanId != null) {
            try {
                targetBeanId = URLEncoder.encode(targetBeanId, "utf-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)"Fail to encode AjaxURL", (Throwable)e);
            }
        }
        this.createURL(builder, targetComponent, action, targetBeanId, params);
        builder.append("&amp;ajaxRequest=true')");
        return builder.toString();
    }

    public String createURL(T targetComponent, String action, String confirm, String targetBeanId, Parameter[] params) {
        boolean hasConfirm;
        StringBuilder builder = new StringBuilder();
        boolean bl = hasConfirm = confirm != null && confirm.length() > 0;
        if (hasConfirm) {
            builder.append("javascript:if(confirm('").append(confirm.replaceAll("'", "\\\\'")).append("'))");
            builder.append("window.location='");
        }
        if (targetBeanId != null) {
            try {
                targetBeanId = URLEncoder.encode(targetBeanId, "utf-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)"Fail to encode URL", (Throwable)e);
            }
        }
        this.createURL(builder, targetComponent, action, targetBeanId, params);
        if (hasConfirm) {
            builder.append("';");
        }
        return builder.toString();
    }

    protected abstract void createURL(StringBuilder var1, T var2, String var3, String var4, Parameter[] var5);
}

