/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueType<T> {
    public static final ValueType<String> STRING = new ValueType<String>(){};
    public static final ValueType<Integer> INTEGER = new ValueType<Integer>(){};
    public static final ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(){};
    public static final ValueType<Date> DATE = new ValueType<Date>(){};
    public static final ValueType<Double> DOUBLE = new ValueType<Double>(){};
    private final Class<T> javaType;

    private ValueType() {
        Type type = this.getClass().getGenericSuperclass();
        ParameterizedType parameterizedType = (ParameterizedType)type;
        this.javaType = (Class)parameterizedType.getActualTypeArguments()[0];
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public boolean isInstance(Object o) {
        return this.javaType.isInstance(o);
    }

    public T cast(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (this.javaType.isInstance(o)) {
            return this.javaType.cast(o);
        }
        throw new ClassCastException("Object " + o + " cannot be casted to " + this.javaType.getName());
    }

    public static <T> ValueType<T> decode(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof String) {
            return STRING;
        }
        if (t instanceof Integer) {
            return INTEGER;
        }
        if (t instanceof Boolean) {
            return BOOLEAN;
        }
        if (t instanceof Date) {
            return DATE;
        }
        if (t instanceof Double) {
            return DOUBLE;
        }
        return null;
    }

    public static <T> ValueType<T> get(T t) throws NullPointerException, IllegalArgumentException {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t instanceof String) {
            return STRING;
        }
        if (t instanceof Integer) {
            return INTEGER;
        }
        if (t instanceof Boolean) {
            return BOOLEAN;
        }
        if (t instanceof Date) {
            return DATE;
        }
        if (t instanceof Double) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Java class " + t.getClass().getName() + " cannot be used as a value type");
    }

    public static <T> ValueType<T> forClass(Class<T> t) throws NullPointerException, IllegalArgumentException {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t == String.class) {
            return STRING;
        }
        if (t == Integer.class) {
            return INTEGER;
        }
        if (t == Boolean.class) {
            return BOOLEAN;
        }
        if (t == Date.class) {
            return DATE;
        }
        if (t == Double.class) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Java class " + t.getClass().getName() + " cannot be used as a value type");
    }

    public String toString() {
        return "ValueType[" + this.javaType.getSimpleName() + "]";
    }
}

