/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfile;
import org.exoplatform.social.webui.space.UISpaceInfo;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/webui/UIAvatarUploadContent.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AbortActionListener.class})})
public class UIAvatarUploadContent
extends UIContainer {
    private AvatarAttachment avatarAttachment;
    private String imageSource;

    public UIAvatarUploadContent() {
    }

    public UIAvatarUploadContent(AvatarAttachment avatarAttachment) throws Exception {
        this.avatarAttachment = avatarAttachment;
        this.setImageSource(avatarAttachment.getImageBytes());
    }

    public AvatarAttachment getAvatarAttachment() {
        return this.avatarAttachment;
    }

    public void setAvatarAttachment(AvatarAttachment avatarAttachment) throws Exception {
        this.avatarAttachment = avatarAttachment;
        this.setImageSource(avatarAttachment.getImageBytes());
    }

    public String getImageSource() {
        return this.imageSource;
    }

    private void setImageSource(byte[] imageBytes) throws Exception {
        if (imageBytes == null || imageBytes.length == 0) {
            return;
        }
        ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
        DownloadService downloadService = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource downloadResource = new InputStreamDownloadResource((InputStream)byteImage, "image");
        downloadResource.setDownloadName(this.avatarAttachment.getFileName());
        this.imageSource = downloadService.getDownloadLink(downloadService.addDownloadResource((DownloadResource)downloadResource));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbortActionListener
    extends EventListener<UIAvatarUploadContent> {
        public void execute(Event<UIAvatarUploadContent> event) throws Exception {
            UIAvatarUploadContent uiAvatarUploadContent = (UIAvatarUploadContent)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploadContent.getParent();
            uiPopup.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIAvatarUploadContent> {
        public void execute(Event<UIAvatarUploadContent> event) throws Exception {
            UIAvatarUploadContent uiAvatarUploadContent = (UIAvatarUploadContent)((Object)event.getSource());
            this.saveAvatar(uiAvatarUploadContent);
            UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploadContent.getParent();
            uiPopup.setShow(false);
            Utils.updateWorkingWorkSpace();
        }

        private void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent) throws Exception {
            for (UIComponent parent = uiAvatarUploadContent.getParent(); parent != null; parent = parent.getParent()) {
                if (UIProfile.class.isInstance(parent)) {
                    ((UIProfile)parent).saveAvatar(uiAvatarUploadContent);
                    return;
                }
                if (!UISpaceInfo.class.isInstance(parent)) continue;
                UISpaceInfo uiSpaceInfo = (UISpaceInfo)parent;
                SpaceService spaceService = uiSpaceInfo.getSpaceService();
                String id = (String)uiSpaceInfo.getUIStringInput("id").getValue();
                Space space = spaceService.getSpaceById(id);
                uiSpaceInfo.saveAvatar(uiAvatarUploadContent, space);
                return;
            }
        }
    }
}

