/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import java.io.File;
import java.io.InputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Catalog;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.ftp.FtpServer;
import org.exoplatform.services.ftp.client.FtpClientSession;
import org.exoplatform.services.ftp.client.FtpClientSessionImpl;
import org.exoplatform.services.ftp.command.FtpCommand;
import org.exoplatform.services.ftp.config.FtpConfig;
import org.exoplatform.services.ftp.data.FtpDataChannelManager;
import org.exoplatform.services.ftp.data.FtpDataChannelManagerImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpServerImpl
implements FtpServer {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ftp.FtpServerImpl");
    public static final String COMMAND_PATH = "/conf/ftp-commands.xml";
    private Catalog commandCatalog;
    private RepositoryService repositoryService;
    private FtpConfig configuration;
    private FtpAcceptThread acceptThread;
    private FtpDataChannelManager dataChannelManager;
    private ArrayList<FtpClientSession> clients = new ArrayList();

    public FtpServerImpl(FtpConfig configuration, CommandService commandService, RepositoryService repositoryService) throws Exception {
        this.configuration = configuration;
        this.repositoryService = repositoryService;
        InputStream commandStream = SecurityHelper.doPrivilegedAction(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return this.getClass().getResourceAsStream(FtpServerImpl.COMMAND_PATH);
            }
        });
        commandService.putCatalog(commandStream);
        this.commandCatalog = commandService.getCatalog("FTP");
    }

    protected void prepareCache() {
        String[] cacheFiles;
        String cacheFolderName = this.configuration.getCacheFolderName();
        File cacheFolder = new File(cacheFolderName);
        if (!PrivilegedFileHelper.exists(cacheFolder)) {
            log.info("Cache folder not exist. Try to create it...");
            PrivilegedFileHelper.mkdirs(cacheFolder);
        }
        if ((cacheFiles = PrivilegedFileHelper.list(cacheFolder)) == null) {
            log.info("No cache file in cache folder!");
            return;
        }
        for (String cacheFile : cacheFiles) {
            if (!cacheFile.endsWith(".ftpcache")) continue;
            File file = new File(cacheFolderName + "/" + cacheFile);
            PrivilegedFileHelper.delete(file);
        }
    }

    public boolean start() {
        try {
            this.prepareCache();
            ServerSocket serverSocket = null;
            int port = this.configuration.getCommandPort();
            while (serverSocket == null) {
                try {
                    serverSocket = new ServerSocket(port);
                    log.info("FTPServer started on port '" + port + "'");
                }
                catch (BindException e) {
                    log.warn("Cannot launch the FTPServer on '" + port++ + "', we try the next port number");
                }
            }
            this.dataChannelManager = new FtpDataChannelManagerImpl(this.configuration);
            this.acceptThread = new FtpAcceptThread(this, serverSocket);
            this.acceptThread.start();
            return true;
        }
        catch (Exception exc) {
            log.info("Unhandled exception. " + exc.getMessage(), exc);
            return false;
        }
    }

    public boolean stop() {
        return false;
    }

    public FtpConfig getConfiguration() {
        return this.configuration;
    }

    public ManageableRepository getRepository() {
        try {
            return this.repositoryService.getDefaultRepository();
        }
        catch (RepositoryException e) {
            log.info("Repository exception. " + e.getMessage(), e);
        }
        catch (RepositoryConfigurationException e) {
            log.info("Repository configuration exception. " + e.getMessage(), e);
        }
        return null;
    }

    public FtpCommand getCommand(String commandName) {
        return (FtpCommand)this.commandCatalog.getCommand(commandName);
    }

    public FtpDataChannelManager getDataChannelManager() {
        return this.dataChannelManager;
    }

    public boolean unRegisterClient(FtpClientSession clientSession) {
        boolean result = this.clients.remove(clientSession);
        log.info(">>> Client disconnected. Clients: " + this.clients.size());
        return result;
    }

    public int getClientsCount() {
        return this.clients.size();
    }

    protected class FtpAcceptThread
    extends Thread {
        protected FtpServer ftpServer;
        protected ServerSocket serverSocket;
        protected boolean enable = true;

        public FtpAcceptThread(FtpServer ftpServer, ServerSocket serverSocket) {
            this.ftpServer = ftpServer;
            this.serverSocket = serverSocket;
            this.setName("Ftp Server" + (FtpServerImpl.this.configuration.getPortalContainer() == null ? "" : " " + FtpServerImpl.this.configuration.getPortalContainer().getName()));
            this.setDaemon(true);
        }

        public void disable() {
            this.enable = false;
        }

        public void run() {
            while (this.enable) {
                Socket incoming = null;
                try {
                    incoming = SecurityHelper.doPrivilegedExceptionAction(new PrivilegedExceptionAction<Socket>(){

                        @Override
                        public Socket run() throws Exception {
                            return FtpAcceptThread.this.serverSocket.accept();
                        }
                    });
                    FtpClientSessionImpl clientSession = new FtpClientSessionImpl(this.ftpServer, incoming);
                    FtpServerImpl.this.clients.add(clientSession);
                    log.info(">>> New client connected. Clients: " + FtpServerImpl.this.clients.size());
                }
                catch (Exception exc) {
                    log.info("Unhandled exception. " + exc.getMessage(), exc);
                }
            }
        }
    }
}

