/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import java.util.concurrent.ScheduledFuture;
import org.exoplatform.services.jcr.impl.core.lock.WorkspaceLockManager;
import org.exoplatform.services.jcr.impl.proccess.WorkerService;

public class LockRemover {
    public static final long DEFAULT_THREAD_TIMEOUT = 30000L;
    private final WorkerService workerService;
    private final WorkspaceLockManager lockManager;
    private final long timeout;
    private ScheduledFuture<?> lockRemoverTask = null;

    protected LockRemover(WorkerService workerService, WorkspaceLockManager lockManager) {
        this(workerService, lockManager, 30000L);
    }

    protected LockRemover(WorkerService workerService, WorkspaceLockManager lockManager, long timeout) {
        this.workerService = workerService;
        this.lockManager = lockManager;
        this.timeout = timeout;
    }

    public void start() {
        if (this.lockRemoverTask == null) {
            this.lockRemoverTask = this.workerService.executePeriodically(new LockRemoverTask(this.lockManager), this.timeout);
        }
    }

    public void stop() {
        this.lockRemoverTask.cancel(false);
        this.lockRemoverTask = null;
    }

    class LockRemoverTask
    implements Runnable {
        private final WorkspaceLockManager lockManager;

        LockRemoverTask(WorkspaceLockManager lockManager) {
            this.lockManager = lockManager;
        }

        public void run() {
            this.lockManager.removeExpired();
        }
    }
}

