/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Payload;
import org.exoplatform.services.jcr.impl.core.query.lucene.PropertyMetaData;

public final class SingletonTokenStream
extends TokenStream
implements Externalizable {
    private String value;
    private Payload payload;
    private boolean hasNext = true;

    public SingletonTokenStream() {
    }

    public SingletonTokenStream(String value, int type) {
        this.value = value;
        this.payload = new Payload(new PropertyMetaData(type).toByteArray());
    }

    public SingletonTokenStream(Token t) {
        this.value = t.term();
        this.payload = t.getPayload();
    }

    public Token next(Token reusableToken) throws IOException {
        if (this.hasNext) {
            reusableToken.clear();
            reusableToken.setTermBuffer(this.value);
            reusableToken.setPayload(this.payload);
            reusableToken.setStartOffset(0);
            reusableToken.setEndOffset(this.value.length());
            this.hasNext = false;
            return reusableToken;
        }
        return null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.payload = (Payload)in.readObject();
        int length = in.readInt();
        byte[] binValue = new byte[length];
        in.read(binValue);
        this.value = new String(binValue, "UTF-8");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.payload);
        byte[] binValue = this.value.getBytes("UTF-8");
        out.writeInt(binValue.length);
        out.write(binValue);
    }
}

