/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/UIApplicationListSelector.gtmpl", events={@EventConfig(listeners={InstallApplicationActionListener.class})})
public class UIApplicationListSelector
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIApplicationListSelector.class);
    private List<Application> applicationList;
    private Application selectedApplication;

    public void setApplicationList(List<Application> newApplicationList) {
        this.applicationList = newApplicationList;
    }

    public List<Application> getApplicationList() {
        return this.applicationList;
    }

    public void setSelectedApplication(Application newSelectedApplication) {
        this.selectedApplication = newSelectedApplication;
    }

    public Application getSelectedApplication() {
        if (this.selectedApplication == null) {
            this.selectedApplication = this.applicationList.get(0);
        }
        return this.selectedApplication;
    }

    private void setSelectedApplication(String applicationName) {
        if (this.getSelectedApplication().getApplicationName().equals(applicationName)) {
            return;
        }
        for (Application application : this.applicationList) {
            if (!application.getApplicationName().equals(applicationName)) continue;
            this.setSelectedApplication(application);
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstallApplicationActionListener
    extends EventListener<UIApplicationListSelector> {
        public void execute(Event<UIApplicationListSelector> event) throws Exception {
            String applicationName = event.getRequestContext().getRequestParameter("objectId");
            UIApplicationListSelector uiApplicationListSelector = (UIApplicationListSelector)((Object)event.getSource());
            uiApplicationListSelector.setSelectedApplication(applicationName);
            if (uiApplicationListSelector.getParent() != null) {
                Event installApplicationEvent = uiApplicationListSelector.getParent().createEvent("InstallApplication", Event.Phase.DECODE, event.getRequestContext());
                if (installApplicationEvent == null) {
                    LOG.warn((Object)"Failed to broadcast InstallApplicationActionListener.");
                    return;
                }
                installApplicationEvent.broadcast();
            }
        }
    }
}

