/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesLoader;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;

@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceActivitiesDisplay.gtmpl")
public class UISpaceActivitiesDisplay
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UISpaceActivitiesDisplay.class);
    private Space space;
    private static final int ACTIVITY_PER_PAGE = 20;
    private UIActivitiesLoader activitiesLoader;

    public void setSpace(Space space) throws Exception {
        this.space = space;
        this.init();
    }

    public Space getSpace() {
        return this.space;
    }

    public UIActivitiesLoader getActivitiesLoader() {
        return this.activitiesLoader;
    }

    private void init() throws Exception {
        if (this.space == null) {
            LOG.warn((Object)"space is null! Can not display spaceActivites");
            return;
        }
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", this.space.getPrettyName(), false);
        this.removeChild(UIActivitiesLoader.class);
        this.activitiesLoader = (UIActivitiesLoader)this.addChild(UIActivitiesLoader.class, null, "UIActivitiesLoader");
        this.activitiesLoader.setSpace(this.space);
        this.activitiesLoader.setPostContext(UIComposer.PostContext.SPACE);
        this.activitiesLoader.setLoadingCapacity(20);
        this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)Utils.getActivityManager().getActivitiesWithListAccess(spaceIdentity));
        this.activitiesLoader.init();
    }
}

