/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.config;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.JSecurityException;
import org.jsecurity.config.ConfigurationException;
import org.jsecurity.config.ReflectionBuilder;
import org.jsecurity.config.TextConfiguration;
import org.jsecurity.io.IniResource;
import org.jsecurity.io.ResourceUtils;
import org.jsecurity.mgt.DefaultSecurityManager;
import org.jsecurity.mgt.RealmSecurityManager;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.realm.Realm;
import org.jsecurity.realm.RealmFactory;
import org.jsecurity.util.LifecycleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniConfiguration
extends TextConfiguration {
    private static final Log log = LogFactory.getLog(IniConfiguration.class);
    public static final String DEFAULT_INI_RESOURCE_PATH = "classpath:jsecurity.ini";
    public static final String MAIN = "main";
    public static final String SESSION_MODE_PROPERTY_NAME = "sessionMode";
    protected String configUrl;
    protected IniResource iniResource;
    protected boolean ignoreResourceNotFound = false;

    public IniConfiguration() {
    }

    public IniConfiguration(String configBodyOrResourcePath) {
        this.load(configBodyOrResourcePath);
    }

    public IniConfiguration(String configBodyOrResourcePath, String charsetName) {
        try {
            this.iniResource = new IniResource(configBodyOrResourcePath, charsetName);
            this.process(this.iniResource);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected String getConfigUrl() {
        return this.configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init() throws JSecurityException {
        if (this.configUrl != null) {
            if (ResourceUtils.resourceExists(this.configUrl)) {
                this.load(this.configUrl);
            } else {
                if (!this.ignoreResourceNotFound) throw new ConfigurationException("JSecurity resource [" + this.configUrl + "] specified as a 'configUrl' " + "cannot be found.  If you want to fall back on default configuration specified " + "via the 'config' parameter, then set 'ignoreResourceNotFound' to true.");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JSecurity resource [" + this.configUrl + "] not found.  Ignoring since " + "'ignoreResourceNotFound' is set to true."));
                }
            }
        } else if (ResourceUtils.resourceExists(DEFAULT_INI_RESOURCE_PATH)) {
            this.load(DEFAULT_INI_RESOURCE_PATH);
        }
        super.init();
        SecurityManager sm = this.getSecurityManager();
        if (sm != null) return;
        sm = this.createDefaultSecurityManager();
        this.setSecurityManager(sm);
    }

    @Override
    protected void load(Reader r) throws ConfigurationException {
        try {
            this.iniResource = new IniResource(r);
            this.process(this.iniResource);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    protected void load(Scanner s) throws ConfigurationException {
        try {
            this.iniResource = new IniResource(s);
            this.process(this.iniResource);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public void load(String path) throws ConfigurationException {
        try {
            this.iniResource = new IniResource(path);
            this.process(this.iniResource);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public void load(InputStream is) throws ConfigurationException {
        try {
            this.iniResource = new IniResource(is);
            this.process(this.iniResource);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected void process(IniResource ini) {
        this.processIni(ini.getSections());
    }

    protected void processIni(Map<String, Map<String, String>> sections) {
        SecurityManager securityManager = this.createSecurityManager(sections);
        if (securityManager == null) {
            String msg = "A " + SecurityManager.class + " instance must be created at startup.";
            throw new ConfigurationException(msg);
        }
        this.setSecurityManager(securityManager);
        this.afterSecurityManagerSet(sections);
    }

    protected SecurityManager createDefaultSecurityManager() {
        return this.newSecurityManagerInstance();
    }

    protected SecurityManager createSecurityManager(Map<String, Map<String, String>> sections) {
        Map<String, String> mainSection = sections.get(MAIN);
        return this.createSecurityManagerForSection(mainSection);
    }

    protected RealmSecurityManager newSecurityManagerInstance() {
        return new DefaultSecurityManager();
    }

    protected SecurityManager createSecurityManagerForSection(Map<String, String> mainSection) {
        LinkedHashMap<String, RealmSecurityManager> defaults = new LinkedHashMap<String, RealmSecurityManager>();
        RealmSecurityManager securityManager = this.newSecurityManagerInstance();
        defaults.put("securityManager", securityManager);
        defaults.put("sm", securityManager);
        ReflectionBuilder builder = new ReflectionBuilder(defaults);
        Map objects = builder.buildObjects(mainSection);
        ArrayList<Realm> realms = new ArrayList<Realm>();
        for (Map.Entry entry : objects.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof RealmSecurityManager) {
                securityManager = (RealmSecurityManager)value;
                continue;
            }
            if (value instanceof RealmFactory) {
                RealmFactory factory = (RealmFactory)value;
                LifecycleUtils.init(factory);
                Collection<Realm> factoryRealms = factory.getRealms();
                if (factoryRealms == null || factoryRealms.isEmpty()) continue;
                realms.addAll(factoryRealms);
                continue;
            }
            if (!(value instanceof Realm)) continue;
            Realm realm = (Realm)value;
            String existingName = realm.getName();
            if (existingName == null || existingName.startsWith(realm.getClass().getName())) {
                try {
                    builder.applyProperty(realm, "name", name);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            realms.add(realm);
        }
        if (!realms.isEmpty()) {
            securityManager.setRealms(realms);
            LifecycleUtils.init(realms);
        }
        return securityManager;
    }

    protected void afterSecurityManagerSet(Map<String, Map<String, String>> sections) {
    }
}

