/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;

public abstract class AbstractRepositorySuspender {
    private final ManageableRepository repository;

    public AbstractRepositorySuspender(ManageableRepository repository) {
        this.repository = repository;
    }

    protected void suspendRepository() throws RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        this.repository.setState(3);
    }

    protected void resumeRepository() throws RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        this.repository.setState(1);
    }

    protected String getRepositoryStateTitle() {
        return this.repository.getStateTitle();
    }

    protected int getRepositoryState() {
        return this.repository.getState();
    }
}

