/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.content;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.core.api.content.ComparisonException;

public class CustomizationContextComparator
implements Comparator<CustomizationContext> {
    private List<String> contextOrder;

    public CustomizationContextComparator(List<String> contextOrder) {
        this.contextOrder = contextOrder;
    }

    public CustomizationContextComparator(String ... contextOrder) {
        this(Arrays.asList(contextOrder));
    }

    @Override
    public int compare(CustomizationContext c1, CustomizationContext c2) {
        String t1 = c1.getContextType();
        int i1 = this.contextOrder.indexOf(t1);
        if (i1 == -1) {
            throw new ComparisonException("Context type " + t1 + " cannot be used for comparison");
        }
        String t2 = c2.getContextType();
        int i2 = this.contextOrder.indexOf(t2);
        if (i2 == -1) {
            throw new ComparisonException("Context type " + t1 + " cannot be used for comparison");
        }
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        if (c1.contains(c2)) {
            if (c2.contains(c1)) {
                return 0;
            }
            return -1;
        }
        if (c2.contains(c1)) {
            return 1;
        }
        throw new ComparisonException("Cannot compare customization contexts " + c1 + " and " + c2);
    }
}

