/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.content;

import java.util.HashMap;
import java.util.Map;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.core.api.content.CustomizationContextResolver;
import org.gatein.mop.spi.customization.CustomizationContextProvider;

public class CustomizationContextProviderRegistry
implements CustomizationContextResolver {
    final transient Map<String, CustomizationContextProvider> resolvers = new HashMap<String, CustomizationContextProvider>();

    public synchronized void register(String contextType, CustomizationContextProvider contentProvider) {
        if (contextType == null) {
            throw new NullPointerException();
        }
        if (contentProvider == null) {
            throw new NullPointerException();
        }
        this.resolvers.put(contextType, contentProvider);
    }

    public synchronized void unregister(String contextType) {
        if (contextType == null) {
            throw new NullPointerException();
        }
        this.resolvers.remove(contextType);
    }

    @Override
    public CustomizationContext resolve(String contextType, String contextId) {
        if (contextType == null) {
            throw new NullPointerException();
        }
        if (contextId == null) {
            throw new NullPointerException();
        }
        CustomizationContextProvider provider = this.resolvers.get(contextType);
        if (provider != null) {
            return provider.resolveContext(contextId);
        }
        return null;
    }
}

