/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.state.producer;

import java.util.HashMap;
import java.util.Map;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.state.producer.PortletStateContextImpl;
import org.gatein.pc.portlet.state.InvalidStateIdException;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.state.producer.AbstractPortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.PortletStateContext;

public class PortletStatePersistenceManagerService
extends AbstractPortletStatePersistenceManager {
    private Map<String, PortletStateContext> store = new HashMap<String, PortletStateContext>();
    private int counter = 0;

    @Override
    protected synchronized PortletStateContext getStateContext(String stateId) throws InvalidStateIdException {
        this.checkId(stateId);
        return this.store.get(stateId);
    }

    @Override
    protected synchronized String createStateContext(String portletId, PropertyMap propertyMap) {
        String id = Integer.toString(this.counter++);
        PortletStateContextImpl state = new PortletStateContextImpl(id, portletId, new SimplePropertyMap(propertyMap));
        this.store.put(id, state);
        return id;
    }

    @Override
    protected synchronized PortletStateContext destroyStateContext(String stateId) throws InvalidStateIdException {
        this.checkId(stateId);
        return this.store.remove(stateId);
    }

    private void checkId(String stateId) throws InvalidStateIdException {
        try {
            Integer.parseInt(stateId);
        }
        catch (NumberFormatException e) {
            throw new InvalidStateIdException(e, stateId);
        }
    }

    @Override
    protected void updateStateContext(PortletStateContext stateContext) {
    }

    public synchronized int getSize() {
        return this.store.size();
    }
}

