/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

public class Javascript {
    private final String module;
    private final String contextPath;
    private final int priority;
    private final String path;

    public Javascript(String module, String path, String contextPath, int priority) {
        this.module = module;
        this.path = path.startsWith("http://") || path.startsWith("https://") ? path : contextPath + path;
        this.contextPath = contextPath;
        this.priority = priority < 0 ? Integer.MAX_VALUE : priority;
    }

    public String getPath() {
        return this.path;
    }

    public String getModule() {
        return this.module;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isExternalScript() {
        return this.path.startsWith("http://") || this.path.startsWith("https://");
    }

    public String toString() {
        return "Javascript[module=" + this.module + ", path=" + this.path + "]";
    }

    public static class ExtendedJScript
    extends Javascript {
        private final String script;

        public ExtendedJScript(String module, String path, String contextPath, String script) {
            super(module, path, contextPath, Integer.MAX_VALUE);
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }
    }

    public static class PortalJScript
    extends Javascript {
        private final String portalName;

        public PortalJScript(String module, String path, String contextPath, int priority, String portalName) {
            super(module, path, contextPath, priority);
            this.portalName = portalName;
        }

        public String getPortalName() {
            return this.portalName;
        }
    }
}

