/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Storage;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;

public class LobStoreRAFile
implements LobStore {
    final int lobBlockSize;
    Storage file;
    Database database;

    public LobStoreRAFile(Database database, int n) {
        this.lobBlockSize = n;
        this.database = database;
        try {
            String string = database.getPath() + ".lobs";
            boolean bl = database.logger.getFileAccess().isStreamElement(string);
            if (bl) {
                this.openFile();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    private void openFile() {
        try {
            String string = this.database.getPath() + ".lobs";
            boolean bl = this.database.isReadOnly();
            this.file = this.database.logger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.database, string, bl, 3) : new ScaledRAFileSimple(string, bl ? "r" : "rwd");
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public byte[] getBlockBytes(int n, int n2) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long l = (long)n * (long)this.lobBlockSize;
            int n3 = n2 * this.lobBlockSize;
            byte[] byArray = new byte[n3];
            this.file.seek(l);
            this.file.read(byArray, 0, n3);
            return byArray;
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void setBlockBytes(byte[] byArray, int n, int n2) {
        if (this.file == null) {
            this.openFile();
        }
        try {
            long l = (long)n * (long)this.lobBlockSize;
            int n3 = n2 * this.lobBlockSize;
            this.file.seek(l);
            this.file.write(byArray, 0, n3);
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }
}

