/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobInputStream;

public class ClobDataID
implements ClobData {
    long id;

    public ClobDataID(long l) {
        this.id = l;
    }

    @Override
    public char[] getChars(SessionInterface sessionInterface, long l, int n) {
        ResultLob resultLob = ResultLob.newLobGetCharsRequest(this.id, l, n);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getCharArray();
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobGetLengthRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getBlockLength();
    }

    @Override
    public String getSubString(SessionInterface sessionInterface, long l, int n) {
        char[] cArray = this.getChars(sessionInterface, l, n);
        return new String(cArray);
    }

    @Override
    public ClobData getClob(SessionInterface sessionInterface, long l, long l2) {
        ResultLob resultLob = ResultLob.newLobGetRequest(this.id, l, l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return new ClobDataID(((ResultLob)result).getLobID());
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l) {
        ResultLob resultLob = ResultLob.newLobTruncateRequest(this.id, l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
    }

    @Override
    public Reader getCharacterStream(SessionInterface sessionInterface) {
        long l = this.length(sessionInterface);
        return new ClobInputStream(sessionInterface, this, 0L, l);
    }

    @Override
    public long setCharacterStream(SessionInterface sessionInterface, long l, Reader reader) {
        return 0L;
    }

    @Override
    public int setString(SessionInterface sessionInterface, long l, String string) {
        ResultLob resultLob = ResultLob.newLobSetCharsRequest(this.id, l, string.toCharArray());
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return string.length();
    }

    @Override
    public int setString(SessionInterface sessionInterface, long l, String string, int n, int n2) {
        if (!ClobDataID.isInLimits(string.length(), n, n2)) {
            throw Error.error(3401);
        }
        ResultLob resultLob = ResultLob.newLobSetCharsRequest(this.id, l, string.substring(n, n2).toCharArray());
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return string.length();
    }

    @Override
    public int setChars(SessionInterface sessionInterface, long l, char[] cArray, int n, int n2) {
        if (!ClobDataID.isInLimits(cArray.length, n, n2)) {
            throw Error.error(3401);
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        ResultLob resultLob = ResultLob.newLobSetCharsRequest(this.id, l, cArray);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return n2;
    }

    @Override
    public long position(SessionInterface sessionInterface, String string, long l) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, string.toCharArray(), l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long position(SessionInterface sessionInterface, ClobData clobData, long l) {
        return 0L;
    }

    @Override
    public long nonSpaceLength(SessionInterface sessionInterface) {
        return 0L;
    }

    @Override
    public Reader getCharacterStream(SessionInterface sessionInterface, long l, long l2) {
        return new ClobInputStream(sessionInterface, this, l, l2);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    @Override
    public long getRightTrimSize(SessionInterface sessionInterface) {
        return 0L;
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

