/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public final class NumberType
extends Type {
    static final int tinyintPrecision = 3;
    static final int smallintPrecision = 5;
    static final int integerPrecision = 10;
    static final int bigintPrecision = 19;
    static final int doublePrecision = 0;
    public static final int defaultNumericPrecision = 100;
    public static final int defaultNumericScale = 10;
    public static final int maxNumericPrecision = Integer.MAX_VALUE;
    static final int bigintSquareNumericPrecision = 40;
    public static final int TINYINT_WIDTH = 8;
    public static final int SMALLINT_WIDTH = 16;
    public static final int INTEGER_WIDTH = 32;
    public static final int BIGINT_WIDTH = 64;
    public static final int DOUBLE_WIDTH = 128;
    public static final int DECIMAL_WIDTH = 256;
    public static final Type SQL_NUMERIC_DEFAULT_INT = new NumberType(2, 100L, 0);
    public static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    public static final BigDecimal MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MIN_LONG_BI = MIN_LONG.toBigInteger();
    public static final BigInteger MAX_LONG_BI = MAX_LONG.toBigInteger();
    final int typeWidth;

    public NumberType(int n, long l, int n2) {
        super(2, n, l, n2);
        switch (n) {
            case -6: {
                this.typeWidth = 8;
                break;
            }
            case 5: {
                this.typeWidth = 16;
                break;
            }
            case 4: {
                this.typeWidth = 32;
                break;
            }
            case 25: {
                this.typeWidth = 64;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.typeWidth = 128;
                break;
            }
            case 2: 
            case 3: {
                this.typeWidth = 256;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberType");
            }
        }
    }

    public int getPrecision() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return this.typeWidth;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                if (this.scale == 0) {
                    if (this.precision == 0L) {
                        return 646456995;
                    }
                    return (int)this.precision + 1;
                }
                if (this.precision == (long)this.scale) {
                    return (int)this.precision + 3;
                }
                return (int)this.precision + 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 23;
            }
            case 25: {
                return 20;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 6;
            }
            case -6: {
                return 4;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode == 25 ? -5 : this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 25: {
                return Long.class;
            }
            case 6: 
            case 7: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 25: {
                return "java.lang.Long";
            }
            case 6: 
            case 7: 
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String getNameString() {
        switch (this.typeCode) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 25: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 8: {
                return "DOUBLE PRECISION";
            }
        }
        return this.getNameString();
    }

    @Override
    public String getDefinition() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                StringBuffer stringBuffer = new StringBuffer(16);
                stringBuffer.append(this.getNameString());
                stringBuffer.append('(');
                stringBuffer.append(this.precision);
                if (this.scale != 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(this.scale);
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
        }
        return this.getNameString();
    }

    @Override
    public long getMaxPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        return this.getNumericPrecisionInRadix();
    }

    @Override
    public int getMaxScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Short.MAX_VALUE;
            }
        }
        return 0;
    }

    @Override
    public boolean acceptsPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecisionRadix() {
        if (this.typeCode == 3 || this.typeCode == 2) {
            return 10;
        }
        return 2;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 2: 
            case 3: {
                return this.scale == 0;
            }
        }
        return true;
    }

    @Override
    public boolean isExactNumberType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public int getNominalWidth() {
        return this.typeWidth;
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.isNumberType()) {
            int n = ((NumberType)type).typeWidth;
            return n - this.typeWidth;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (this == type) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        switch (type.typeCode) {
            case 0: {
                return this;
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (this.typeWidth == 128) {
            return this;
        }
        if (((NumberType)type).typeWidth == 128) {
            return type;
        }
        if (this.typeWidth <= 64 && ((NumberType)type).typeWidth <= 64) {
            return this.typeWidth > ((NumberType)type).typeWidth ? this : type;
        }
        int n = this.scale > type.scale ? this.scale : type.scale;
        long l = this.precision - (long)this.scale > type.precision - (long)type.scale ? this.precision - (long)this.scale : type.precision - (long)type.scale;
        return NumberType.getNumberType(3, l + (long)n, n);
    }

    @Override
    public Type getCombinedType(Type type, int n) {
        long l;
        int n2;
        if (type.typeCode == 0) {
            type = this;
        }
        switch (n) {
            case 32: {
                break;
            }
            case 34: {
                if (!type.isIntervalType()) break;
                return type.getCombinedType(this, 34);
            }
            case 35: {
                if (this.typeWidth == 256) break;
            }
            default: {
                return this.getAggregateType(type);
            }
        }
        if (!type.isNumberType()) {
            throw Error.error(5562);
        }
        if (this.typeWidth == 128 || ((NumberType)type).typeWidth == 128) {
            return Type.SQL_DOUBLE;
        }
        int n3 = this.typeWidth + ((NumberType)type).typeWidth;
        if (n3 <= 32) {
            return Type.SQL_INTEGER;
        }
        if (n3 <= 64) {
            return Type.SQL_BIGINT;
        }
        switch (n) {
            case 32: {
                n2 = this.scale > type.scale ? this.scale : type.scale;
                l = this.precision - (long)this.scale > type.precision - (long)type.scale ? this.precision - (long)this.scale : type.precision - (long)type.scale;
                ++l;
                break;
            }
            case 35: {
                l = this.precision - (long)this.scale + (long)type.scale;
                n2 = this.scale > type.scale ? this.scale : type.scale;
                break;
            }
            case 34: {
                l = this.precision - (long)this.scale + type.precision - (long)type.scale;
                n2 = this.scale + type.scale;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberType");
            }
        }
        return NumberType.getNumberType(3, (long)n2 + l, n2);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                if (object2 instanceof Integer) {
                    int n;
                    int n2 = ((Number)object).intValue();
                    return n2 > (n = ((Number)object2).intValue()) ? 1 : (n > n2 ? -1 : 0);
                }
                if (object2 instanceof Double) {
                    double d;
                    double d2 = ((Number)object).doubleValue();
                    return d2 > (d = ((Number)object2).doubleValue()) ? 1 : (d > d2 ? -1 : 0);
                }
                if (object2 instanceof BigDecimal) {
                    BigDecimal bigDecimal = NumberType.convertToDecimal(object);
                    int n = bigDecimal.compareTo((BigDecimal)object2);
                    return n == 0 ? 0 : (n < 0 ? -1 : 1);
                }
            }
            case 25: {
                if (object2 instanceof Long) {
                    long l;
                    long l2 = ((Number)object).longValue();
                    return l2 > (l = ((Number)object2).longValue()) ? 1 : (l > l2 ? -1 : 0);
                }
                if (object2 instanceof Double) {
                    BigDecimal bigDecimal;
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)object).longValue());
                    int n = bigDecimal2.compareTo(bigDecimal = new BigDecimal((Double)object2));
                    return n == 0 ? 0 : (n < 0 ? -1 : 1);
                }
                if (object2 instanceof BigDecimal) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
                    int n = bigDecimal.compareTo((BigDecimal)object2);
                    return n == 0 ? 0 : (n < 0 ? -1 : 1);
                }
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return d > d3 ? 1 : (d3 > d ? -1 : 0);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = NumberType.convertToDecimal(object2);
                int n = ((BigDecimal)object).compareTo(bigDecimal);
                return n == 0 ? 0 : (n < 0 ? -1 : 1);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return object;
            }
            case 6: 
            case 7: 
            case 8: {
                return object;
            }
            case 2: 
            case 3: {
                int n;
                BigDecimal bigDecimal = (BigDecimal)object;
                if (this.scale != bigDecimal.scale()) {
                    bigDecimal = bigDecimal.setScale(this.scale, 5);
                }
                if ((long)(n = JavaSystem.precision(bigDecimal)) > this.precision) {
                    throw Error.error(3403);
                }
                return bigDecimal;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        if (type.typeCode == this.typeCode) {
            switch (this.typeCode) {
                case 2: 
                case 3: {
                    if (type.scale != this.scale || type.precision > this.precision) break;
                    return object;
                }
                default: {
                    return object;
                }
            }
        }
        if (type.isIntervalType()) {
            int n = ((IntervalType)type).endIntervalType;
            switch (n) {
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    Long l = ValuePool.getLong(((IntervalType)type).convertToLong(object));
                    return this.convertToType(sessionInterface, l, Type.SQL_BIGINT);
                }
                case 106: {
                    long l = ((IntervalSecondData)object).units;
                    long l2 = ((IntervalSecondData)object).nanos;
                    BigDecimal bigDecimal = ((DTIType)type).getSecondPart(l, l2);
                    return bigDecimal;
                }
            }
        }
        switch (type.typeCode) {
            case 40: {
                object = ((ClobData)object).getSubString(sessionInterface, 0L, (int)((ClobData)object).length(sessionInterface));
            }
            case 1: 
            case 12: 
            case 100: {
                object = sessionInterface.getScanner().convertToNumber((String)object, this);
                object = this.convertToDefaultType(sessionInterface, object);
                return this.convertToTypeLimits(sessionInterface, object);
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            case 14: 
            case 15: {
                if (type.precision == 1L) {
                    if (((BinaryData)object).getBytes()[0] == 0) {
                        object = ValuePool.INTEGER_0;
                        break;
                    }
                    object = ValuePool.INTEGER_1;
                    break;
                }
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return NumberType.convertToInt(object, this.typeCode);
            }
            case 25: {
                return NumberType.convertToLong(object);
            }
            case 6: 
            case 7: 
            case 8: {
                return NumberType.convertToDouble(object);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = NumberType.convertToDecimal(object);
                return this.convertToTypeLimits(sessionInterface, bigDecimal);
            }
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        if (type.isLobType()) {
            throw Error.error(5561);
        }
        switch (type.typeCode) {
            case 16: {
                object = (Boolean)object != false ? ValuePool.INTEGER_1 : ValuePool.INTEGER_0;
                type = Type.SQL_INTEGER;
            }
        }
        return this.convertToType(sessionInterface, object, type);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        void var3_8;
        if (object == null) {
            return object;
        }
        if (object instanceof Number) {
            if (object instanceof BigInteger) {
                object = new BigDecimal((BigInteger)object);
            } else if (object instanceof Float) {
                object = new Double(((Float)object).doubleValue());
            } else if (object instanceof Byte) {
                object = ValuePool.getInt(((Byte)object).intValue());
            } else if (object instanceof Short) {
                object = ValuePool.getInt(((Short)object).intValue());
            }
            if (object instanceof Integer) {
                NumberType numberType = Type.SQL_INTEGER;
                return this.convertToType(sessionInterface, object, (Type)var3_8);
            } else if (object instanceof Long) {
                NumberType numberType = Type.SQL_BIGINT;
                return this.convertToType(sessionInterface, object, (Type)var3_8);
            } else if (object instanceof Double) {
                NumberType numberType = Type.SQL_DOUBLE;
                return this.convertToType(sessionInterface, object, (Type)var3_8);
            } else {
                if (!(object instanceof BigDecimal)) throw Error.error(5561);
                if (this.typeCode == 3 || this.typeCode == 2) {
                    return object;
                }
                NumberType numberType = Type.SQL_DECIMAL_DEFAULT;
            }
            return this.convertToType(sessionInterface, object, (Type)var3_8);
        } else {
            if (!(object instanceof String)) throw Error.error(5561);
            CharacterType characterType = Type.SQL_VARCHAR;
        }
        return this.convertToType(sessionInterface, object, (Type)var3_8);
    }

    static Integer convertToInt(Object object, int n) {
        int n2;
        if (object instanceof Integer) {
            if (n == 4) {
                return (Integer)object;
            }
            n2 = (Integer)object;
        } else if (object instanceof Long) {
            long l = (Long)object;
            if (Integer.MAX_VALUE < l || l < Integer.MIN_VALUE) {
                throw Error.error(3403);
            }
            n2 = (int)l;
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(MAX_INT) > 0 || bigDecimal.compareTo(MIN_INT) < 0) {
                throw Error.error(3403);
            }
            n2 = bigDecimal.intValue();
        } else if (object instanceof Double || object instanceof Float) {
            double d = ((Number)object).doubleValue();
            if (Double.isInfinite(d) || Double.isNaN(d) || d >= 2.147483648E9 || d <= -2.147483649E9) {
                throw Error.error(3403);
            }
            n2 = (int)d;
        } else {
            throw Error.error(5561);
        }
        if (n == -6 ? 127 < n2 || n2 < -128 : n == 5 && (Short.MAX_VALUE < n2 || n2 < Short.MIN_VALUE)) {
            throw Error.error(3403);
        }
        return ValuePool.getInt(n2);
    }

    static Long convertToLong(Object object) {
        if (object instanceof Integer) {
            return ValuePool.getLong(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(MAX_LONG) > 0 || bigDecimal.compareTo(MIN_LONG) < 0) {
                throw Error.error(3403);
            }
            return ValuePool.getLong(bigDecimal.longValue());
        }
        if (object instanceof Double || object instanceof Float) {
            double d = ((Number)object).doubleValue();
            if (Double.isInfinite(d) || Double.isNaN(d) || d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
                throw Error.error(3403);
            }
            return ValuePool.getLong((long)d);
        }
        throw Error.error(5561);
    }

    private static Double convertToDouble(Object object) {
        double d;
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigDecimal) {
            int n;
            BigDecimal bigDecimal = (BigDecimal)object;
            d = bigDecimal.doubleValue();
            BigDecimal bigDecimal2 = new BigDecimal(d + (double)(n = bigDecimal.signum()));
            if (bigDecimal2.compareTo(bigDecimal) != n) {
                throw Error.error(3403);
            }
        } else {
            d = ((Number)object).doubleValue();
        }
        return ValuePool.getDouble(Double.doubleToLongBits(d));
    }

    public static double toDouble(Object object) {
        double d;
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigDecimal) {
            int n;
            BigDecimal bigDecimal = (BigDecimal)object;
            d = bigDecimal.doubleValue();
            BigDecimal bigDecimal2 = new BigDecimal(d + (double)(n = bigDecimal.signum()));
            if (bigDecimal2.compareTo(bigDecimal) != n) {
                throw Error.error(3403);
            }
        } else if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            throw Error.error(3471);
        }
        return d;
    }

    private static BigDecimal convertToDecimal(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Integer || object instanceof Long) {
            return BigDecimal.valueOf(((Number)object).longValue());
        }
        if (object instanceof Double) {
            double d = ((Number)object).doubleValue();
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return null;
            }
            return new BigDecimal(d);
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return object.toString();
            }
            case 7: 
            case 8: {
                double d = (Double)object;
                if (d == Double.NEGATIVE_INFINITY) {
                    return "-1E0/0";
                }
                if (d == Double.POSITIVE_INFINITY) {
                    return "1E0/0";
                }
                if (Double.isNaN(d)) {
                    return "0E0/0E0";
                }
                String string = Double.toString(d);
                if (string.indexOf(69) < 0) {
                    string = string.concat("E0");
                }
                return string;
            }
            case 2: 
            case 3: {
                return JavaSystem.toString((BigDecimal)object);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return this.convertToString(object);
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isNumberType()) {
            return true;
        }
        if (type.isIntervalType()) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        return type.isBitType() && type.precision == 1L;
    }

    @Override
    public int compareToTypeRange(Object object) {
        if (!(object instanceof Number)) {
            return 0;
        }
        if (object instanceof Integer || object instanceof Long) {
            int n;
            int n2;
            long l = ((Number)object).longValue();
            switch (this.typeCode) {
                case -6: {
                    n2 = -128;
                    n = 127;
                    break;
                }
                case 5: {
                    n2 = Short.MIN_VALUE;
                    n = Short.MAX_VALUE;
                    break;
                }
                case 4: {
                    n2 = Integer.MIN_VALUE;
                    n = Integer.MAX_VALUE;
                    break;
                }
                case 25: {
                    return 0;
                }
                case 2: 
                case 3: {
                    if (this.precision - (long)this.scale > 18L) {
                        return 0;
                    }
                    if (this.precision - (long)this.scale > 9L && object instanceof Integer) {
                        return 0;
                    }
                    BigDecimal bigDecimal = NumberType.convertToDecimal(object);
                    int n3 = bigDecimal.scale();
                    int n4 = JavaSystem.precision(bigDecimal);
                    if (n3 < 0) {
                        n4 -= n3;
                        n3 = 0;
                    }
                    return this.precision - (long)this.scale >= (long)(n4 - n3) ? 0 : bigDecimal.signum();
                }
                default: {
                    return 0;
                }
            }
            if ((long)n < l) {
                return 1;
            }
            if (l < (long)n2) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public Object add(Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d + d2));
            }
            case 2: 
            case 3: {
                object = this.convertToDefaultType(null, object);
                object2 = this.convertToDefaultType(null, object2);
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                bigDecimal = bigDecimal.add(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal);
            }
            case -6: 
            case 4: 
            case 5: {
                int n = ((Number)object).intValue();
                int n2 = ((Number)object2).intValue();
                return ValuePool.getInt(n + n2);
            }
            case 25: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return ValuePool.getLong(l + l2);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object subtract(Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d - d2));
            }
            case 2: 
            case 3: {
                object = this.convertToDefaultType(null, object);
                object2 = this.convertToDefaultType(null, object2);
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                bigDecimal = bigDecimal.subtract(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal);
            }
            case -6: 
            case 4: 
            case 5: {
                int n = ((Number)object).intValue();
                int n2 = ((Number)object2).intValue();
                return ValuePool.getInt(n - n2);
            }
            case 25: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return ValuePool.getLong(l - l2);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object multiply(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d * d2));
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) {
                    object = this.convertToDefaultType(null, object);
                }
                if (!(object2 instanceof BigDecimal)) {
                    object2 = this.convertToDefaultType(null, object2);
                }
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal3);
            }
            case -6: 
            case 4: 
            case 5: {
                int n = ((Number)object).intValue();
                int n2 = ((Number)object2).intValue();
                return ValuePool.getInt(n * n2);
            }
            case 25: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return ValuePool.getLong(l * l2);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object divide(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                if (d2 == 0.0) {
                    throw Error.error(3432);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d / d2));
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) {
                    object = this.convertToDefaultType(null, object);
                }
                if (!(object2 instanceof BigDecimal)) {
                    object2 = this.convertToDefaultType(null, object2);
                }
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                if (bigDecimal2.signum() == 0) {
                    throw Error.error(3432);
                }
                BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, this.scale, 1);
                return this.convertToTypeLimits(null, bigDecimal3);
            }
            case -6: 
            case 4: 
            case 5: {
                int n = ((Number)object).intValue();
                int n2 = ((Number)object2).intValue();
                if (n2 == 0) {
                    throw Error.error(3432);
                }
                return ValuePool.getInt(n / n2);
            }
            case 25: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                if (l2 == 0L) {
                    throw Error.error(3432);
                }
                return ValuePool.getLong(l / l2);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public Object modulo(Object object, Object object2, Type type) {
        if (!type.isNumberType()) {
            throw Error.error(5561);
        }
        Object object3 = this.divide(object, object2);
        object3 = this.multiply(object3, object2);
        object3 = this.convertToDefaultType(null, object3);
        object3 = this.subtract(object, object3, this);
        return this.convertToTypeLimits(null, object3);
    }

    @Override
    public Object absolute(Object object) {
        return this.isNegative(object) ? this.negate(object) : object;
    }

    @Override
    public Object negate(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = -((Number)object).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: {
                int n = ((Number)object).intValue();
                if (n == -128) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-n);
            }
            case 5: {
                int n = ((Number)object).intValue();
                if (n == Short.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-n);
            }
            case 4: {
                int n = ((Number)object).intValue();
                if (n == Integer.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-n);
            }
            case 25: {
                long l = ((Number)object).longValue();
                if (l == Long.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getLong(-l);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public int getNumericPrecisionInRadix() {
        switch (this.typeCode) {
            case -6: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 25: {
                return 64;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public Type getIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return SQL_NUMERIC_DEFAULT_INT;
            }
            case 2: 
            case 3: {
                return this.scale == 0 ? this : new NumberType(this.typeCode, this.precision, 0);
            }
        }
        return this;
    }

    public static boolean isZero(Object object) {
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).signum() == 0;
        }
        if (object instanceof Double) {
            return (Double)object == 0.0 || ((Double)object).isNaN();
        }
        return ((Number)object).longValue() == 0L;
    }

    public boolean isNegative(Object object) {
        if (object == null) {
            return false;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                return d < 0.0;
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).signum() < 0;
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Number)object).intValue() < 0;
            }
            case 25: {
                return ((Number)object).longValue() < 0L;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public int compareToZero(Object object) {
        if (object == null) {
            return 0;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                return d == 0.0 ? 0 : (d < 0.0 ? -1 : 1);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).signum();
            }
            case -6: 
            case 4: 
            case 5: {
                int n = ((Number)object).intValue();
                return n == 0 ? 0 : (n < 0 ? -1 : 1);
            }
            case 25: {
                long l = ((Number)object).longValue();
                return l == 0L ? 0 : (l < 0L ? -1 : 1);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public static long scaledDecimal(Object object, int n) {
        if (object == null) {
            return 0L;
        }
        if (n == 0) {
            return 0L;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (bigDecimal.scale() == 0) {
            return 0L;
        }
        bigDecimal = bigDecimal.setScale(0, 3);
        bigDecimal = ((BigDecimal)object).subtract(bigDecimal);
        return bigDecimal.movePointRight(n).longValue();
    }

    public static boolean isInLongLimits(BigDecimal bigDecimal) {
        return MIN_LONG.compareTo(bigDecimal) <= 0 && MAX_LONG.compareTo(bigDecimal) >= 0;
    }

    public static boolean isInLongLimits(BigInteger bigInteger) {
        return MAX_LONG_BI.compareTo(bigInteger) >= 0 && MIN_LONG_BI.compareTo(bigInteger) <= 0;
    }

    public Object ceiling(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = Math.ceil((Double)object);
                if (Double.isInfinite(d)) {
                    throw Error.error(3403);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((BigDecimal)object).setScale(0, 2);
                return bigDecimal;
            }
        }
        return object;
    }

    public Object floor(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d = Math.floor((Double)object);
                if (Double.isInfinite(d)) {
                    throw Error.error(3403);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((BigDecimal)object).setScale(0, 3);
                return bigDecimal;
            }
        }
        return object;
    }

    public Object truncate(Object object, int n) {
        if (object == null) {
            return null;
        }
        if (n >= this.scale) {
            return object;
        }
        BigDecimal bigDecimal = NumberType.convertToDecimal(object);
        bigDecimal = bigDecimal.setScale(n, 1);
        bigDecimal = bigDecimal.setScale(this.scale, 1);
        object = this.convertToDefaultType(null, bigDecimal);
        return this.convertToTypeLimits(null, object);
    }

    public static NumberType getNumberType(int n, long l, int n2) {
        switch (n) {
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: 
            case 3: {
                return new NumberType(n, l, n2);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }
}

