/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.scope;

import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ScopeManager
implements ComponentRequestLifecycle {
    private static final ThreadLocal<String> currentScope = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(ScopeManager.class);

    public static String getCurrentScope() {
        return currentScope.get();
    }

    public void startRequest(ExoContainer container) {
        if (currentScope.get() != null) {
            throw new IllegalStateException("Detected scope reentrancy " + currentScope.get());
        }
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        String scope = null;
        if (repositoryService != null) {
            try {
                ManageableRepository currentRepository = repositoryService.getCurrentRepository();
                if (currentRepository != null) {
                    scope = currentRepository.getConfiguration().getName();
                }
            }
            catch (RepositoryException e) {
                log.error((Object)"Could not obtain scope value from repository", (Throwable)e);
            }
        }
        if (scope == null) {
            scope = "";
        }
        currentScope.set(scope);
        log.debug((Object)("Starting scope request \"" + scope + "\""));
    }

    public void endRequest(ExoContainer container) {
        if (currentScope.get() == null) {
            throw new IllegalStateException("Detected unscoped unscoping ");
        }
        currentScope.set(null);
    }
}

