/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.RelationshipType;
import org.chromattic.common.JCR;
import org.chromattic.common.collection.SetMap;
import org.chromattic.metamodel.annotations.NotReferenceable;
import org.chromattic.metamodel.annotations.Skip;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.BeanMappingBuilder;
import org.chromattic.metamodel.mapping.MappingVisitor;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.PropertiesMapping;
import org.chromattic.metamodel.mapping.RelationshipMapping;
import org.chromattic.metamodel.mapping.ValueMapping;
import org.chromattic.metamodel.mapping.jcr.PropertyMetaType;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.PropertyDefinition;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBuilder {
    private final SimpleTypeResolver simpleTypeResolver;

    public SchemaBuilder() {
        this(new SimpleTypeResolver());
    }

    public SchemaBuilder(SimpleTypeResolver simpleTypeResolver) {
        this.simpleTypeResolver = simpleTypeResolver;
    }

    public Map<ClassTypeInfo, NodeType> build(Collection<BeanMapping> mappings) {
        HashMap<ClassTypeInfo, NodeType> schema = new HashMap<ClassTypeInfo, NodeType>();
        Visitor visitor = new Visitor();
        for (BeanMapping mapping : mappings) {
            mapping.accept(visitor);
            BeanInfo bean = mapping.getBean();
            if (!bean.isDeclared()) continue;
            ClassTypeInfo key = bean.getClassType();
            schema.put(key, visitor.getNodeType(key));
        }
        visitor.end();
        return schema;
    }

    public Map<ClassTypeInfo, NodeType> build(Set<ClassTypeInfo> classTypes) {
        BeanMappingBuilder amp = new BeanMappingBuilder(this.simpleTypeResolver);
        Map<ClassTypeInfo, BeanMapping> mappings = amp.build(classTypes);
        return this.build(mappings.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Visitor
    extends MappingVisitor {
        private final LinkedHashMap<ClassTypeInfo, NodeType> nodeTypes = new LinkedHashMap();
        private NodeType current;
        private final SetMap<ClassTypeInfo, ClassTypeInfo> embeddedSuperTypesMap = new SetMap();

        private Visitor() {
        }

        public NodeType getNodeType(ClassTypeInfo type) {
            return this.nodeTypes.get(type);
        }

        private NodeType resolve(BeanMapping mapping) {
            NodeType nodeType = this.nodeTypes.get(mapping.getBean().getClassType());
            if (nodeType == null && mapping.getBean().getAnnotation(Skip.class) == null) {
                boolean referenceable = mapping.getBean().getAnnotation(NotReferenceable.class) == null;
                nodeType = new NodeType(mapping, referenceable);
                this.nodeTypes.put(mapping.getBean().getClassType(), nodeType);
            }
            return nodeType;
        }

        @Override
        public void singleValueMapping(ValueMapping<ValueKind.Single> mapping) {
            if (this.current != null) {
                if (((SimpleValueInfo)mapping.getValue()).getValueKind() == ValueKind.SINGLE) {
                    if (mapping.isTypeCovariant() && ((PropertyInfo)mapping.getProperty()).getAnnotation(Skip.class) == null) {
                        this.current.properties.put(mapping.getPropertyDefinition().getName(), new PropertyDefinition(mapping.getPropertyDefinition(), false));
                    }
                } else if (mapping.isTypeCovariant() && ((PropertyInfo)mapping.getProperty()).getAnnotation(Skip.class) == null) {
                    this.current.properties.put(mapping.getPropertyDefinition().getName(), new PropertyDefinition(mapping.getPropertyDefinition(), true));
                }
            }
        }

        @Override
        public void oneToManyReference(RelationshipMapping.OneToMany.Reference mapping) {
            if (mapping.isTypeCovariant() && ((PropertyInfo)mapping.getProperty()).getAnnotation(Skip.class) == null) {
                this.gerenateOneToManyReference(mapping.getOwner(), mapping.getRelatedBeanMapping(), mapping.getType(), mapping.getMappedBy());
            }
        }

        private void gerenateOneToManyReference(BeanMapping oneMapping, BeanMapping manyMapping, RelationshipType mappingType, String mappedBy) {
            PropertyDefinition def;
            NodeType related = this.resolve(manyMapping);
            if (mappingType == RelationshipType.REFERENCE) {
                def = new PropertyDefinition(mappedBy, false, 9);
                NodeType nodeType = this.resolve(oneMapping);
                if (nodeType != null) {
                    def.addValueConstraint(nodeType.getName());
                }
            } else if (mappingType == RelationshipType.PATH) {
                def = new PropertyDefinition(mappedBy, false, 8);
            } else {
                throw new AssertionError();
            }
            related.properties.put(mappedBy, def);
        }

        @Override
        public void manyToOneReference(RelationshipMapping.ManyToOne.Reference mapping) {
            if (mapping.isTypeCovariant() && ((PropertyInfo)mapping.getProperty()).getAnnotation(Skip.class) == null) {
                this.gerenateOneToManyReference(mapping.getRelatedBeanMapping(), mapping.getOwner(), mapping.getType(), mapping.getMappedBy());
            }
        }

        @Override
        public void propertiesMapping(PropertiesMapping<?> mapping) {
            if (this.current != null && ((PropertyInfo)mapping.getProperty()).getAnnotation(Skip.class) == null) {
                PropertyMetaType<?> metatype = mapping.getMetaType();
                int code = metatype != null ? metatype.getCode() : 0;
                boolean multiple = mapping.getValueKind() != ValueKind.SINGLE;
                PropertyDefinition pd = this.current.properties.get("*");
                if (pd == null) {
                    this.current.properties.put("*", new PropertyDefinition("*", multiple, code));
                } else if (pd.getType() != code) {
                    this.current.properties.put("*", new PropertyDefinition("*", multiple, 0));
                }
            }
        }

        @Override
        public void manyToOneHierarchic(RelationshipMapping.ManyToOne.Hierarchic mapping) {
            BeanMapping relatedBeanMapping;
            NodeType related;
            if (this.current != null && mapping.isTypeCovariant() && (related = this.resolve(relatedBeanMapping = mapping.getRelatedBeanMapping())) != null) {
                related.addChildNodeType("*", false, false, this.current.mapping);
            }
        }

        @Override
        public void oneToManyHierarchic(RelationshipMapping.OneToMany.Hierarchic mapping) {
            if (this.current != null) {
                BeanMapping relatedBeanMapping = mapping.getRelatedBeanMapping();
                if (mapping.isTypeCovariant()) {
                    this.current.addChildNodeType("*", false, false, relatedBeanMapping);
                }
            }
        }

        @Override
        public void oneToOneEmbedded(RelationshipMapping.OneToOne.Embedded mapping) {
            if (this.current != null) {
                BeanMapping relatedBeanMapping = mapping.getRelatedBeanMapping();
                if (mapping.isOwner()) {
                    if (relatedBeanMapping.getNodeTypeKind() == NodeTypeKind.PRIMARY) {
                        this.embeddedSuperTypesMap.get((Object)this.current.mapping.getBean().getClassType()).add(relatedBeanMapping.getBean().getClassType());
                    }
                } else if (this.current.mapping.getNodeTypeKind() == NodeTypeKind.PRIMARY) {
                    this.embeddedSuperTypesMap.get((Object)relatedBeanMapping.getBean().getClassType()).add(this.current.mapping.getBean().getClassType());
                }
            }
        }

        @Override
        public void oneToOneHierarchic(RelationshipMapping.OneToOne.Hierarchic mapping) {
            if (this.current != null && mapping.isTypeCovariant()) {
                BeanMapping relatedBeanMapping = mapping.getRelatedBeanMapping();
                if (mapping.isOwner()) {
                    this.current.addChildNodeType(JCR.qualify((String)mapping.getPrefix(), (String)mapping.getLocalName()), mapping.getMandatory(), mapping.getAutocreated(), relatedBeanMapping);
                } else {
                    NodeType related = this.resolve(relatedBeanMapping);
                    if (related != null) {
                        related.addChildNodeType(JCR.qualify((String)mapping.getPrefix(), (String)mapping.getLocalName()), false, mapping.getAutocreated(), this.current.mapping);
                    }
                }
            }
        }

        @Override
        public void startBean(BeanMapping mapping) {
            this.current = this.resolve(mapping);
        }

        @Override
        public void endBean() {
            this.current = null;
        }

        public void end() {
            for (NodeType nodeType : this.nodeTypes.values()) {
                ClassTypeInfo cti = nodeType.mapping.getBean().getClassType();
                for (NodeType otherNodeType : this.nodeTypes.values()) {
                    if (otherNodeType == nodeType || !cti.isSubType((TypeInfo)otherNodeType.mapping.getBean().getClassType())) continue;
                    nodeType.superTypes.add(otherNodeType);
                }
                for (ClassTypeInfo embeddedSuperTypeInfo : this.embeddedSuperTypesMap.get((Object)cti)) {
                    nodeType.superTypes.add(this.nodeTypes.get(embeddedSuperTypeInfo));
                }
                block3: for (NodeType superNodeType : nodeType.superTypes) {
                    for (NodeType otherSuperNodeType : nodeType.superTypes) {
                        if (otherSuperNodeType == superNodeType || !otherSuperNodeType.mapping.getBean().getClassType().isSubType((TypeInfo)superNodeType.mapping.getBean().getClassType())) continue;
                        continue block3;
                    }
                    nodeType.declaredSuperTypes.add(superNodeType);
                }
            }
        }
    }
}

