/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIDropDownControl.gtmpl")
public class UIDropDownControl
extends UIComponent {
    private String action_;
    private List<SelectItemOption<String>> options_ = new ArrayList<SelectItemOption<String>>();
    private int selectedItemIndex_ = 0;

    public void setValue(String value) {
        int ln = this.options_.size();
        for (int i = 0; i < ln; ++i) {
            if (!this.options_.get(i).getValue().equals(value)) continue;
            this.selectedItemIndex_ = i;
            return;
        }
    }

    public void setValue(int i) {
        this.selectedItemIndex_ = i;
    }

    public void cleanItem() {
        this.options_.clear();
    }

    public void setOptions(List<SelectItemOption<String>> options) {
        this.options_ = options;
        if (options == null) {
            return;
        }
        if (this.options_.size() < 1) {
            return;
        }
    }

    public int getSelectedIndex() {
        if (this.options_.size() < 1) {
            return -1;
        }
        return this.selectedItemIndex_;
    }

    public String getLabel() {
        return this.options_.get(this.selectedItemIndex_).getLabel();
    }

    public String getValue() {
        return this.options_.get(this.selectedItemIndex_).getValue();
    }

    public void setAction(String act) {
        this.action_ = act;
    }

    public String getAction() {
        return this.action_;
    }

    public List<SelectItemOption<String>> getOptions() {
        return this.options_;
    }

    public void addItem(SelectItemOption<String> opt) {
        this.options_.add(opt);
    }

    public void addItem(String value) {
        this.options_.add(new SelectItemOption<String>(value));
    }

    public void addItem(String label, String value) {
        this.options_.add(new SelectItemOption<String>(label, value));
    }

    public String event(int selectedIndex) throws Exception {
        if (this.action_ == null) {
            return super.event(((Event)this.config.getEvents().get(0)).getName(), this.options_.get(selectedIndex).getValue());
        }
        StringBuilder evt = new StringBuilder("javascript:eXo.webui.UIDropDownControl.selectItem(");
        evt.append(this.action_).append(",'").append(this.getId()).append("','").append(selectedIndex).append("')");
        return evt.toString();
    }
}

