/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormLifecycle
extends Lifecycle<UIForm> {
    public void processDecode(UIForm uicomponent, WebuiRequestContext context) throws Exception {
        uicomponent.setSubmitAction(null);
        this.processNormalRequest(uicomponent, context);
        List children = uicomponent.getChildren();
        for (UIComponent uiChild : children) {
            uiChild.processDecode(context);
        }
        String action = uicomponent.getSubmitAction();
        String subComponentId = context.getRequestParameter("subComponentId");
        if (subComponentId == null || subComponentId.trim().length() < 1) {
            Event event = uicomponent.createEvent(action, Event.Phase.DECODE, context);
            if (event != null) {
                event.broadcast();
            }
            return;
        }
        UIComponent uiSubComponent = uicomponent.findComponentById(subComponentId);
        Event event = uiSubComponent.createEvent(action, Event.Phase.DECODE, context);
        if (event == null) {
            event = uicomponent.createEvent(action, Event.Phase.DECODE, context);
        }
        if (event != null) {
            event.broadcast();
        }
    }

    public void processAction(UIForm uicomponent, WebuiRequestContext context) throws Exception {
        String action = context.getRequestParameter("formOp");
        if (action == null) {
            action = uicomponent.getSubmitAction();
        }
        if (action == null) {
            return;
        }
        Event event = uicomponent.createEvent(action, Event.Phase.PROCESS, context);
        if (event == null) {
            event = uicomponent.getParent().createEvent(action, Event.Phase.PROCESS, context);
        }
        if (event == null) {
            return;
        }
        UIApplication uiApp = (UIApplication)uicomponent.getAncestorOfType(UIApplication.class);
        List children = uicomponent.getChildren();
        this.validateChildren(children, uiApp, context);
        if (context.getProcessRender()) {
            return;
        }
        event.broadcast();
    }

    private void processNormalRequest(UIForm uiForm, WebuiRequestContext context) throws Exception {
        ArrayList inputs = new ArrayList();
        uiForm.findComponentOfType(inputs, UIFormInputBase.class);
        uiForm.setSubmitAction(context.getRequestParameter("formOp"));
        for (UIFormInputBase input : inputs) {
            if (!input.isValid()) continue;
            String inputValue = context.getRequestParameter(input.getId());
            if (inputValue == null || inputValue.trim().length() == 0) {
                inputValue = context.getRequestParameter(input.getName());
            }
            input.decode(inputValue, context);
        }
    }

    private void validateChildren(List<UIComponent> children, UIApplication uiApp, WebuiRequestContext context) {
        for (UIComponent uiChild : children) {
            List<Validator> validators;
            UIContainer uiInput;
            if (uiChild instanceof UIFormInputBase) {
                uiInput = (UIFormInputBase)uiChild;
                if (!uiInput.isValid() || (validators = uiInput.getValidators()) == null) continue;
                try {
                    for (Validator validator : validators) {
                        validator.validate((UIFormInput)uiInput);
                    }
                    continue;
                }
                catch (MessageException ex) {
                    uiApp.addMessage(ex.getDetailMessage());
                    context.setProcessRender(true);
                    continue;
                }
                catch (Exception ex) {
                    uiApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                    context.setProcessRender(true);
                    continue;
                }
            }
            if (uiChild instanceof UIFormInputSet) {
                UIFormInputSet uiInputSet = (UIFormInputSet)uiChild;
                this.validateChildren(uiInputSet.getChildren(), uiApp, context);
                continue;
            }
            if (uiChild instanceof UIFormMultiValueInputSet) {
                uiInput = (UIFormMultiValueInputSet)uiChild;
                validators = uiInput.getValidators();
                if (validators == null) continue;
                try {
                    for (Validator validator : validators) {
                        List uiInputChild = uiInput.getChildren();
                        for (int i = 0; i < uiInputChild.size(); ++i) {
                            try {
                                validator.validate((UIFormInput)uiInputChild.get(i));
                                continue;
                            }
                            catch (MessageException ex) {
                                uiApp.addMessage(ex.getDetailMessage());
                                context.setProcessRender(true);
                            }
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    uiApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                    context.setProcessRender(true);
                    continue;
                }
            }
            if (!(uiChild instanceof UIFormInputContainer) || (validators = (uiInput = (UIFormInputContainer)uiChild).getValidators()) == null) continue;
            try {
                for (Validator validator : validators) {
                    validator.validate((UIFormInput)uiInput);
                }
            }
            catch (MessageException ex) {
                uiApp.addMessage(ex.getDetailMessage());
                context.setProcessRender(true);
            }
            catch (Exception ex) {
                uiApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                context.setProcessRender(true);
            }
        }
    }
}

