/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSiteLifeCycle
implements ApplicationLifecycle<PortalRequestContext> {
    private final Logger log = LoggerFactory.getLogger(UserSiteLifeCycle.class);
    private static final String DEFAULT_TAB_NAME = "Tab_Default";
    private static final String PAGE_TEMPLATE = "dashboard";

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, PortalRequestContext context) throws Exception {
        String userName = context.getRemoteUser();
        if (userName != null && SiteType.USER == context.getSiteType() && userName.equals(context.getSiteName())) {
            DataStorage storage = (DataStorage)PortalContainer.getComponent(DataStorage.class);
            UserPortalConfigService configService = (UserPortalConfigService)PortalContainer.getComponent(UserPortalConfigService.class);
            PortalConfig portalConfig = storage.getPortalConfig("user", userName);
            if (portalConfig == null) {
                this.log.debug((Object)("About to create user site for user " + userName));
                configService.createUserSite(userName);
            }
            UserPortalConfig userPortalConfig = context.getUserPortalConfig();
            UserPortal userPortal = userPortalConfig.getUserPortal();
            SiteKey siteKey = context.getSiteKey();
            UserNavigation nav = userPortal.getNavigation(siteKey);
            try {
                UserNode rootNode = userPortal.getNode(nav, Scope.CHILDREN, UserNodeFilterConfig.builder().build(), null);
                if (rootNode.getChildren().size() < 1) {
                    Page page = configService.createPageTemplate(PAGE_TEMPLATE, siteKey.getTypeName(), siteKey.getName());
                    page.setName(DEFAULT_TAB_NAME);
                    page.setTitle(DEFAULT_TAB_NAME);
                    storage.save(page);
                    UserNode tabNode = rootNode.addChild(DEFAULT_TAB_NAME);
                    tabNode.setLabel(DEFAULT_TAB_NAME);
                    tabNode.setPageRef(page.getPageId());
                    userPortal.saveNode(tabNode, null);
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)("Navigation " + nav.getKey().getName() + " does not exist!"), (Throwable)ex);
            }
        }
    }

    public void onFailRequest(Application app, PortalRequestContext context, RequestFailure failureType) throws Exception {
    }

    public void onEndRequest(Application app, PortalRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }
}

