/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rpc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.exoplatform.services.rpc.RemoteCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMethodCallCommand
implements RemoteCommand {
    private final Object component;
    private final Method method;
    private final String id;

    public SingleMethodCallCommand(Object component, String methodName, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        if (component == null) {
            throw new IllegalArgumentException("The component cannot be null");
        }
        if (methodName == null || (methodName = methodName.trim()).length() == 0) {
            throw new IllegalArgumentException("The methodName cannot be empty");
        }
        this.component = component;
        this.method = component.getClass().getDeclaredMethod(methodName, parameterTypes);
        if (!Modifier.isPublic(this.method.getModifiers())) {
            throw new IllegalArgumentException("The method '" + methodName + "' is not public");
        }
        this.id = SingleMethodCallCommand.getId(component, this.method);
    }

    @Override
    public Serializable execute(Serializable[] args) throws Throwable {
        try {
            return (Serializable)this.method.invoke(this.component, (Object[])args);
        }
        catch (Exception e) {
            throw new Exception("Could not execute the method " + this.id + " with the arguments " + Arrays.toString(args), e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    private static String getId(Object component, Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(component.getClass().getName());
        sb.append('.');
        sb.append(method.getName());
        sb.append('(');
        boolean first = true;
        for (Class<?> c : method.getParameterTypes()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(c.getSimpleName());
        }
        sb.append(')');
        return sb.toString();
    }
}

