/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TextShape;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.MainMaster;
import org.apache.poi.hslf.record.TxMasterStyleAtom;
import org.apache.poi.hslf.usermodel.SlideShow;

public final class SlideMaster
extends MasterSheet {
    private TextRun[] _runs = SlideMaster.findTextRuns(this.getPPDrawing());
    private TxMasterStyleAtom[] _txmaster;

    public SlideMaster(MainMaster record, int sheetNo) {
        super(record, sheetNo);
        for (int i = 0; i < this._runs.length; ++i) {
            this._runs[i].setSheet(this);
        }
    }

    public TextRun[] getTextRuns() {
        return this._runs;
    }

    public MasterSheet getMasterSheet() {
        return null;
    }

    public TextProp getStyleAttribute(int txtype, int level, String name, boolean isCharacter) {
        TextProp prop;
        block10: {
            block12: {
                block11: {
                    prop = null;
                    for (int i = level; i >= 0; --i) {
                        TextPropCollection[] styles;
                        TextPropCollection[] textPropCollectionArray = styles = isCharacter ? this._txmaster[txtype].getCharacterStyles() : this._txmaster[txtype].getParagraphStyles();
                        if (i < styles.length) {
                            prop = styles[i].findByName(name);
                        }
                        if (prop != null) break;
                    }
                    if (prop != null) break block10;
                    if (!isCharacter) break block11;
                    switch (txtype) {
                        case 5: 
                        case 7: 
                        case 8: {
                            txtype = 1;
                            break block12;
                        }
                        case 6: {
                            txtype = 0;
                            break block12;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                switch (txtype) {
                    case 5: 
                    case 7: 
                    case 8: {
                        txtype = 1;
                        break;
                    }
                    case 6: {
                        txtype = 0;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            prop = this.getStyleAttribute(txtype, level, name, isCharacter);
        }
        return prop;
    }

    public void setSlideShow(SlideShow ss) {
        super.setSlideShow(ss);
        if (this._txmaster == null) {
            TxMasterStyleAtom txdoc;
            this._txmaster = new TxMasterStyleAtom[9];
            this._txmaster[txdoc.getTextType()] = txdoc = this.getSlideShow().getDocumentRecord().getEnvironment().getTxMasterStyleAtom();
            TxMasterStyleAtom[] txrec = ((MainMaster)this.getSheetContainer()).getTxMasterStyleAtoms();
            for (int i = 0; i < txrec.length; ++i) {
                this._txmaster[txrec[i].getTextType()] = txrec[i];
            }
        }
    }

    protected void onAddTextShape(TextShape shape) {
        TextRun run = shape.getTextRun();
        if (this._runs == null) {
            this._runs = new TextRun[]{run};
        } else {
            TextRun[] tmp = new TextRun[this._runs.length + 1];
            System.arraycopy(this._runs, 0, tmp, 0, this._runs.length);
            tmp[tmp.length - 1] = run;
            this._runs = tmp;
        }
    }
}

