/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OsTemplateXmlLoaderRewriter
extends DomWalker.Rewriter {
    public static final String OS_TEMPLATE_MIME = "os/template";
    public static final String OS_TEMPLATES_FEATURE_NAME = "opensocial-templates";
    private static final String PRELOAD_TPL = "gadgets.jsondom.preload_('%s',%s);";
    private final Converter converter;

    @Inject
    public OsTemplateXmlLoaderRewriter(Converter converter) {
        super(new GadgetHtmlVisitor(converter));
        this.converter = converter;
    }

    public boolean rewrite(HttpRequest request, HttpResponse original, MutableContent content) throws RewritingException {
        String mimeType = RewriterUtils.getMimeType(request, original);
        if (OS_TEMPLATE_MIME.equalsIgnoreCase(mimeType)) {
            content.setContent(this.converter.domToJson(content.getContent()));
            return true;
        }
        return false;
    }

    public static class Converter {
        public static final String NAME_KEY = "n";
        public static final String VALUE_KEY = "v";
        public static final String CHILDREN_KEY = "c";
        public static final String ATTRIBS_KEY = "a";
        public static final String ERROR_KEY = "e";
        private final GadgetHtmlParser parser;
        private final DOMImplementation domImpl;

        @Inject
        public Converter(GadgetHtmlParser parser, DOMImplementation domImpl) {
            this.parser = parser;
            this.domImpl = domImpl;
        }

        public String domToJson(String xml) {
            try {
                Document doc = this.domImpl.createDocument(null, null, null);
                Element container = doc.createElement("template");
                this.parser.parseFragment(xml, container);
                return this.jsonFromElement(container).toString();
            }
            catch (GadgetException e) {
                return this.jsonError("Gadget Exception: " + e).toString();
            }
            catch (JSONException e) {
                return this.jsonError("JSON Exception: " + (Object)((Object)e)).toString();
            }
        }

        public JSONObject jsonFromElement(Element elem) throws JSONException {
            JSONObject json = new JSONObject();
            json.put(NAME_KEY, (Object)elem.getTagName());
            JSONArray attribs = new JSONArray();
            NamedNodeMap attribMap = elem.getAttributes();
            for (int i = 0; i < attribMap.getLength(); ++i) {
                JSONObject attrib = new JSONObject();
                Attr domAttrib = (Attr)attribMap.item(i);
                attrib.put(NAME_KEY, (Object)domAttrib.getNodeName());
                attrib.put(VALUE_KEY, (Object)domAttrib.getNodeValue());
                attribs.put((Object)attrib);
            }
            json.put(ATTRIBS_KEY, (Object)attribs);
            JSONArray children = new JSONArray();
            block5: for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getNodeType()) {
                    case 3: {
                        children.put((Object)((Text)child).getNodeValue());
                        continue block5;
                    }
                    case 1: 
                    case 9: {
                        children.put((Object)this.jsonFromElement((Element)child));
                        continue block5;
                    }
                }
            }
            json.put(CHILDREN_KEY, (Object)children);
            return json;
        }

        private JSONObject jsonError(String err) {
            JSONObject json = new JSONObject();
            try {
                json.put(ERROR_KEY, (Object)err);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return json;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GadgetHtmlVisitor
    implements DomWalker.Visitor {
        private final Converter converter;

        public GadgetHtmlVisitor(Converter converter) {
            this.converter = converter;
        }

        @Override
        public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
            if (node.getNodeType() == 1 && "div".equalsIgnoreCase(((Element)node).getTagName()) && OsTemplateXmlLoaderRewriter.OS_TEMPLATE_MIME.equalsIgnoreCase(((Element)node).getAttribute("type")) && (!StringUtils.isEmpty((String)((Element)node).getAttribute("id")) || !StringUtils.isEmpty((String)((Element)node).getAttribute("name")))) {
                return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
            }
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }

        @Override
        public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
            if (!gadget.getAllFeatures().contains(OsTemplateXmlLoaderRewriter.OS_TEMPLATES_FEATURE_NAME)) {
                return false;
            }
            Document doc = nodes.get(0).getOwnerDocument();
            Element docElem = doc.getDocumentElement();
            if (docElem == null) {
                throw new RewritingException("Unexpected error, missing document element", 500);
            }
            Node head = DomUtil.getFirstNamedChildNode((Node)doc.getDocumentElement(), (String)"head");
            if (head == null) {
                throw new RewritingException("Unexpected error, could not find <head> node", 500);
            }
            StringBuilder preloadScript = new StringBuilder();
            for (Node node : nodes) {
                Element elem = (Element)node;
                String value = elem.getTextContent();
                String id = elem.getAttribute("name");
                if (StringUtils.isEmpty((String)id)) {
                    id = elem.getAttribute("id");
                }
                preloadScript.append(String.format(OsTemplateXmlLoaderRewriter.PRELOAD_TPL, id, this.converter.domToJson(value)));
            }
            Element script = doc.createElement("script");
            script.setTextContent(preloadScript.toString());
            head.appendChild(script);
            return true;
        }
    }
}

