/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.Job;
import com.google.caja.ancillary.servlet.Processor;
import com.google.caja.ancillary.servlet.Request;
import com.google.caja.ancillary.servlet.Verb;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.GuessContentType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.util.Charsets;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StaticFiles {
    private final Map<String, Boolean> exists = StaticFiles.mruCache(1024);
    private final Map<String, Content> files = StaticFiles.mruCache(128);
    private final long startupTime = System.currentTimeMillis();
    private final long expiryDate = Math.max(this.startupTime + 1557628928L, 2147483647000L);
    final String cacheId;

    StaticFiles(String cacheId) {
        this.cacheId = cacheId;
    }

    boolean exists(String path) {
        boolean fileExists;
        if (this.files.containsKey(path)) {
            return true;
        }
        Boolean b = this.exists.get(path);
        if (b != null) {
            return b;
        }
        InputStream in = StaticFiles.class.getResourceAsStream(path);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            fileExists = true;
        } else {
            fileExists = false;
        }
        this.exists.put(path, fileExists);
        return fileExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serve(String path, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getDateHeader("If-modified-since") >= this.startupTime) {
            resp.setStatus(304);
            return;
        }
        Content content = this.files.get(path);
        if (content == null && !Boolean.FALSE.equals(this.exists.get(path))) {
            InputStream in = StaticFiles.class.getResourceAsStream(path);
            if (in == null) {
                this.exists.put(path, Boolean.FALSE);
            } else {
                block20: {
                    try {
                        int n;
                        ContentType t = GuessContentType.guess(null, path, null);
                        if (t != null && t.isText) {
                            InputSource is;
                            try {
                                is = new InputSource(StaticFiles.class.getResource(path).toURI());
                            }
                            catch (URISyntaxException ex) {
                                ex.printStackTrace();
                                is = InputSource.UNKNOWN;
                            }
                            CharProducer cp = CharProducer.Factory.create((Reader)new InputStreamReader(in, Charsets.UTF_8), is);
                            Request min = Request.create(Verb.ECHO, this);
                            min.minify = true;
                            min.opt = true;
                            min.otype = t;
                            Processor p = new Processor(min, DevNullMessageQueue.singleton());
                            try {
                                Job j = p.parse(cp.clone(), t, null, is.getUri());
                                List<Job> out = p.process(Lists.newArrayList(j));
                                if (out.size() == 1) {
                                    content = p.reduce(out);
                                }
                            }
                            catch (ParseException ex) {
                                ex.printStackTrace();
                            }
                            if (content == null) {
                                content = new Content(cp.toString(), t);
                            }
                            break block20;
                        }
                        ByteArrayOutputStream buf = new ByteArrayOutputStream();
                        byte[] bytes = new byte[4096];
                        while ((n = in.read(bytes)) > 0) {
                            buf.write(bytes, 0, n);
                        }
                        content = new Content(bytes, t);
                    }
                    finally {
                        in.close();
                    }
                }
                this.files.put(path, content);
            }
        }
        if (content != null) {
            PrintWriter out;
            resp.setStatus(200);
            String mimeType = StaticFiles.mimeTypeFor(content.type, path);
            if (mimeType != null) {
                resp.setContentType(mimeType);
            }
            resp.setDateHeader("Last-modified", this.startupTime);
            resp.setDateHeader("Expires", this.expiryDate);
            if (content.isText()) {
                out = resp.getWriter();
                content.toWriter(out);
                ((Writer)out).close();
            } else {
                out = resp.getOutputStream();
                content.toOutputStream((OutputStream)((Object)out));
                ((OutputStream)((Object)out)).close();
            }
        } else {
            resp.setStatus(404);
            resp.setContentType("text/plain");
            PrintWriter out = resp.getWriter();
            ((Writer)out).write("404 - I have no response to that.");
            ((Writer)out).close();
        }
    }

    private static String mimeTypeFor(ContentType t, String path) {
        if (t != null) {
            return t.isText ? t.mimeType + "; charset=UTF-8" : t.mimeType;
        }
        int dot = path.lastIndexOf(46);
        if (dot >= 0) {
            String ext = path.substring(dot + 1);
            if ("gif".equals(ext)) {
                return "image/gif";
            }
            if ("png".equals(ext)) {
                return "image/png";
            }
            if ("jpg".equals(ext)) {
                return "image/jpeg";
            }
        }
        return null;
    }

    private static <K, V> Map<K, V> mruCache(final int maxSize) {
        return Collections.synchronizedMap(new LinkedHashMap<K, V>(){

            @Override
            public boolean removeEldestEntry(Map.Entry<K, V> e) {
                return this.size() > maxSize;
            }
        });
    }
}

