/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Job;
import com.google.caja.ancillary.servlet.ZipFileSystem;
import com.google.caja.util.ContentType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;

public class ZipFileSystemTest
extends TestCase {
    public final void testCanonFile() throws IOException {
        ZipFileSystem zfs = new ZipFileSystem("/foo");
        ZipFileSystemTest.assertEquals((String)"/foo", (String)zfs.canonicalPath(""));
        ZipFileSystemTest.assertEquals((String)"/foo", (String)zfs.canonicalPath("."));
        ZipFileSystemTest.assertEquals((String)"/foo", (String)zfs.canonicalPath("bar/.."));
        ZipFileSystemTest.assertEquals((String)"/foo/bar", (String)zfs.canonicalPath("bar"));
        ZipFileSystemTest.assertEquals((String)"/foo/baz", (String)zfs.canonicalPath(".//baz"));
        ZipFileSystemTest.assertEquals((String)"/foo/baz", (String)zfs.canonicalPath(".//baz/"));
        ZipFileSystemTest.assertEquals((String)"/foo/bar/baz", (String)zfs.canonicalPath("/foo/bar/baz"));
        ZipFileSystemTest.assertEquals((String)"/foo/bar/baz", (String)zfs.canonicalPath("/foo/bar/baz/"));
        try {
            zfs.canonicalPath("..");
            ZipFileSystemTest.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            zfs.canonicalPath("foo/../..");
            ZipFileSystemTest.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            zfs.canonicalPath("foo/../../boo");
            ZipFileSystemTest.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            zfs.canonicalPath("/boo");
            ZipFileSystemTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void testBaseName() {
        ZipFileSystem zfs = new ZipFileSystem("/foo");
        ZipFileSystemTest.assertEquals((String)"", (String)zfs.basename(""));
        ZipFileSystemTest.assertEquals((String)"/", (String)zfs.basename("/"));
        ZipFileSystemTest.assertEquals((String)"foo", (String)zfs.basename("foo"));
        ZipFileSystemTest.assertEquals((String)"bar", (String)zfs.basename("bar"));
        ZipFileSystemTest.assertEquals((String)"bar", (String)zfs.basename("/foo/bar"));
        ZipFileSystemTest.assertEquals((String)"bar", (String)zfs.basename("/foo/bar/"));
    }

    public final void testDirName() {
        ZipFileSystem zfs = new ZipFileSystem("/foo");
        ZipFileSystemTest.assertEquals(null, (String)zfs.dirname(""));
        ZipFileSystemTest.assertEquals((String)"/", (String)zfs.dirname("/"));
        ZipFileSystemTest.assertEquals(null, (String)zfs.dirname("foo"));
        ZipFileSystemTest.assertEquals(null, (String)zfs.dirname("bar"));
        ZipFileSystemTest.assertEquals((String)"/foo", (String)zfs.dirname("/foo/bar"));
        ZipFileSystemTest.assertEquals((String)"/foo", (String)zfs.dirname("/foo/bar/"));
        ZipFileSystemTest.assertEquals((String)"foo", (String)zfs.dirname("foo/bar"));
    }

    public final void testJoin() {
        ZipFileSystem zfs = new ZipFileSystem("/foo");
        ZipFileSystemTest.assertEquals((String)"foo", (String)zfs.join(null, "foo"));
        ZipFileSystemTest.assertEquals((String)"bar", (String)zfs.join(null, "bar"));
        ZipFileSystemTest.assertEquals((String)"foo/bar", (String)zfs.join("foo", "bar"));
        ZipFileSystemTest.assertEquals((String)"/foo/bar", (String)zfs.join("/foo", "bar"));
        ZipFileSystemTest.assertEquals((String)"foo", (String)zfs.join("foo", ""));
        ZipFileSystemTest.assertEquals((String)"/foo", (String)zfs.join("/foo", ""));
    }

    public final void testWriteAndRetrieveText() throws IOException {
        ZipFileSystem zfs = new ZipFileSystem("/foo");
        ZipFileSystemTest.assertFalse((boolean)zfs.exists("/foo/bar"));
        try {
            ZipFileSystemTest.assertEquals((String)"", (String)zfs.read("/foo/bar").toString());
            ZipFileSystemTest.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        Writer out = zfs.write("bar");
        ZipFileSystemTest.assertTrue((boolean)zfs.exists("/foo/bar"));
        ZipFileSystemTest.assertEquals((String)"", (String)zfs.read("bar").toString());
        ZipFileSystemTest.assertEquals((String)"", (String)zfs.read("/foo/bar").toString());
        out.write("Hello, World!");
        out.close();
        ZipFileSystemTest.assertTrue((boolean)zfs.exists("/foo/bar"));
        ZipFileSystemTest.assertEquals((String)"Hello, World!", (String)zfs.read("bar").toString());
        ZipFileSystemTest.assertEquals((String)"Hello, World!", (String)zfs.read("/foo/bar").toString());
    }

    public final void testWriteAndRetrieveBinary() throws IOException {
        ZipFileSystem zfs = new ZipFileSystem("/foo");
        ZipFileSystemTest.assertFalse((boolean)zfs.exists("/foo/bar"));
        try {
            ZipFileSystemTest.assertEquals((String)"", (String)zfs.read("/foo/bar").toString());
            ZipFileSystemTest.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        OutputStream out = zfs.writeBytes("bar");
        ZipFileSystemTest.assertTrue((boolean)zfs.exists("/foo/bar"));
        ZipFileSystemTest.assertEquals((String)"", (String)zfs.read("bar").toString());
        ZipFileSystemTest.assertEquals((String)"", (String)zfs.read("/foo/bar").toString());
        out.write(new byte[]{18, 52});
        out.close();
        ZipFileSystemTest.assertTrue((boolean)zfs.exists("/foo/bar"));
        try {
            zfs.read("/foo/bar");
            ZipFileSystemTest.fail();
        }
        catch (IOException ex) {
            ZipFileSystemTest.assertEquals((String)"cannot read binary file", (String)ex.getMessage());
        }
    }

    public final void testToZip() throws IOException {
        ZipFileSystem zfs = new ZipFileSystem("/root");
        zfs.mkdir("/root/dir");
        Writer text = zfs.write("dir/text.txt");
        text.write("TEXT");
        text.close();
        OutputStream binary = zfs.writeBytes("binary.bin");
        binary.write(new byte[]{18, 52, 86, 120});
        binary.close();
        Job zipFile = zfs.toZip();
        ZipFileSystemTest.assertEquals((Object)((Object)ContentType.ZIP), (Object)((Object)zipFile.t));
        ZipFileSystemTest.assertTrue((boolean)(zipFile.root instanceof byte[]));
        ZipInputStream in = new ZipInputStream(new ByteArrayInputStream((byte[])zipFile.root));
        ZipEntry e = in.getNextEntry();
        ZipFileSystemTest.assertEquals((String)"/root/", (String)e.getName());
        ZipFileSystemTest.assertTrue((boolean)e.isDirectory());
        e = in.getNextEntry();
        ZipFileSystemTest.assertEquals((String)"/root/dir/", (String)e.getName());
        ZipFileSystemTest.assertTrue((boolean)e.isDirectory());
        e = in.getNextEntry();
        ZipFileSystemTest.assertEquals((String)"/root/dir/text.txt", (String)e.getName());
        ZipFileSystemTest.assertFalse((boolean)e.isDirectory());
        ZipFileSystemTest.assertEquals((int)84, (int)in.read());
        ZipFileSystemTest.assertEquals((int)69, (int)in.read());
        ZipFileSystemTest.assertEquals((int)88, (int)in.read());
        ZipFileSystemTest.assertEquals((int)84, (int)in.read());
        ZipFileSystemTest.assertEquals((int)-1, (int)in.read());
        e = in.getNextEntry();
        ZipFileSystemTest.assertEquals((String)"/root/binary.bin", (String)e.getName());
        ZipFileSystemTest.assertFalse((boolean)e.isDirectory());
        ZipFileSystemTest.assertEquals((int)18, (int)in.read());
        ZipFileSystemTest.assertEquals((int)52, (int)in.read());
        ZipFileSystemTest.assertEquals((int)86, (int)in.read());
        ZipFileSystemTest.assertEquals((int)120, (int)in.read());
        ZipFileSystemTest.assertEquals((int)-1, (int)in.read());
        ZipFileSystemTest.assertNull((Object)in.getNextEntry());
        in.close();
    }
}

