/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Punctuation;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.util.Criterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsTokenQueue
extends TokenQueue<JsTokenType> {
    public static final Criterion<Token<JsTokenType>> NO_COMMENT = new Criterion<Token<JsTokenType>>(){

        @Override
        public boolean accept(Token<JsTokenType> t) {
            return JsTokenType.COMMENT != t.type && JsTokenType.LINE_CONTINUATION != t.type;
        }
    };

    public JsTokenQueue(TokenStream<JsTokenType> lexer, InputSource file) {
        this(lexer, file, NO_COMMENT);
    }

    public JsTokenQueue(TokenStream<JsTokenType> lexer, InputSource file, Criterion<Token<JsTokenType>> filter) {
        super(lexer, file, filter);
    }

    public boolean checkToken(Punctuation p) throws ParseException {
        return this.checkToken(p.toString());
    }

    public boolean checkToken(Keyword kw) throws ParseException {
        return this.checkToken(kw.toString());
    }

    public void expectToken(Punctuation p) throws ParseException {
        this.expectToken(p.toString());
    }

    public void expectToken(Keyword kw) throws ParseException {
        this.expectToken(kw.toString());
    }

    public boolean lookaheadToken(Punctuation p) throws ParseException {
        return this.lookaheadToken(p.toString());
    }

    public boolean lookaheadToken(Keyword kw) throws ParseException {
        return this.lookaheadToken(kw.toString());
    }
}

