/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.html.OpenElementStack;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class AbstractElementStack
implements OpenElementStack {
    protected static final boolean DEBUG = false;
    protected final Document doc;
    protected final boolean needsDebugData;
    private final DocumentFragment rootElement;
    private final List<OpenNode> openNodes = Lists.newArrayList();

    AbstractElementStack(Document doc, Namespaces ns, boolean needsDebugData) {
        this.doc = doc;
        this.needsDebugData = needsDebugData;
        this.rootElement = doc.createDocumentFragment();
        this.openNodes.add(new OpenNode(this.rootElement, ns, null));
    }

    public final Document getDocument() {
        return this.doc;
    }

    public final DocumentFragment getRootElement() {
        return this.rootElement;
    }

    public void open(boolean fragment) {
    }

    protected final OpenNode getBottom() {
        return this.openNodes.get(this.openNodes.size() - 1);
    }

    protected final int getNOpenElements() {
        return this.openNodes.size();
    }

    protected final Element getElement(int index) {
        assert (index > 0) : "" + index;
        return (Element)this.openNodes.get((int)index).n;
    }

    protected final void push(Element el, Namespaces ns, String qname) {
        Node parent = this.getBottom().n;
        this.openNodes.add(new OpenNode(el, ns, qname));
        this.doAppend(el, parent);
    }

    protected void doAppend(Node el, Node parent) {
        parent.appendChild(el);
    }

    protected final void popN(int n, FilePosition endPos) {
        n = Math.min(n, this.openNodes.size() - 1);
        while (--n >= 0) {
            Node node = this.openNodes.remove((int)(this.openNodes.size() - 1)).n;
            if (!this.needsDebugData) continue;
            Nodes.setFilePositionFor(node, FilePosition.span(Nodes.getFilePositionFor(node), endPos));
            if (this.openNodes.size() != 1) continue;
            FilePosition rootPos = Nodes.getFilePositionFor(this.rootElement);
            if (rootPos.endCharInFile() <= 1) {
                rootPos = Nodes.getFilePositionFor(this.rootElement.getFirstChild());
            }
            if (rootPos.startCharInFile() > endPos.startCharInFile()) continue;
            Nodes.setFilePositionFor(this.rootElement, FilePosition.span(rootPos, endPos));
        }
    }

    protected void stripIgnorableText() {
        Node lastChild;
        if (this.rootElement.getFirstChild() == null) {
            return;
        }
        Node firstChild = this.rootElement.getFirstChild();
        if (AbstractElementStack.isIgnorableTextNode(firstChild)) {
            this.rootElement.removeChild(firstChild);
            if (this.rootElement.getFirstChild() == null) {
                return;
            }
        }
        if (AbstractElementStack.isIgnorableTextNode(lastChild = this.rootElement.getLastChild())) {
            this.rootElement.removeChild(lastChild);
        }
    }

    private static boolean isIgnorableTextNode(Node t) {
        return t.getNodeType() == 3 && "".equals(t.getNodeValue().trim());
    }

    static Namespaces unknownNamespace(FilePosition pos, Namespaces ns, String qname, MessageQueue mq) {
        int colon = qname.indexOf(58);
        String prefix = colon >= 0 ? qname.substring(0, colon) : "";
        mq.addMessage((MessageTypeInt)MessageType.NO_SUCH_NAMESPACE, pos, MessagePart.Factory.valueOf(prefix), MessagePart.Factory.valueOf(qname));
        return new Namespaces(ns, prefix, "unknown:///" + prefix);
    }

    static class OpenNode {
        final Node n;
        final Namespaces ns;
        final String qname;

        OpenNode(Node n, Namespaces ns, String qname) {
            this.n = n;
            this.ns = ns;
            this.qname = qname;
        }
    }
}

